<?php

namespace App\Exports;

use App\Models\User;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithHeadings;

class DoctorsExport implements FromCollection, WithMapping, WithHeadings
{
    public function collection()
    {
        // Fetch users with role_id 3 (Doctors)
        return User::where('role_id', 3)->get();
    }

    public function map($user): array
    {
        return [
            $user->fname,
            $user->lname,
            $user->phone,
            $user->email,
            $user->gender,
            isset($user->country->name) ? $user->country->name : 'not selected',
            isset($user->state->name) ? $user->state->name : 'not selected',
            isset($user->city->name) ? $user->city->name : 'not selected',
            $user->doctorAge, // How Many Myositis Patients the doctor sees in a year, as per your description
            $user->created_at,
            $user->dob,
            $user->doctorSpeciality,
            $user->message,
        ];
    }

    public function headings(): array
    {
        return [
            'First Name',
            'Last Name',
            'Phone',
            'Email',
            'Gender',
            'Country',
            'State',
            'City',
            'How Many Myositis Patients do you see in a year?', // Adjusted heading to match the data
            'Timestamps', // Assuming this is meant to be the created_at field
            'DOB', // Date of Birth
            'Speciality/Area',
            'Message',
        ];
    }
}
