<?php


namespace App\Exports;

use App\Models\Mab;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithHeadings;

class MabExport implements FromCollection, WithMapping, WithHeadings
{
    public function collection()
    {
        return Mab::all();
    }

    public function map($mab): array
    {
        return [
            $mab->name,
            $mab->city,
            $mab->message,
        ];
    }

    public function headings(): array
    {
        return [
            'Mab Name',
            'Mab City',
            'Message',
        ];
    }
}
