<?php
 namespace App\Exports;

 use App\Models\User;
 use Maatwebsite\Excel\Concerns\WithHeadings;
 use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithMapping;
 
 class PatientsExport implements FromCollection, WithMapping, WithHeadings
 {
     

     public function collection()
     {
         return User::where('role_id', 2)->get();
     }
     
     public function map($user): array
     {
         return [
              
             $user->fname,
             $user->lname,
             $user->email,
             $user->phone,
             isset($user->country->name) ? $user->country->name : 'not selected',
             isset($user->state->name) ? $user->state->name : 'not selected',
             isset($user->city->name) ? $user->city->name : 'not selected',
             isset($user->disease->name) ? $user->disease->name : 'not selected',
             $user->gender,
             $user->created_at,
             $user->dob,
             $user->doctorName,
             $user->message,
             
         ];
     }
 
     public function headings(): array
     {
         return [
            
             'First Name',
             'Last Name',
             'Email',
             'Phone',
             'Country',
             'State',
             'City',
             'Type of Myositis',
             'Gender',
             'Timestamps',
             'Age / DOB',
             'Doctor Name',
             'Message'
         ];
     }
 
 }
 