<?php

namespace App\Exports;

use App\Models\User;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithHeadings;

class VolunteersExport implements FromCollection, WithMapping, WithHeadings
{
    public function collection()
    {
        return User::where('role_id', 4)->get();
    }


    public function map($user): array
    {
        return [
            $user->fname,
            $user->lname,
            $user->phone,
            $user->email,
            $user->gender,
            isset($user->country->name) ? $user->country->name : 'not selected',
            isset($user->state->name) ? $user->state->name : 'not selected',
            isset($user->city->name) ? $user->city->name : 'not selected',
            $user->created_at,
            $user->dob,
          
            $user->message,
        ];
    }

    public function headings(): array
    {
        return [
            'First Name',
            'Last Name',
            'Phone',
            'Email',
            'Gender',
            'Country',
            'State',
            'City',
            'Timestamps',
            'age',
            'Message',
        ];
    }





}

 