<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Auth;
use Illuminate\Support\Facades\Mail;
use Illuminate\Mail\Message;

class AdminController extends Controller
{
    public function index()
    {
        return view('backend.auth.login');
    }


    public function login(Request $request)
    {
        $request->validate([
            'email' => 'required',
            'password' => 'required',
        ]);
        $role = User::where('email', $request->input('email'))->first();

        if ($role && $role->role_id == 1 && $role->user_type == 'admin') {
            $credentials = $request->only('email', 'password');
            if (Auth::attempt($credentials)) {
                return redirect()->route('admin.dashboard')->withSuccess('You have Successfully loggedin');
            }
        }

        return redirect("admin/login")->withSuccess('Oppes! You have entered invalid credentials');
    }

    public function dashboard(Request $request)
    {
        $totalDoctor = User::where('role_id' , '3')->count();
        $totalPatient = User::where('role_id' , '2')->count();
        return view('backend.admin.dashboard', compact('totalDoctor','totalPatient'));
    }

    /* public function sendEmails(Request $request)
    {
        $memberType = $request->input('typeofMember');
        $emailContent = nl2br($request->input('email_content'));  
        $attachment = $request->file('attachment');
        $users = User::where('role_id', $this->getRoleIdForMemberType($memberType))->get();
    
        foreach ($users as $user) {
            $userEmail = $user->email;
            $userName = $user->fname . ' ' . $user->lname;
    
            try {
                Mail::send([], [], function (Message $message) use ($userEmail, $userName, $emailContent, $attachment) {
                    $message->to($userEmail)->subject('Special Announcement from Myositis India');
                    $message->setBody($emailContent, 'text/html');  
    
                    if ($attachment) {
                        $message->attach($attachment->getRealPath(), [
                            'as' => $attachment->getClientOriginalName(),
                            'mime' => $attachment->getClientMimeType(),
                        ]);
                    }
                });
            } catch (\Exception $e) {
                return back()->with("error", "An error occurred while sending the email. Please try again later.");
            }
        }
    
        return back()->with("success", "Emails sent to all selected members.");
    }
     */


/* 
     public function sendEmails(Request $request)
{
    $memberType = $request->input('typeofMember');
    $emailContent = nl2br($request->input('email_content'));  
    $attachment = $request->file('attachment');
    $users = User::where('role_id', $this->getRoleIdForMemberType($memberType))->get();

    foreach ($users as $user) {
        $userEmail = $user->email;
        $userName = $user->fname . ' ' . $user->lname;

        try {
            Mail::send([], [], function (Message $message) use ($userEmail, $userName, $emailContent, $attachment) {
                $message->to($userEmail)->subject('Special Announcement from Myositis India');
                $message->setBody($emailContent, 'text/html');  

                if ($attachment) {
                    $message->attach($attachment->getRealPath(), [
                        'as' => $attachment->getClientOriginalName(),
                        'mime' => $attachment->getClientMimeType(),
                    ]);
                }
            });
        } catch (\Exception $e) {
            // Log the exception if needed
            continue; // Continue to the next email even if an exception occurs
        }
    }

    return back()->with("success", "Emails sent to all selected members.");
}

 */


 public function sendEmails(Request $request)
{
    $memberType = $request->input('typeofMember');
    $emailContent = nl2br($request->input('email_content'));  
    $attachment = $request->file('attachment');
    $users = User::where('role_id', $this->getRoleIdForMemberType($memberType))->get();

    foreach ($users as $user) {
        $userEmail = $user->email;
        $userName = $user->fname . ' ' . $user->lname;

        try {
            Mail::send([], [], function (Message $message) use ($userEmail, $userName, $emailContent, $attachment) {
                $message->to($userEmail)->subject('Special Announcement from Myositis India');
                $message->setBody($emailContent, 'text/html');  

                if ($attachment) {
                    $message->attach($attachment->getRealPath(), [
                        'as' => $attachment->getClientOriginalName(),
                        'mime' => $attachment->getClientMimeType(),
                    ]);
                }
            });
        } catch (\Exception $e) {
            continue;  
        }
    }

    return back()->with("success", "Emails sent to all selected members.");
}








    private function getRoleIdForMemberType($memberType)
    {
        switch ($memberType) {
            case 'Doctor':
                return 3;  
            case 'Patient':
                return 2;  
            case 'Volunteer':
                return 4; 
            default:
                return null;
        }
    }
    
public function emailIndex()
{
    return view('emails.index');
}








}
