<?php

namespace App\Http\Controllers;

use App\Models\Appointment;
use App\Models\Disease;
use App\Models\User;
use Illuminate\Http\Request;
use Auth;
 
class AppointmentController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $disease = Disease::where('status', 1)->latest()->get();
        $doctors = User::where(['status' => 1, 'role_id' => 3])->latest()->get();
        return view('appointment', compact('disease', 'doctors'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = new Appointment();
        if (Auth::check()) {
            $data->user_id = Auth::user()->id;
        }
        $data->doctor_id = $request->input('doctor_id');
        $data->disease_id = $request->input('disease_id');
        $data->message = $request->input('message');
        $data->status = 1;
        $data->save();

        return redirect()->back()->with('success','Your appointment has been booked successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Appointment  $appointment
     * @return \Illuminate\Http\Response
     */
    public function show(Appointment $appointment)
    {
        //Admin
        $data = Appointment::latest()->get();
        // dd($data);
        return view('backend.admin.appointment.index', compact('data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Appointment  $appointment
     * @return \Illuminate\Http\Response
     */
    public function edit(Appointment $appointment)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Appointment  $appointment
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Appointment $appointment)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Appointment  $appointment
     * @return \Illuminate\Http\Response
     */
    public function destroy(Appointment $appointment)
    {
        //
    }

    public function status($id, $status)
    {
        $data = Appointment::findOrFail($id);
        $data->status = $status;
        $data->save();

        return redirect()->route('admin.appointment.show');
    }
}
