<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Auth;
use Session;

class LoginController extends Controller
{
    public function index()
    {
        return view('auth.login');
    }

    public function login(Request $request)
    {
        $request->validate([
            'email' => 'required',
            'password' => 'required',
        ]);
        $role = User::where('email', $request->input('email'))->first();

        
        if ($role) {
            $credentials = $request->only('email', 'password');
            if (Auth::attempt($credentials)) {
                if ($role->role_id == 3) {
                    return redirect()
                        ->route('doctor.dashboard')
                        ->withSuccess('You have Successfully loggedin');
                } elseif($role->role_id == 4){
                    return redirect()->route('volunteer.dashboard');
                }elseif($role->role_id == 1){
                    return redirect()->route('admin.dashboard');
                }
                else {
                    return redirect()
                        ->route('patient.dashboard')
                        ->withSuccess('You have Successfully loggedin');
                }
            }
        }

        return redirect('login')->withErrors(['email' => 'These credentials do not match our records'])->withInput();
    }

    public function logout(Request $request)
    {
        Session::flush();
        Auth::logout();

        return Redirect('login');
    }


   
}
