<?php

namespace App\Http\Controllers\Auth;

use App\Models\City;
use App\Models\User;
use App\Models\State;
use App\Models\Country;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Mail\UserRegisteredNotification;
use Illuminate\Support\Facades\Hash;
use Auth;
use App\Models\Disease;
use Illuminate\Support\Facades\Mail;
use Illuminate\Mail\Message;


class RegisterController extends Controller
{

    public function index()
    {
        $counteries = Country::get(['name', 'id']);
        $disease = Disease::where('status', 1)->latest()->get();
        $doctors = User::where(['status' => 1, 'role_id' => 3])->latest()->get();
        return view('auth.register', compact('disease', 'doctors', 'counteries'));
    }



    public function fatchState(Request $request)
    {
        $data['states'] = State::where('country_id', $request->country_id)->get(['name', 'id']);

        return response()->json($data);
    }

    public function fatchCity(Request $request)
    {
        $data['cities'] = City::where('state_id', $request->state_id)->get(['name', 'id']);

        return response()->json($data);
    }
    public function register(Request $request)
    {

        $request->validate([
            'fname' => 'required',
            'lname' => 'required',
            'phone' => 'required',
            'email' => 'required|email|unique:users,email',
            'password' => 'required|min:6',
            
        ]);

        $data = new User();
        $data->fname = $request->input('fname');
        $data->lname = $request->input('lname');
        $data->phone = $request->input('phone');
        $data->email = $request->input('email');
        $data->password = Hash::make($request->input('password'));
        $data->country_id = $request->input('country');
        $data->state_id = $request->input('state');
        $data->city_id = $request->input('city');
        $data->gender = $request->input('gender');
        $data->dob = $request->input('dob');
        $data->doctorName = $request->input('doctorName');
        $data->message = $request->input('message');
        $data->disease_id = $request->input('disease_id');
        $data->terms = $request->has('terms') ? 1 : 0; 
        $data->doctorAge = $request->input('age');
        $data->doctorSpeciality = $request->input('doctorSpeciality');
        $data->status = 1;
        if ($request->input('role') == 3) {
            $data->role_id = 3;
            $data->user_type = "doctor";
        } elseif ($request->input('role') == 4) {
            $data->role_id = 4;
            $data->user_type = "volunteer";
        } else {
            $data->role_id = 2;
            $data->user_type = "patient";
        }

        $data->save();

        $userEmail = $data->email;
        $userName = $data->fname . ' ' . $data->lname;

        $emailContent = "Dear $userName,\n\nThank you for registering with Myositis India!,\nWe look forward to connecting with you and working towards our common goal of improving the lives of patients with myositis in India. We encourage you to reach out to us with any questions, ideas or stories that you would like to share by replying to this email.If you have not done so already, \n\nplease do check out our other social media pages and follow us on: \nInstagram: https://www.instagram.com/myositis_india/ \nTwitter:  https://x.com/myositis_india \nFacebook: https://www.facebook.com/myositisindia \nWebsite: https://myositisindia.org/ \nHave a great day!\nBest wishes,Team Myositis India.";
        // Send email notification to the admin
        Mail::to('india.myositis@gmail.com')->send(new UserRegisteredNotification($data));
        try {
            Mail::raw($emailContent, function (Message $message) use ($userEmail, $userName) {
                $message->to($userEmail)->subject('Thank You for Registering');
            });



            return back()->with("success", $userName . ", you are registered successfully! ");
        } catch (\Exception $e) {
            return back()->with("error", "An error occurred while sending the thank-you email. Please try again later.");
        }
    }
    
    public function doctorregistration()
    {
        $counteries = Country::get(['name', 'id']);
        $disease = Disease::where('status', 1)->latest()->get();
        $doctors = User::where(['status' => 1, 'role_id' => 3])->latest()->get();
        return view('auth.doctorregistration', compact('disease', 'doctors', 'counteries'));
    }


    public function volunteerregistration()
    {
        return view('backend.admin.volunteer.dasboard');
    }
}
