<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
 use Laravel\Socialite\Facades\Socialite;

class SocialiteController extends Controller
{
    public function redirectToProvider()
    {
        return Socialite::driver('facebook')
            ->scopes(['instagram_basic', 'instagram_content_publish'])
            ->redirect();
    }

    public function handleCallback()
    {
        $user = Socialite::driver('facebook')->user();

        // Save the user access token to use for Instagram API requests
        // $user->token contains the access token
        // Implement your saving logic here

        // Redirect or display a success message
        return redirect('/')->with('success', 'Instagram connected successfully!');
    }

}
