<?php

namespace App\Http\Controllers;

use App\Models\City;
use App\Models\State;
use Illuminate\Http\Request;

class CityController extends Controller
{

    public function index()
    {
        $data = City::latest()->get();
        return view('backend.admin.city.index', compact('data'));
    }

    public function create()
    {
        $states = State::where('status', 1)->latest()->get();
        return view('backend.admin.city.create', compact('states'));
    }

    public function store(Request $request)
    {
        $data = new City();
        $data->state_id = $request->input('state_id');
        $data->name = $request->input('name');
        $data->status = 1;
        $data->save();

        return redirect()->route('admin.city');
    }

    public function edit($id)
    {
        $data = City::findOrFail($id);
        $states = State::where('status', 1)->latest()->get();
        return view('backend.admin.city.edit', compact('data', 'states'));
    }

    public function update(Request $request)
    {
        $data = City::findOrFail($request->input('id'));
        $data->state_id = $request->input('state_id');
        $data->name = $request->input('name');
        $data->save();

        return redirect()->route('admin.city');
    }

    public function status($id, $status)
    {
        $data = City::findOrFail($id);
        $data->status = $status;
        $data->save();

        return redirect()->route('admin.city');
    }
}
