<?php

namespace App\Http\Controllers;

use App\Models\Country;
use Illuminate\Http\Request;

class CountryController extends Controller
{

    public function index()
    {
        $data = Country::latest()->get();
        return view('backend.admin.country.index', compact('data'));
    }

    public function create()
    {
        return view('backend.admin.country.create');
    }

    public function store(Request $request)
    {
        $data = new Country();
        $data->name = $request->input('name');
        $data->status = 1;
        $data->save();

        return redirect()->route('admin.country');
    }

    public function edit($id)
    {
        $data = Country::findOrFail($id);
        return view('backend.admin.country.edit', compact('data'));
    }

    public function update(Request $request)
    {
        $data = Country::findOrFail($request->input('id'));
        $data->name = $request->input('name');
        $data->save();

        return redirect()->route('admin.country');
    }

    public function status($id, $status)
    {
        $data = Country::findOrFail($id);
        $data->status = $status;
        $data->save();

        return redirect()->route('admin.country');
    }
}
