<?php

namespace App\Http\Controllers;

use App\Models\Disease;
use Illuminate\Http\Request;

class DiseaseController extends Controller
{

    public function index()
    {
        $data = Disease::latest()->get();
        return view('backend.admin.disease.index', compact('data'));
    }

    public function create()
    {
        return view('backend.admin.disease.create');
    }

    public function store(Request $request)
    {
        $data = new Disease();
        $data->name = $request->input('name');
        $data->status = 1;
        $data->save();

        return redirect()->route('admin.disease');
    }

    public function edit($id)
    {
        $data = Disease::findOrFail($id);
        return view('backend.admin.disease.edit', compact('data'));
    }

    public function update(Request $request)
    {
        $data = Disease::findOrFail($request->input('id'));
        $data->name = $request->input('name');
        $data->save();

        return redirect()->route('admin.disease');
    }

    public function status($id, $status)
    {
        $data = Disease::findOrFail($id);
        $data->status = $status;
        $data->save();

        return redirect()->route('admin.disease');
    }
}
