<?php

namespace App\Http\Controllers;

use App\Models\Donate;
use App\Models\Mab;
use App\Models\User;
use Illuminate\Http\Request;

class DonateController extends Controller
{
    public function donateonline(Request $request)
    {
        return view('donateonline');
    }

    public function donate(Request $request)
    {
        $volunteer = User::where('role_id',4)->get();
        $mab = Mab::all();
        return view('donate',compact('mab','volunteer'));
    }


    public function store(Request $request)
{
    $panNumber = $request->input('pan_number');
    $isValid = preg_match('/^([A-Z]){5}([0-9]){4}([A-Z]){1}?$/', $panNumber);

    if ($isValid) {
        // Store the data in the donates table
        $donate = new Donate();
        $donate->name = $request->input('name');
        $donate->pan_number = $panNumber;
        $donate->save();
        
        return redirect('https://www.instamojo.com/@Myositisindia/');
    } else {
        $request->flashOnly('name','pan_number');
         return back()->withErrors(['pan_number' => 'Invalid PAN number!']);
    }
}

public function showQRcode(){
    return view('showqrcode');
}


}
