<?php

namespace App\Http\Controllers;

use App\Mail\UserAppointmentNotification;
use App\Mail\AdminAppointmentNotification;
use Illuminate\Support\Facades\Mail;
use App\Models\Enquiry;
use Illuminate\Http\Request;
use App\Mail\AppointmentConfirmation;
use Illuminate\Support\Facades\Notification;
use App\Notifications\NewAppointmentNotification;
use Illuminate\Support\Facades\Validator;
 

class EnquiryController extends Controller
{
     


    public function show()
    {
        return view('enquiry');
    }

 

public function enquiryStore(Request $request)
{
    // List of spam email domains to block
    $blockedDomains = ['spamdomain.com', 'tempmail.com', 'yopmail.com'];

    // Extract the email domain
    $email = $request->input('email');
    $emailDomain = substr(strrchr($email, "@"), 1); // Get domain after '@'

    // Validation Rules (No Regex for Email)
    $rules = [
        'name' => 'required|string|min:3|max:50',
        'email' => 'required|email',
        'phone' => 'required|digits_between:10,15', // Ensures only numeric values
        'age' => 'required|integer|min:10|max:100',
        'country' => 'required|string|min:2|max:50',
        'state' => 'required|string|min:2|max:50',
        'city' => 'required|string|min:2|max:50',
        'message' => 'required|string|min:20|max:1000',
        'gender' => 'required|in:Male,Female,Other',
    ];

    // Validate Request
    $validator = Validator::make($request->all(), $rules);
    
    // Manually check for spam email domain
    if (in_array(strtolower($emailDomain), $blockedDomains)) {
        $validator->errors()->add('email', 'Emails from this domain are not allowed.');
    }

    if ($validator->fails()) {
        return redirect()->back()->withErrors($validator)->withInput();
    }

    // Store Enquiry
    $data = new Enquiry();
    $data->name = $request->input('name');
    $data->email = $request->input('email');
    $data->phone = $request->input('phone');
    $data->age = $request->input('age');
    $data->country = $request->input('country');
    $data->state = $request->input('state');
    $data->city = $request->input('city');
    $data->message = $request->input('message');
    $data->gender = $request->input('gender');
    $data->save();

    // Send Emails
    $userAppointmentData = $request->all();
    Mail::to($userAppointmentData['email'])->send(new UserAppointmentNotification($userAppointmentData));
    $adminEmail = 'india.myositis@gmail.com';
    Mail::to($adminEmail)->send(new AdminAppointmentNotification($userAppointmentData));

    return redirect()->back()->with('success', 'Your appointment request has been submitted, our team will contact you soon.');
}



    public function enquiryShow(Request $request)
    {
        $enquiryData = Enquiry::orderBy('created_at', 'desc')->get();
        return view('backend.admin.appointment.patientenquiry', compact('enquiryData'));
    }
}
