<?php

namespace App\Http\Controllers;

use App\Exports\DoctorsExport;
use App\Exports\VolunteersExport;
use App\Exports\PatientsExport;
use App\Exports\MabExport;
use Maatwebsite\Excel\Facades\Excel;

class ExportController extends Controller
{
    public function exportDoctors()
    {
        return Excel::download(new DoctorsExport(), 'doctors.xlsx');
    }

    public function exportVolunteers()
    {
        return Excel::download(new VolunteersExport(), 'volunteers.xlsx');
    }

    public function exportPatients()
    {
        return Excel::download(new PatientsExport(), 'patients.xlsx');
    }


    public function exportMab()
    {
        return Excel::download(new MabExport(), 'Mab.xlsx');
    }
}
