<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Comment;
use App\Models\Country;
use App\Models\Disease;
use App\Models\GoogleForm;
use App\Models\Mab;
use App\Models\User;
use App\Models\PatientAmbassador;
use App\Models\TeamMember;


class HomeController extends Controller
{
    public function shared_myositis_india_files()
    {
        return view('shared_myositis_india_files');
    }
    
    public function index(Request $request)
    {
        $pam = PatientAmbassador::get();
        $mab = Mab::all();
        $teams = TeamMember::get();
        return view('index',compact('mab','pam','teams'));
    }
    public function about()
    {
        return view('about');
    }
    public function mission()
    {
        return view('mission');
    }
  
    public function blog()
    {
        return view('blog');
    }
    public function blogone(Request $request)
    {
        $comments = Comment::where('parent_id',1)->get();
        return view('understanding-blog-details',compact('comments'));
    }
    public function blogtwo()
    {
        return view('the-importance-blog-details');
    }
    public function blogthree()
    {
        return view('myositisand-exercise-blog-details');
    }
     public function termcondition()
    {
        return view('termcondition');
    }


    //Myositis
    public function aboutmyositis(Request $request)
    {
        $mab = Mab::all();
        return view('myositis.aboutmyositis',compact('mab'));
    }
    public function myotreatment()
    {
        return view('myositis.myotreatment');
    }
    public function contact()
    {
        return view('contact');
    }
    public function samantha()
    {
        return view('samantha');
    }

    public function typesofmyositis()
    {
        return view('myositis.typesofmyositis');
    }
    //types of myositis
    public function Dermatomyositis()
    {
        return view('myositis.Dermatomyositis');
    }
    public function Polymyositis()
    {
        return view('myositis.Polymyositis');
    }
    public function NecrotizingMyopathy()
    {
        return view('myositis.Necrotizing');
    }
    public function InclusionBodyMyositis()
    {
        return view('myositis.ibm');
    }
    public function JuvenileMyositis()
    {
        return view('myositis.Juvenile');
    }
    public function diagnosis()
    {
        return view('myositis.diagnosis');
    }
    public function complication()
    {
        return view('myositis.complication');
    }


    //patietns
    public function bharatsharma()
    {
        return view('patientstory.bharatsharma');
    }
    public function ishika()
    {
        return view('patientstory.ishika');
    }
    public function ajay()
    {
        return view('patientstory.ajay');
    }

    public function ankit()
    {
        return view('patientstory.ankita');
    }
    public function damchen()
    {
        return view('patientstory.demchan');
    }
    public function sarika()
    {
        return view('patientstory.sarika');
    }
    public function rishi()
    {
        return view('patientstory.rishi');
    }
    public function shallyPuri(){
        return view('patientstory.shallyPuri');
    }






    public function patientstory(Request $request)
    {
        $pam = PatientAmbassador::get();
        return view('patientstory.patientstory',compact('pam'));
    }
    public function volunteer()
    { 
        $counteries = Country::get(['name','id']);
        $disease = Disease::where('status', 1)->latest()->get();
        $doctors = User::where(['status' => 1, 'role_id' => 3])->latest()->get();
        return view('volunteer', compact('disease', 'doctors', 'counteries'));
    }
   

    
    public function patient()
    {
        return view('backend.patientRegister');
    }
    public function physician()
    {
        return view('backend.physicianRegister');
    }
    public function patient_login()
    {
        return view('backend.patientlogin');
    }
    public function physician_login()
    {
        return view('backend.physicianlogin');
    }


  

    public function showAppointmentPage(Request $request)
    {
        $mab = Mab::all();
        return view('appointment', compact('mab'));
    }
    
    

    public function casePresentation(){
        return view('casePresentation.casePresentation');
    }

    public function casePresentationWinner(){
        return view('casePresentation.casePresentationWinner');
    }

    public function newsLetter(){
        return view('newsletter');
    }


    public function googleForm(){
        return view('googleform');
    }


  
    public function googleFormStore(Request $request)
    {
        
        
        $dataValidate = $request->validate([
            'name' => 'required',
            'email' => 'required|email',
            'phone' => 'required',
        ]);
        $googleFormData = new GoogleForm($dataValidate);
        $googleFormData->save();
        return redirect()->back()->with('success','Successfully Submitted');
    }
    

    public function googleFormshow(Request $request){
        $data = googleForm::get()->all();
        return view('backend.admin.webinarFormList',compact('data'));
    }


    public function webinars(){
        return view('webinars.index');
    }


    public function worldMyoday(){
        return view('wordMyositisDay24');
    }

  
    

}
