<?php

namespace App\Http\Controllers;
use App\Models\Mab;
use App\Models\User;
use Illuminate\Http\Request;

class MabController extends Controller
{
    
    public function create(){
        return view('backend.admin.mab.create');
    }


    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'name'=>'required',
            'message'=>'required',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048', // Update image validation rules
            
        ]);
        $imagePath = null;
        if($request->hasFile('image')){
            $imagePath = $request->file('image')->store('public/images');
        } 
        

        $data = new Mab();
        $data->name = $request->input('name');
        $data->mabsession = $request->input('mabsession');
        $data->message = $request->input('message');
        $data->city = $request->input('city');
        $data->image = $imagePath;
        $data->save();
        return redirect()->back()->with('success', 'Mab created successfully.');

    }

    public function show(Request $request){
        $data = Mab::all()->groupBy('mabsession');
    
        return view('medicaladvisoryboard.mab',compact('data'));
    }

    public function mab_member_show($id){
        $data = Mab::findOrFail($id);
        return view('medicaladvisoryboard.mabmemberdetails',compact('data'));
    }


    public function edit($id){
        $allmab = Mab::findOrFail($id);
        return view('backend.admin.mab.edit',compact('allmab'));
    }

  

    public function update(Request $request, $id){
        $allmab = Mab::findOrFail($id);
        $allmab->name = $request->input('name');
        $allmab->city = $request->input('city');
        $allmab->message = $request->input('message');
        
        $allmab->save();
    
        return redirect()->route('mab.list', $allmab->id)->with('success', 'Medical Advisory Board updated successfully.');
    }



  


    public function mablist(Request $request){
     
        $mablist = Mab::get();
        return view('backend.admin.mab.mabList',compact('mablist'));
    }

    
    

}
