<?php

namespace App\Http\Controllers;

use App\Models\PatientAmbassador;
use Illuminate\Http\Request;

class PatientAmbassadorController extends Controller
{
    
    public function index(Request $request)
    {
        $data = PatientAmbassador::all();
        return view('backend.admin.patientambassdor.index',compact('data'));
    }

     
    public function create()
    {
        return view('backend.admin.patientambassdor.create');
    }

     
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'name'=>'required',
            'message'=>'required',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048', // Update image validation rules
            'video' => 'nullable|mimes:mp4,mov,avi|max:50000', // Update video validation rules

        ]);
        $imagePath = null;
        $videoPath = null;
        if($request->hasFile('image')){
            $imagePath = $request->file('image')->store('public/images');
        }
        if($request->hasFile('video')){
            $videoPath = $request->file('video')->store('public/videos');
        }

        $data = new PatientAmbassador();
        $data->name = $request->input('name');
        $data->message = $request->input('message');
        $data->image = $imagePath;
        $data->video = $videoPath;
        $data->save();
        return redirect()->back()->with('success', 'Patient Ambassador created successfully.');

    }

    public function show($id)
    {
        $ambassador = PatientAmbassador::findOrFail($id);
        return view('patientambassdor.ambassador',compact('ambassador'));
    }

     
    public function edit(PatientAmbassador $patientAmbassador)
    {
        //
    }

     
    public function update(Request $request, PatientAmbassador $patientAmbassador)
    {
        //
    }

     
    public function destroy($id)
    {
        $data = PatientAmbassador::findOrFail($id);
        $data->delete();
        return redirect()->back()->with('success','Patient Ambassador Has Been Deleted Successfully');
    }

    public function patientambassdorshow(Request $request){
        $data = PatientAmbassador::all();
        return view('patientambassdor.patientambassdor',compact('data'));
    }
}
