<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\DiseaseController;
use App\Models\User;
use App\Models\Disease;
use App\Models\Appointment;
use Auth;
class PatientController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        
        return view('backend.admin.patient.dashboard');
    }
   
    public function patientlist(Request $request){
        $query = User::where('role_id', 2);
    
        if ($request->filled('disease_id')) {
            // Filter by disease ID if selected
            $query->whereHas('disease', function ($q) use ($request) {
                $q->where('id', $request->disease_id);
            });
        }
    
        $patientlist = $query->get();
        $disease = Disease::where('status', 1)->latest()->get();
    
        return view('backend.admin.patient.patientlist', compact('patientlist', 'disease'));
    }
    



    public function backendAppointment(){
        return view('backend.admin.patient.backendAppointment');
    }



    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = new Appointment();
        if (Auth::check()) {
            $data->user_id = Auth::user()->id;
        }
        $data->doctor_id = $request->input('doctor_id');
        $data->disease_id = $request->input('disease_id');
        $data->message = $request->input('message');
        $data->status = 1;
        $data->save();

        return redirect()->back()->with('success','Your appointment has been booked successfully');
    }



    public function ptWebinar(){
        return view('backend.admin.patient.ptWebinar');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        // Find the patient by ID
        $patient = User::findOrFail($id);

        // Delete the patient
        $patient->delete();

        // Redirect back with a success message
        return redirect()->back()->with('success', 'Patient deleted successfully.');
    }
}
