<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use GuzzleHttp\Client;
class PaymentController extends Controller
{
    public function showPaymentForm()
    {
        return view('payment.form');
    }

    public function handlePaymentResponse(Request $request)
    {
        // Handle the payment response from Instamojo here
        // You can verify the payment status and perform necessary actions
        // For simplicity, you can just display the response data in this example
        return $request->all();
    }


    public function initiatePayment(Request $request)
    {
        $apiEndpoint = 'https://www.instamojo.com/api/1.1/payment-requests/';
        $apiKey = '6bc458a1923daedc761930fd033b5355';
        $authToken = '7f8cbf5223fe4dd02ffefb14ca52d8a7';

        $client = new Client();
        $response = $client->post($apiEndpoint, [
            'headers' => [
                'X-Api-Key' => $apiKey,
                'X-Auth-Token' => $authToken,
            ],
            'form_params' => [
                'purpose' => 'Payment for Order #123', // Replace with your order purpose
                'amount' => $request->input('amount'),
                 
                'email' => $request->input('email'),
                 // Add the phone number to the request
                'redirect_url' => route('payment.response'), // URL to handle payment response
                'send_email' => true,
                'send_sms' => true,
                'allow_repeated_payments' => false,

                // Specify payment options
                'payment_options' => [
                    'emi',
                    'credit_card',
                    'debit_card',
                    'upi',
                    'net_banking',
                    'wallets',
                ],
            ],
        ]);

        $paymentData = json_decode($response->getBody(), true);

        // Redirect the user to the Instamojo payment gateway
        return redirect($paymentData['payment_request']['longurl']);
    }
}
