<?php

namespace App\Http\Controllers;

use App\Models\Country;
use App\Models\State;
use Illuminate\Http\Request;

class StateController extends Controller
{

    public function index()
    {
        $data = State::latest()->get();
        return view('backend.admin.state.index', compact('data'));
    }

    public function create()
    {
        $countries = Country::where('status', 1)->latest()->get();
        return view('backend.admin.state.create', compact('countries'));
    }

    public function store(Request $request)
    {
        $data = new State();
        $data->country_id = $request->input('country_id');
        $data->name = $request->input('name');
        $data->status = 1;
        $data->save();

        return redirect()->route('admin.state');
    }

    public function edit($id)
    {
        $data = State::findOrFail($id);
        $countries = Country::where('status', 1)->latest()->get();
        return view('backend.admin.state.edit', compact('data','countries'));
    }

    public function update(Request $request)
    {
        $data = State::findOrFail($request->input('id'));
        $data->country_id = $request->input('country_id');
        $data->name = $request->input('name');
        $data->save();

        return redirect()->route('admin.state');
    }

    public function status($id, $status)
    {
        $data = State::findOrFail($id);
        $data->status = $status;
        $data->save();

        return redirect()->route('admin.state');
    }
}
