<?php

namespace App\Http\Controllers;

use App\Models\TeamMember;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;






class TeamMemberController extends Controller
{
    public function index(){
        return view('backend.admin.teamMember.index');
    }

    public function create(){
        return view('backend.admin.teamMember.create');
    }

    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'name'=>'required',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
            
        ]);
        $imagePath = null;
       
        if($request->hasFile('image')){
            $imagePath = $request->file('image')->store('public/images');
        }
        $data = new TeamMember();
        $data->name = $request->input('name');
        $data->designation = $request->input('designation');
        $data->bio = $request->input('bio');
        $data->joinAs = $request->input('joinAs');
        $data->image = $imagePath;
        $data->save();
        return redirect()->back()->with('success', 'Team Member created successfully.');
    }


    public function team(Request $request)
    {
        $teamData = TeamMember::all();
        return view('team.team',compact('teamData'));
    }



    public function show($id){
        $data = TeamMember::findOrFail($id);
        return view('team.team_member',compact('data'));
    }


    public function edit($id){
        $data = TeamMember::findOrFail($id);
        return view('backend.admin.teamMember.create',compact('data'));
    }

    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'name' => 'required',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
        ]);
    
        $data = TeamMember::findOrFail($id);
    
        // Check if there's a new image uploaded
        if ($request->hasFile('image')) {
            // Store the new image
            $imagePath = $request->file('image')->store('public/images');
    
            // Delete the old image from storage if it exists
            // Note: You may want to add additional checks here
            // to ensure the old image exists before deleting it
            // and to handle potential errors
            Storage::delete($data->image);
    
            // Update the image path
            $data->image = $imagePath;
        }
    
        // Update other fields
        $data->name = $request->input('name');
        $data->designation = $request->input('designation');
        $data->bio = $request->input('bio');
        $data->joinAs = $request->input('joinAs');
        $data->update();
    
        // Redirect back with a success message
        return redirect()->route('team.show')->with('success', 'Team member updated successfully');
    }
    


    public function delete($id){
        $data = TeamMember::findOrFail($id);
        $data->delete();
        return redirect()->route('team.show')->with('success', $data->name.'-Team member Deleted successfully');

    }
    


    public function listShow(Request $request){
        $data = TeamMember::paginate();
        return view('backend.admin.teamMember.showlist',compact('data'));
    }





public function team1(){
    $teamData = TeamMember::all();
    return view('team.team1',compact('teamData'));
}


public function team2(){
    $teamData = TeamMember::all();
    return view('team.team2',compact('teamData'));
}


}
