<?php
namespace App\Mail;

use Illuminate\Mail\Mailable;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\SerializesModels;
class AdminAppointmentNotification extends Mailable
{
    use Queueable, SerializesModels;

    public $appointmentData;

    public function __construct($appointmentData)
    {
        $this->appointmentData = $appointmentData;
    }

    public function build()
    {
        return $this->subject('New Appointment Request')
            ->view('emails.admin_appointment_notification');
    }
}
