<?php
namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\Models\Enquiry;

class AppointmentConfirmation extends Mailable
{
    use Queueable, SerializesModels;

    public $enquiryData;

    public function __construct(Enquiry $enquiryData)
    {
        $this->enquiryData = $enquiryData;
    }

    public function build()
    {
        return $this->subject('Thank You for Submitting Your Appointment')
            ->view('emails.appointment_confirmation');
    }
}
