<?php
namespace App\Mail;

use Illuminate\Mail\Mailable;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\SerializesModels;
class UserAppointmentNotification extends Mailable
{
    use Queueable, SerializesModels;

    public $appointmentData;

    public function __construct($appointmentData)
    {
        $this->appointmentData = $appointmentData;
    }

    public function build()
    {
        return $this->subject('Your appointment request has been received!')
            ->view('emails.user_appointment_notification');
    }
}
