<?php

namespace App\Notifications;

use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;

class NewAppointmentNotification extends Notification
{
    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('New Appointment Scheduled')
            ->line('A new appointment has been scheduled.')
            ->action('View Appointment Details', url('/admin/appointments')) // Modify the URL to the admin panel
            ->line('Thank you for using our application!');
    }
    public function via($notifiable)
    {
        return ['mail']; // This indicates the notification will be sent via email
    }
}
