@extends('layouts.master')
@section('title', 'Myositis India - Awareness & Support for Patients')
@section('description', 'Providing resources and community support for Myositis patients in India.')
@section('canonical', 'https://www.myositisindia.org/')
@section('content')
<style>
    .container {
        max-width: 1200px;
        margin: 0 auto;
        padding: 20px;
        font-family: Arial, sans-serif;
    }
    .article-title {
        font-size: 2.5em;
        color: #333;
        text-align: center;
        margin-bottom: 20px;
    }
    .article-list {
        display: grid;
        grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
        gap: 20px;
        list-style-type: none;
        padding: 0;
    }
    .article-item {
        background-color: #f9f9f9;
        border-radius: 5px;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
        padding: 15px;
    }
    .article-link {
        color: #0066cc;
        text-decoration: none;
        font-size: 1.1em;
        line-height: 1.5;
    }
    .article-link:hover {
        text-decoration: underline;
    }
    .article-image {
        width: 100%;
        height: auto;
        border-radius: 5px;
        margin-bottom: 10px;
    }
</style>
<div class="container">
    <h1 class="article-title">Articles</h1>
    <ul class="article-list">
        <li class="article-item">
            <!-- <img src="https://via.placeholder.com/800x400" alt="Article Image" class="article-image"> -->
            <a href="https://pubmed.ncbi.nlm.nih.gov/39212691/" target="_blank" class="article-link">
                Aggarwal A, Chandra T, Ladha P, Mittal S, Haldule S, Nirmal S, Edpuganti N, Jain N, Cavagna L, Zanframundo G, Faghihi-Kashani S, Aggarwal R. Heterogeneity in nomenclature and abbreviation usage for anti-synthetase syndrome: a scoping review. Rheumatol Int. 2024 Nov;44(11):2293-2299. doi: 10.1007/s00296-024-05670-w. Epub 2024 Aug 30. PMID: 39212691.
            </a>
        </li>
        <li class="article-item">
            <!-- <img src="https://via.placeholder.com/800x400" alt="Article Image" class="article-image"> -->
            <a href="https://pubmed.ncbi.nlm.nih.gov/39304342/" target="_blank" class="article-link">
                Aggarwal A, Bagri NK, Kavadichanda C, Upadhyaya S, Haldule S, Ladha P, Jain N, Pathak H, Das P, Mittal S, Tope RA, Nikale AA, Nimal S, Mehta P, Chandwar K, Dudam R, Malviya S, Rao VKR, Singh S, Sharma V, Edpuganti N, Nalkande R, Salunke S, Madan U, Batra V, Aggarwal R. Myositis India: Early lessons from a patient support group in a resource-limited setting. Int J Rheum Dis. 2024 Sep;27(9):e15351. doi: 10.1111/1756-185X.15351. PMID: 39304342.
            </a>
        </li>
        <li class="article-item">
            <!-- <img src="https://via.placeholder.com/800x400" alt="Article Image" class="article-image"> -->
            <a href="https://pubmed.ncbi.nlm.nih.gov/40286313/" target="_blank" class="article-link">
                Aggarwal A, Chandra T, Keret S, Pauling JD, Shamim EA, Bonella F, Miller FW, Mammen A, Sambataro G, Liewluck T, Fernandez AP, Bartoloni E, Shinjo SK, Castañeda S, Werth V, Dimachkie MM, Katsumata Y, Campanilho-Marques R, Fujimoto M, Lilleker JB, Selva-O'Callaghan A, Mozaffar T, Gunawardena H, Mann H, Rojas Serrano J, Cavagna L, Moghadam-Kia S, Oddis CV, Ladha P, Mittal S, Haldule S, Edpuganti N, Sridhar S, Savaliya R, Batra V, Aggarwal R. Consensus nomenclature and abbreviation for anti-synthetase syndrome: an IMACS project. Rheumatology (Oxford). 2025 Apr 26:keaf229. doi: 10.1093/rheumatology/keaf229. Epub ahead of print. PMID: 40286313.
            </a>
        </li>
    </ul>
</div>
@endsection