<!DOCTYPE html>

<html lang="en">







<head>

    <meta charset="utf-8">

    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0">

    <link rel="shortcut icon" type="image/x-icon" href="assets/img/favicon.png">

    <title>Myositis - Patient Registration</title>



    <link rel="stylesheet" type="text/css" href="{{ asset('backend/assets/css/bootstrap.min.css') }}">

    <link rel="stylesheet" href="{{ asset('backend/assets/plugins/feather/feather.css') }}">

    <link rel="stylesheet" href="{{ asset('backend/assets/plugins/fontawesome/css/fontawesome.min.css') }}">

    <link rel="stylesheet" href="{{ asset('backend/assets/plugins/fontawesome/css/all.min.css') }}">

    <link rel="stylesheet" type="text/css" href="{{ asset('backend/assets/css/style.css') }}">

    <style>

        img {

  max-width: 100%;

  max-height: 500px;

  height: auto;

}



    </style>

     

</head>



<body>



    <div class="main-wrapper login-body">

        <div class="container-fluid px-0">

            <div class="row">

                <div class="col-lg-6 login-wrap">

                    <div class="login-sec">

                        <div class="log-img">

                            <div class="md-lg-12 sm-12">

                                <img class="img-fluid" src="{{ asset('backend/assets/img/login-02.png') }}" alt="Logo" style="margin-top:40px;">



                            </div>

                        </div>

                    </div>

                </div>





                <div class="col-lg-6 login-wrap-bg">

                    <div class="login-wrapper">

                        <div class="loginbox">

                            <div class="login-right">

                                <div class="login-right-wrap">

                                    <div class="md-lg-12 sm-12">

                                        <img src="{{asset('asset/img/lo.jpeg')}}" alt="your image description" class="responsive-img"> <br><br>



                                    </div>



                                    <h4 style="text-align:center">Welcome to healthcare professional Page</h4>

                                    <p style="text-align:center; font-size:13px">We are excited to have you join our community. </p>

                                    <p style="text-align:center;color:#2E37A4;"> If you've already registered, just log in <br> <a href="{{route('user.login')}}" class="btn btn-success">Login here</a>&nbsp&nbsp<a href="{{route('home')}}" class="btn btn-success">Go to Home Page</a></p>

                                    <hr>

                                    @if (Session::has('success'))

                                    <div class="alert alert-success">

                                        {{Session::get('success')}}



                                    </div>

                                        

                                    @endif

                                    <form action="{{ route('user.register') }}" method="post">

                                        @csrf

                                        <input type="hidden"  name="role" value="3">

                                        <div class="form-group">

                                            <input type="text" name="fname" placeholder="First Name" required

                                                class="form-control">

                                        </div>

                                        <div class="form-group">

                                            <input type="text" name="lname" placeholder="Last Name" required

                                                class="form-control">

                                        </div>

                                        <div class="form-group">

                                            <input type="text" name="phone" placeholder="Mobile"

                                                class="form-control" required>



                                        </div>

                                        <div class="form-group">

                                            <input type="text" name="email" placeholder="Email"

                                                class="form-control" required>



                                        </div>

                                        <div class="fomr-group">

                                            <input type="password" name="password" class="form-control"

                                                placeholder="Password" required>



                                        </div> <br>

                                        <div class="form-group">

                                            <input type="password" name="cpassword" class="form-control"

                                                placeholder="Confirm password" required>

                                        </div>



                                        <div class="form-group mb-3">

                                            <select id="country-dd" class="form-control" name="country" required>

                                                <option value="" >Select Country</option>

                                                @foreach ($counteries as $data)

                                                    <option value="{{ $data->id }}">{{ $data->name }}</option>

                                                @endforeach

                                            </select>

                                        </div>

                                        <div class="form-group mb-3">

                                            <select id="state-dd" class="form-control" name="state" required></select>

                                        </div>

                                        <div class="form-group mb-3">

                                            <select id="city-dd" class="form-control" name="city" required></select>

                                        </div>

                                        <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.min.js"></script>

                                        <script type="text/javascript">

                                            $(document).ready(function() {

                                                $('#country-dd').change(function(event) {

                                                    var idCountry = this.value;

                                                    $('#state-dd').html('');



                                                    $.ajax({

                                                        url: "/api/fetch-state",

                                                        type: 'POST',

                                                        dataType: 'json',

                                                        data: {

                                                            country_id: idCountry,

                                                            _token: "{{ csrf_token() }}"

                                                        },

                                                        success: function(response) {

                                                            $('#state-dd').html('<option value="">Select State</option>');

                                                            $.each(response.states, function(index, val) {

                                                                $('#state-dd').append('<option value="' + val.id + '"> ' +

                                                                    val.name + ' </option>')

                                                            });

                                                            $('#city-dd').html('<option value="">Select City</option>');

                                                        }

                                                    })

                                                });

                                                $('#state-dd').change(function(event) {

                                                    var idState = this.value;

                                                    $('#city-dd').html('');

                                                    $.ajax({

                                                        url: "/api/fetch-cities",

                                                        type: 'POST',

                                                        dataType: 'json',

                                                        data: {

                                                            state_id: idState,

                                                            _token: "{{ csrf_token() }}"

                                                        },

                                                        success: function(response) {

                                                            $('#city-dd').html('<option value="">Select State</option>');

                                                            $.each(response.cities, function(index, val) {

                                                                $('#city-dd').append('<option value="' + val.id + '"> ' +

                                                                    val.name + ' </option>')

                                                            });

                                                        }

                                                    })

                                                });

                                            });

                                        </script>

                                         <div id="adan">

                                            

                                            <div class="form-group">

                                                <select name="gender" id="" class="form-control">

                                                    <option value="">Gender</option>

                                                    <option id="male" name="gender" value="male" required>Male</option>

                                                    <option id="female" name="gender" value="female" required>Female</option>

                                                    <option  id="other" name="gender" value="other" required>Other</option>

                                                </select>

                                            </div>

                                            <div class="form-group">

                                                <input type="text" class="form-control" name="age" placeholder="Age" required>

                                            </div>

                                            <div class="form-group">

                                                <input type="text" class="form-control" name="dob" placeholder="How many myositis patients do you see in a year? " required>

                                            </div>

                                            <select name="doctorSpeciality" id="" class="form-control mb-3">

                                                <option value="">Speciality/Area</option>

                                                <option value="Rheumatologist">Rheumatologist</option>

                                                <option value="Neurologist">Neurologist</option>

                                                <option value="Immunologist">Immunologist</option>

                                                <option value="General Physician"> General Physician</option>

                                                <option value="Gastroenterologist">Gastroenterologist</option>

                                                <option value="Cardiologist">Cardiologist</option>

                                                <option value="Nephrologist">Nephrologist</option>

                                                <option value="Gynecologist">Gynecologist</option>

                                                <option value="Orthopedist">Orthopedist</option>

                                                <option value="Ophthalmologist">Ophthalmologist</option>
                                                <option value="Surgeon">Surgeon</option>

                                                <option value="Dietician">Dietician</option>
                                                <option value="Physiotherapist">Physiotherapist</option>
                                                <option value="Pharmacist">Pharmacist</option>
                                                <option value="Yogapractitioner">Yoga practitioner</option>
                                               

                                                <option value="Other">Other</option>

                                                

                                            </select>

                                        <textarea name="message" cols="30" rows="3" placeholder="Tell us about yourself" class="form-control" required></textarea>


                                        <br>

 
<div class="form-group local-forms">
    <label for="captcha ">Solve the following to submit the form:</label> <br>
    <div id="captchaQuestion"></div>
    <input type="number" id="captchaAnswer" name="captcha_answer" class="form-control" placeholder="Your answer">
    <div id="captchaError" style="color: red; display: none;">Please solve the CAPTCHA correctly to submit the form.</div>
</div>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Generate random numbers and the correct answer
    const num1 = Math.floor(Math.random() * 10);
    const num2 = Math.floor(Math.random() * 10);
    const correctAnswer = num1 + num2;

    // Display the question
    document.getElementById('captchaQuestion').textContent = `${num1} + ${num2} = ?`;

    // Add event listener to the form submission
    document.getElementById('registrationForm').addEventListener('submit', function(event) {
        const userAnswer = parseInt(document.getElementById('captchaAnswer').value, 10);
        const captchaError = document.getElementById('captchaError');
        
        if (isNaN(userAnswer) || userAnswer !== correctAnswer) {
            event.preventDefault();
            captchaError.textContent = 'Incorrect CAPTCHA answer. Please try again.';
            captchaError.style.display = 'block';
        } else {
            captchaError.style.display = 'none';
        }
    });
});
</script>


                                        <input type="checkbox" id="terms" value="1" name="terms" required style="margin-top: 10px;">

                                        <label for="terms" style="font-size: 15px;">I accept the <a

                                                href="{{route('termcondition')}}">terms and

                                                conditions</a> of

                                            Myositis India</label> <br> <br>

                                        <div class="form-group login-btn">

                                            <button class="btn btn-primary btn-block" type="submit">Submit</button>

                                        </div>

                                    </form>





                                </div>

                            </div>

                        </div>

                    </div>

                </div>



            </div>

        </div>

    </div>





    <script src="{{ asset('backend/assets/js/jquery-3.6.1.min.js') }}"></script>

    <script src="{{ asset('backend/assets/js/bootstrap.bundle.min.js') }}"></script>

    <script src="{{ asset('backend/assets/js/feather.min.js') }}"></script>

    <script src="{{ asset('backend/assets/js/app.js') }}"></script>

</body>



 

</html>

