@extends('layouts.master')
@section('content')
    <section class="background-radial-gradient overflow-hidden">
        <div class="container">
            <div class="row">
                <div class="col-lg-6 col-md-6 col-sm-12">
                    <h3 style="color:white; text-align:center">welcome to Registration Page</h3>
                    <p style="color:white; text-align:center">We are excited to have you join our community. </p>
                    <hr>
                    @if (Session::has('success'))
                        <div class="alert alert-success">
                            {{ Session::get('success') }}

                        </div>
                    @endif
                    <form action="{{ route('user.register') }}" method="post">
                        @csrf
                        <select name="role" id="" required onchange="userRole(this)">
                            <option value="">
                                Are you a Patient or a Family Member (relative)? </option>
                            <option value="2" selected>Patient</option>
                            <option value="3">Doctor</option>
                        </select>
                        <input type="text" name="fname" placeholder="First Name" required>
                        <input type="text" name="lname" placeholder="Last Name" required>
                        <input type="text" name="phone" placeholder="Mobile" required>
                        <input type="text" name="email" placeholder="Email" required>
                        <input type="password" style="margin-bottom: 10px" name="password" placeholder="Password" required>
                        <input type="password" style="margin-bottom: 10px" name="cpassword" placeholder="Confirm password"
                            required>
                        <div class="form-group mb-3">
                            <select id="country-dd" class="form-control">
                                <option value="">Select Country</option>
                                @foreach ($counteries as $data)
                                    <option value="{{ $data->id }}">{{ $data->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group mb-3">
                            <select id="state-dd" class="form-control"></select>
                        </div>
                        <div class="form-group mb-3">
                            <select id="city-dd" class="form-control"></select>
                        </div>
                        <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.0/dist/jquery.min.js"></script>
                        <script type="text/javascript">
                            $(document).ready(function() {
                                $('#country-dd').change(function(event) {
                                    var idCountry = this.value;
                                    $('#state-dd').html('');

                                    $.ajax({
                                        url: "/api/fetch-state",
                                        type: 'POST',
                                        dataType: 'json',
                                        data: {
                                            country_id: idCountry,
                                            _token: "{{ csrf_token() }}"
                                        },
                                        success: function(response) {
                                            $('#state-dd').html('<option value="">Select State</option>');
                                            $.each(response.states, function(index, val) {
                                                $('#state-dd').append('<option value="' + val.id + '"> ' +
                                                    val.name + ' </option>')
                                            });
                                            $('#city-dd').html('<option value="">Select City</option>');
                                        }
                                    })
                                });
                                $('#state-dd').change(function(event) {
                                    var idState = this.value;
                                    $('#city-dd').html('');
                                    $.ajax({
                                        url: "/api/fetch-cities",
                                        type: 'POST',
                                        dataType: 'json',
                                        data: {
                                            state_id: idState,
                                            _token: "{{ csrf_token() }}"
                                        },
                                        success: function(response) {
                                            $('#city-dd').html('<option value="">Select State</option>');
                                            $.each(response.cities, function(index, val) {
                                                $('#city-dd').append('<option value="' + val.id + '"> ' +
                                                    val.name + ' </option>')
                                            });
                                        }
                                    })
                                });
                            });
                        </script>


                        <div id="adan">
                            <select name="disease_id">
                                <option value="">Type of Myositis</option>
                                @foreach ($disease as $item)
                                    <option value="{{ $item->id }}">{{ $item->name }}</option>
                                @endforeach

                            </select>
                            {{--  <select name="doctor_id" >
                                <option value="">Select Doctor</option>
                                @foreach ($doctors as $item)
                                    <option value="{{ $item->id }}">{{ $item->fname }} {{ $item->lname }}</option>
                                @endforeach
                            </select> --}}

                            <input type="text" name="doctorName" placeholder="Doctor Name" required>

                            {{-- <label for="gender" style="color:aliceblue">Gender:</label>
                        <input type="radio" id="male" name="gender" value="male" required>
                        <label for="male" style="color:aliceblue">Male</label>

                        <input type="radio" id="female" name="gender" value="female" required>
                        <label for="female" style="color:aliceblue">Female</label>

                        <input type="radio" id="other" name="gender" value="other" required>
                        <label for="other" style="color:aliceblue">Other</label> --}}

                            <select name="" id="">
                                <option value="">Select Your Gender</option>
                                <option value="male">Male</option>
                                <option value="female">Female</option>
                                <option value="other">Other</option>
                            </select>
                        </div>

                        <script>
                            function calculateAge() {
                                const dobInput = document.getElementById('dob');
                                const dob = new Date(dobInput.value);
                                const ageInMs = Date.now() - dob.getTime();
                                const age = new Date(ageInMs);
                                document.getElementById('age').textContent = Math.abs(age.getUTCFullYear() - 1970);
                            }
                        </script>
                        <textarea name="message" cols="30" rows="3" placeholder="Message" required></textarea>

                        <input type="checkbox" id="terms" value="1" name="terms" required>
                        <label for="terms" style="color:white">I accept the <a href="javascript:;">terms and
                                conditions</a> of
                            Myositis India</label> <br>
                        <button type="submit">Submit</button>
                    </form>
                </div>
                <div class="col-lg-6 col-md-6 col-sm-12">
                    <img src="{{ asset('asset/img/ptregis.png') }}" alt="">

                </div>
            </div>
        </div>
    </section>
    <!-- Section: Design Block -->
@endsection
<!-- Section: Design Block -->
