@extends('backend.layouts.master')
@section('content')
    <div class="page-wrapper">
        <div class="content">

            <div class="page-header">
                <div class="row">
                    <div class="col-sm-12">
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="index.html">Dashboard </a></li>
                            <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                            <li class="breadcrumb-item active">Appointment List</li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-12">
                    <div class="card-box">
                        <div class="card-block">
                            <div class="d-flex justify-content-between">
                                <h6 class="card-title text-bold">Appointment List</h6>
                                {{-- <a href="{{ route('admin.appointment.create') }}" class="btn btn-primary">Add Appointment</a> --}}
                            </div>
                            <div class="table-responsive">
                                <table class="datatable table table-stripped ">
                                    <thead>
                                        <tr>
                                            <th>Sr. No.</th>
                                            <th>Disease Name</th>
                                            <th>Doctor Name</th>
                                            <th>Message</th>
                                            <th>Status</th>
                                            <th>Source</th>
                                            {{-- <th>Action</th> --}}
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $i = 1;
                                        @endphp
                                        @foreach ($data as $item)
                                            <tr>
                                                <td>{{ $i++ }}</td>
                                                <td>{{ $item->disease->name }}</td>
                                                <td>{{ $item->doctor->fname }} {{ $item->doctor->lname }}</td>
                                                <td>{{ $item->message }}</td>
                                                <td>
                                                    @if ($item->status == 1)
                                                        <a href="{{ route('admin.appointment.status', ['id' => $item->id, 'status' => 0]) }}"
                                                            class="badge badge-pill badge-success">Open</a>
                                                    @else
                                                        <a href="{{ route('admin.appointment.status', ['id' => $item->id, 'status' => 1]) }}"
                                                            class="badge badge-pill badge-danger">Closed</a>
                                                    @endif
                                                </td>
                                                <td>
                                                    @if ($item->user_id)
                                                    {{ $item->user->fname }} {{ $item->user->lname }}
                                                    @else
                                                        OPD
                                                    @endif
                                                </td>
                                                {{-- <td><a href="{{ route('admin.appointment.edit', ['id' => $item->id]) }}"
                                                        class="badge badge-pill badge-primary">Edit</a>
                                                </td> --}}
                                            </tr>
                                        @endforeach


                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
     
    </div>
@endsection
