@extends('backend.layouts.master')

@section('content')

<div class="page-wrapper">

    <div class="content">



        <div class="page-header">

            <div class="row">

                <div class="col-sm-12">

                    <ul class="breadcrumb">

                        <li class="breadcrumb-item"><a href="doctors.html">Appointment

                            </a></li>

                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>

                        <li class="breadcrumb-item active">Appointment List</li>

                    </ul>

                </div>

            </div>

        </div>



        <div class="row">

            <div class="col-sm-12">

                <div class="card card-table show-entire">

                    <div class="card-body">



                        <div class="page-table-header mb-2">

                            <div class="row align-items-center">

                                <div class="col">

                                    <div class="doctor-table-blk">

                                        <h3>Appointment List</h3>

                                        <div class="doctor-search-blk">

                                            <div class="top-nav-search table-search-blk">

                                                <form>

                                                    <input type="text" class="form-control" placeholder="Search here">

                                                    <a class="btn"><img src="assets/img/icons/search-normal.svg" alt=""></a>

                                                </form>

                                            </div>

                                            <div class="add-group">

                                                <a href="add-doctor.html" class="btn btn-primary

                               add-pluss ms-2"><img src="{{ asset('backend/assets/img/icons/plus.svg') }}" alt=""></a>

                                                <a href="javascript:;" class="btn btn-primary

                               doctor-refresh ms-2"><img src="{{ asset('backend/assets/img/icons/re-fresh.svg') }}" alt=""></a>

                                            </div>

                                        </div>

                                    </div>

                                </div>

                                <div class="col-auto text-end float-end ms-auto

                       download-grp">

                                    <a href="{{ route('export.doctors') }}" class=" me-2"><img src="{{ asset('backend/assets/img/icons/pdf-icon-01.svg') }}" alt=""></a>

                                    <a href="{{ route('export.doctors') }}" class=" me-2"><img src="{{ asset('backend/assets/img/icons/pdf-icon-02.svg') }}" alt=""></a>

                                    <a href="{{ route('export.doctors') }}" class=" me-2"><img src="{{ asset('backend/assets/img/icons/pdf-icon-03.svg') }}" alt=""></a>

                                    <a href="{{ route('export.doctors') }}"><img src="{{ asset('backend/assets/img/icons/pdf-icon-04.svg') }}" alt=""></a>

                                </div>

                            </div>

                        </div>



                        <div class="table-responsive">

                            <table class="table border-0 custom-table comman-table

                     datatable mb-0">

                                <thead>

                                    <tr>

                                        <th>

                                            <div class="form-check check-tables">

                                                <input class="form-check-input" type="checkbox" value="something">

                                            </div>

                                        </th>

                                        <th>Name</th>

                                        <th>Mobile</th>
 

                                      

                                        <th>Country</th>
                                        <th>Date</th>
                                        <th>Action</th>
                                         



                                    </tr>

                                </thead>

                                <tbody>

                                    @foreach ($enquiryData as $enquiryDatas)
                                    <tr>
                                        <td>
                                            <div class="form-check check-tables">
                                                <input class="form-check-input" type="checkbox" value="something">
                                            </div>
                                        </td>
                                        <td class="profile-image">
                                            <a href="profile.html">
                                                {{ $enquiryDatas->name }}
                                            </a>
                                        </td>
                                        <td><a href="https://api.whatsapp.com/send?phone={{ $enquiryDatas->phone }}"
                                                        target="_blank" class="btn btn-success">
                                                        <i class="fab fa-whatsapp fa-sm"></i>
                                        {{ $enquiryDatas->phone }}
                                        </td>                                      
                                        <td> {{ $enquiryDatas->country }}</td>
                                        <td> {{ \Carbon\Carbon::parse($enquiryDatas->created_at)->format('l, F jS, Y h:i A') }}</td>
                                        <td>
                                            <button class="btn btn-primary" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#exampleModal{{ $enquiryDatas->id }}">View</button>
                                        </td>
                                      <!--   <td class="text-end">
                                            <div class="dropdown dropdown-action">
                                                <a href="#" class="action-icon dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"><i class="fa fa-ellipsis-v"></i></a>
                                                <div class="dropdown-menu dropdown-menu-end">
                                                    <a class="dropdown-item" href="edit-doctor.html"><i class="fa-solid fa-pen-to-square m-r-5"></i>
                                                        Edit</a>
                                                    <a class="dropdown-item" href="#" data-bs-toggle="modal" data-bs-target="#delete_patient"><i class="fa
                                   fa-trash-alt m-r-5"></i>
                                                        Delete</a>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    <!-- Button trigger modal -->
                                    <div class="modal fade" id="exampleModal{{ $enquiryDatas->id }}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h1 class="modal-title fs-5" id="exampleModalLabel">Appointment Details</h1>  &nbsp;  &nbsp; &nbsp;
        {{ \Carbon\Carbon::parse($enquiryDatas->created_at)->format('l, F jS, Y h:i A') }}
    
    
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <div class="row">
          <div class="col-md-4">
            <label for="name">Name</label>
            <input type="text" class="form-control" id="name" value="{{ $enquiryDatas->name }}" readonly>
          </div>
          <div class="col-md-4">
            <label for="phone">Phone</label>
            <input type="text" class="form-control" id="phone" value="{{ $enquiryDatas->phone }}" readonly>
          </div>
          <div class="col-md-4">
            <label for="email">Email</label>
            <input type="email" class="form-control" id="email" value="{{ $enquiryDatas->email }}" readonly>
          </div>
          <div class="col-md-4">
            <label for="gender">Gender</label>
            <input type="text" class="form-control" id="gender" value="{{ $enquiryDatas->gender }}" readonly>
          </div>
          <div class="col-md-4">
            <label for="country">Country</label>
            <input type="text" class="form-control" id="country" value="{{ $enquiryDatas->country }}" readonly>
          </div>
          <div class="col-md-4">
            <label for="state">State</label>
            <input type="text" class="form-control" id="state" value="{{ $enquiryDatas->state }}" readonly>
          </div>
          <div class="col-md-4">
            <label for="city">City</label>
            <input type="text" class="form-control" id="city" value="{{ $enquiryDatas->city }}" readonly>
          </div>
          <div class="col-md-12">
            <label for="message">Message</label>
            <textarea class="form-control" id="message" rows="3" readonly>{{ $enquiryDatas->message }}</textarea>
          </div>
          

        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        
      </div>
    </div>
  </div>
</div>


                                    @endforeach

                                </tbody>

                            </table>

                        </div>

                    </div>

                </div>

            </div>

        </div>

    </div>



</div>

<div id="delete_patient" class="modal fade delete-modal" role="dialog">

    <div class="modal-dialog modal-dialog-centered">

        <div class="modal-content">

            <div class="modal-body text-center">

                <img src="assets/img/sent.png" alt="" width="50" height="46">

                <h3>Are you sure want to delete this ?</h3>

                <div class="m-t-20"> <a href="#" class="btn btn-white" data-bs-dismiss="modal">Close</a>

                    <button type="submit" class="btn btn-danger">Delete</button>

                </div>

            </div>

        </div>

    </div>

</div>

@endsection