@extends('backend.layouts.master')

@section('content')
<div class="page-wrapper">
    <div class="content">
        <div class="page-header">
            <div class="row">
                <div class="col-sm-12">
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="doctors.html">Patients</a></li>
                        <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                        <li class="breadcrumb-item active">Patients List</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card card-table show-entire">
                    <div class="card-body">
                        <div class="page-table-header mb-2">
                            <div class="row align-items-center">
                                <div class="col">
                                    <div class="doctor-table-blk">
                                        <h3>Patients List</h3>
                                        <div class="doctor-search-blk">
                                            <form method="GET" action="{{ route('patientlist') }}">
                                                <div class="top-nav-search table-search-blk">
                                                    <select name="disease_id" id="disease_id" class="form-control" onchange="this.form.submit()">
                                                        <option value="">--Filter by Disease--</option>
                                                        <option value="">All Patients</option>
                                                        @foreach($disease as $item)
                                                            <option value="{{ $item->id }}" {{ request('disease_id') == $item->id ? 'selected' : '' }}>
                                                                {{ $item->name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div class="add-group">
                                                    <span style="background-color: rgb(78, 56, 172); color:white; border:2px solid rgb(78, 56, 172); border-radius:3px;">
                                                        Total Patients: {{ $patientlist->count() }}
                                                    </span>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-auto text-end float-end ms-auto download-grp">
                                    <a href="{{ route('export.patients') }}" class="me-2"><img src="{{asset('backend/assets/img/icons/pdf-icon-01.svg')}}" alt="" /></a>
                                    <a href="{{ route('export.patients') }}" class="me-2"><img src="{{asset('backend/assets/img/icons/pdf-icon-02.svg')}}" alt="" /></a>
                                    <a href="{{ route('export.patients') }}" class="me-2"><img src="{{asset('backend/assets/img/icons/pdf-icon-03.svg')}}" alt="" /></a>
                                    <a href="{{ route('export.patients') }}"><img src="{{asset('backend/assets/img/icons/pdf-icon-04.svg')}}" alt="" /></a>
                                </div>
                            </div>
                        </div>

                        <div class="table-responsive">
                            <table class="table border-0 custom-table comman-table datatable mb-0">
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Mobile</th>
                                        <th>Email</th>
                                        <th>Type of Myositis</th>
                                        <th>Country</th>
                                        <th>Timestamp</th>
                                        <th>View</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($patientlist as $patientlists)
                                        <tr>
                                            <td class="profile-image">{{ $patientlists->fname }} {{ $patientlists->lname }}</td>
                                            <td>
                                                <a href="https://api.whatsapp.com/send?phone={{ $patientlists->phone }}" target="_blank" class="btn btn-success">
                                                    <i class="fab fa-whatsapp fa-sm"></i>
                                                </a> {{ $patientlists->phone }}
                                            </td>
                                            <td>
                                                <a href="mailto:{{ $patientlists->email }}">{{ $patientlists->email }}
                                                    <i class="far fa-envelope"></i>
                                                </a>
                                            </td>
                                            <td>{{ optional($patientlists->disease)->name }}</td>
                                            <td>{{ $patientlists->country->name ?? 'not selected' }}</td>
                                            <td>{{ $patientlists->created_at }}</td>
                                            <td>
                                                <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#exampleModal{{ $patientlists->id }}">View</button>
                                            </td>
                                            <td class="text-end">
                                                <form id="deleteForm{{ $patientlists->id }}" action="{{ route('patients.destroy', $patientlists->id) }}" method="POST">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="button" onclick="confirmDelete({{ $patientlists->id }})"><i class="fas fa-trash-alt"></i></button>
                                                </form>
                                            </td>
                                        </tr>

                                        <!-- Modal -->
                                        <div class="modal fade" id="exampleModal{{ $patientlists->id }}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-lg">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h1 class="modal-title fs-5" id="exampleModalLabel">Patient Details</h1>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <div class="row">
                                                            <div class="col-md-4"><label>Name</label><input type="text" class="form-control" value="{{ $patientlists->fname }} {{ $patientlists->lname }}" readonly></div>
                                                            <div class="col-md-4"><label>Phone</label><input type="text" class="form-control" value="{{ $patientlists->phone }}" readonly></div>
                                                            <div class="col-md-4"><label>Email</label><input type="email" class="form-control" value="{{ $patientlists->email }}" readonly></div>
                                                            <div class="col-md-4"><label>Country</label><input type="text" class="form-control" value="{{ $patientlists->country->name ?? 'not selected' }}" readonly></div>
                                                            <div class="col-md-4"><label>State</label><input type="text" class="form-control" value="{{ $patientlists->state->name ?? 'not selected' }}" readonly></div>
                                                            <div class="col-md-4"><label>City</label><input type="text" class="form-control" value="{{ $patientlists->city->name ?? 'not selected' }}" readonly></div>
                                                            <div class="col-md-4"><label>Type of Myositis</label><input type="text" class="form-control" value="{{ optional($patientlists->disease)->name }}" readonly></div>
                                                            <div class="col-md-4"><label>Gender</label><input type="text" class="form-control" value="{{ $patientlists->gender }}" readonly></div>
                                                            <div class="col-md-4"><label>Age</label><input type="text" class="form-control" value="{{ $patientlists->dob }}" readonly></div>
                                                            <div class="col-md-4"><label>Doctor Name</label><input type="text" class="form-control" value="{{ $patientlists->doctorName }}" readonly></div>
                                                            <div class="col-md-12"><label>Message</label><textarea class="form-control" rows="3" readonly>{{ $patientlists->message }}</textarea></div>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function confirmDelete(patientId) {
        if (confirm('Are you sure you want to delete this patient?')) {
            document.getElementById('deleteForm' + patientId).submit();
        }
    }
</script>
@endsection
