@extends('backend.layouts.master')
@section('content')
    <div class="page-wrapper">
        <div class="content">

            <div class="page-header">
                <div class="row">
                    <div class="col-sm-12">
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="index.html">Dashboard </a></li>
                            <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                            <li class="breadcrumb-item active">Patient patientambassdor List</li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-12">
                    <div class="card-box">
                        <div class="card-block">
                            <div class="d-flex justify-content-between">
                                <h6 class="card-title text-bold">Patient Ambassador List</h6>
                                <a href="{{ route('patientambassadors.create') }}" class="btn btn-primary">Add New</a>
                            </div>
                            <div class="table-responsive">
                                <table class="datatable table table-stripped ">
                                    <thead>
                                        <tr>
                                            <th>Sr. No.</th>
                                            <th>Patient Ambassador</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($data as $PA )
                                        <tr>
                                        <td>{{$PA->id}}</td>
                                        <td>{{$PA->name}}</td>
                                        <td>
                                            <form action="{{route('patientambassadors.destroy',$PA->id)}}" method="post">
                                                @csrf
                                                @method('DELETE')
                                                <button class="btn btn-danger" type="submit">
                                                    <i class="bi bi-trash-fill"></i> Delete
                                                  </button>
                                            </form>
                                           
                                        </td>
                                    </tr>
                                            
                                        @endforeach
                                        


                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
     
    </div>
@endsection
