@extends('backend.layouts.master')
@section('content')
    <div class="page-wrapper">
        <div class="content">

            <div class="page-header">
                <div class="row">
                    <div class="col-sm-12">
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="index.html">Dashboard </a></li>
                            <li class="breadcrumb-item"><i class="feather-chevron-right"></i></li>
                            <li class="breadcrumb-item active">State List</li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-12">
                    <div class="card-box">
                        <div class="card-block">
                            <div class="d-flex justify-content-between">
                                <h6 class="card-title text-bold">State List</h6>
                                <a href="{{ route('admin.state.create') }}" class="btn btn-primary">Add State</a>
                            </div>
                            <div class="table-responsive">
                                <table class="datatable table table-stripped ">
                                    <thead>
                                        <tr>
                                            <th>Sr. No.</th>
                                            <th>Country Name</th>
                                            <th>State Name</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $i = 1;
                                        @endphp
                                        @foreach ($data as $item)
                                            <tr>
                                                <td>{{ $i++ }}</td>
                                                <td>{{ $item->country->name }}</td>
                                                <td>{{ $item->name }}</td>
                                                <td>
                                                    @if ($item->status == 1)
                                                        <a href="{{ route('admin.state.status', ['id' => $item->id, 'status' => 0]) }}"
                                                            class="badge badge-pill badge-success">Active</a>
                                                    @else
                                                        <a href="{{ route('admin.state.status', ['id' => $item->id, 'status' => 1]) }}"
                                                            class="badge badge-pill badge-danger">InActive</a>
                                                    @endif
                                                </td>
                                                <td><a href="{{ route('admin.state.edit', ['id' => $item->id]) }}"
                                                        class="badge badge-pill badge-primary">Edit</a>
                                                </td>
                                            </tr>
                                        @endforeach


                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection
