@extends('layouts.master')

@section('title', 'Expert Doctors | Myositis India – Get in Touch for Support & Information')

@section('description', 'Find expert doctors by specialty, location, and more.')

@section('content')

<div class="container py-5">

    <h2 class="mb-4 text-center text-primary">Expert Doctors (All Specialties)</h2>

    <div class="mb-3 d-flex flex-wrap align-items-center justify-content-between">

        <div class="input-group" style="max-width: 400px;">

            <input type="text" id="searchInput" class="form-control" placeholder="Search by any field...">

            <button class="btn btn-primary" id="searchBtn" type="button">Search</button>

            <button class="btn btn-secondary" id="clearBtn" type="button">Clear</button>

        </div>

    </div>

    <div class="table-responsive shadow rounded bg-white p-4">

        <table id="doctorTable" class="table table-hover align-middle">

            <thead class="table-dark">

                <tr>

                    <th scope="col">First Name</th>

                    <th scope="col">Last Name</th>

                    <th scope="col">Country</th>

                    <th scope="col">State</th>

                    <th scope="col">City</th>

                    <th scope="col">Specialty</th>

                </tr>

            </thead>

         <tbody>
    <tr><td>Dr. Siddhant</td><td>J</td><td>India</td><td>Delhi</td><td>Delhi</td><td>General physician</td></tr>
    <tr><td>Dr. Dheera</td><td>Grover</td><td>USA</td><td>New Jersey</td><td>Edison</td><td>General physician</td></tr>
    <tr><td>Dr. Aarushi</td><td>Saini</td><td>India</td><td>Delhi</td><td>Delhi</td><td>Ophthalmology</td></tr>
    <tr><td>Dr. Agam</td><td>Bhandari</td><td>India</td><td>Punjab</td><td>Ludhiana</td><td>Ophthalmology</td></tr>
    <tr><td>Dr. Nakul</td><td>Jain</td><td>India</td><td>Delhi</td><td>Delhi</td><td>General physician</td></tr>
    <tr><td>Dr. Karun</td><td>Saathveeg Sam</td><td>India</td><td>Delhi</td><td>Delhi</td><td>General physician</td></tr>
    <tr><td>Dr. Vishnu</td><td>Yv</td><td>India</td><td>Delhi</td><td>Delhi</td><td>Neurology</td></tr>
    <tr><td>Dr. Brian</td><td>Young</td><td>Canada</td><td>Ontario</td><td>Ontario</td><td>General physician</td></tr>
    <tr><td>Dr. Alanood</td><td>Alsolaihim</td><td>Saudi Arabia</td><td>ar-Riyad</td><td>ar Riyad</td><td>Neurologist</td></tr>
    <tr><td>Dr. Sumeet</td><td>Singla</td><td>India</td><td>Delhi</td><td>Delhi</td><td>General physician</td></tr>
    <tr><td>Dr. Sunil</td><td>Solar</td><td>India</td><td>Delhi</td><td>New Delhi</td><td>General physician</td></tr>
    <tr><td>Dr. Noorul Afidza</td><td>Muhammad</td><td>Malaysia</td><td>Selangor</td><td>Bandar Baru Bangi</td><td>Pulmonologist</td></tr>
    <tr><td>Dr. Monica</td><td>Gupta</td><td>India</td><td>Chandigarh</td><td>Chandigarh</td><td>General physician</td></tr>
    <tr><td>Dr. Venkata Supraja</td><td>Reddy</td><td>India</td><td>Andhra Pradesh</td><td>Tirupati</td><td>General Physician</td></tr>
    <tr><td>Dr. Anand</td><td>Ghildyal</td><td>India</td><td>Himachal Pradesh</td><td>Nalagarh</td><td>General physician</td></tr>
    <tr><td>Dr. Govind</td><td>Singh</td><td>India</td><td>Uttar Pradesh</td><td>Muzaffarnagar</td><td>Pulmonologist</td></tr>
    <tr><td>Dr. Jose</td><td>Bustos</td><td>Colombia</td><td>Boyaca</td><td>Tunja</td><td>Neurologist</td></tr>
    <tr><td>Dr. Consuelo</td><td>Arroyo Schumacher</td><td>Chile</td><td>Metropolitana</td><td>Santiago</td><td>General physician</td></tr>
    <tr><td>Dr. Tanvi</td><td>Batra</td><td>India</td><td>Delhi</td><td>Delhi</td><td>General physician</td></tr>
    <tr><td>Dr. Sreedevi</td><td>S</td><td>India</td><td>Kerala</td><td>Thiruvananthapuram</td><td>General physician</td></tr>
    <tr><td>Dr. Megha</td><td>Uppin</td><td>India</td><td>Telangana</td><td>Hyderabad</td><td>Neuropathologists</td></tr>
    <tr><td>Dr. Farzana</td><td>Roshan</td><td>India</td><td>Tamil Nadu</td><td>Anakaputhur</td><td>Ayurveda physician</td></tr>
    <tr><td>Dr. Akanksha</td><td>Sharma</td><td>United States</td><td>Pennsylvania</td><td>Pittsburgh</td><td>General physician</td></tr>
    <tr><td>Dr. New Tes</td><td>Testing</td><td>India</td><td>Delhi</td><td>Delhi</td><td>Surgeon</td></tr>
    <tr><td>Dr. Zubin</td><td>Vaid</td><td>India</td><td>Maharashtra</td><td>Mumbai</td><td>General Physician</td></tr>
    <tr><td>Dr. Kunigiri</td><td>Somappa</td><td>India</td><td>Andhra Pradesh</td><td>Kurnool</td><td>General Physician</td></tr>
    <tr><td>Dr. Naresh Kumar</td><td>Midha</td><td>India</td><td>Rajasthan</td><td>Jodhpur</td><td>General Physician</td></tr>
    <tr><td>Dr. Sunil Kumar</td><td>Gothwal</td><td>India</td><td>Rajasthan</td><td>Ajmer</td><td>General physician</td></tr>
    <tr><td>Dr. Arvind</td><td>Jain</td><td>India</td><td>Rajasthan</td><td>Jodhpur</td><td>General Physician</td></tr>
    <tr><td>Dr. Nishant Kumar</td><td>Singh</td><td>India</td><td>Bihar</td><td>Patna</td><td>General Physician</td></tr>
    <tr><td>Dr. Aravinth</td><td>T</td><td>India</td><td>Tamil Nadu</td><td>Avadi</td><td>Pediatric Ortho specialist</td></tr>
    <tr><td>Dr. Rambabu</td><td>Prathipati</td><td>India</td><td>Telangana</td><td>Hyderabad</td><td>Orthopedist</td></tr>
    <tr><td>Dr. Raminder Singh</td><td>Nagpal</td><td>India</td><td>Punjab</td><td>Patiala</td><td>Orthopedist</td></tr>
    <tr><td>Dr. Abraham Edgar</td><td>Gracia-Ramos</td><td>Mexico</td><td>Mexico</td><td>Naucalpan</td><td>General physician</td></tr>
    <tr><td>Dr. Ahmed Mohiuddin</td><td>Mohammed</td><td>India</td><td>Telangana</td><td>Hyderabad</td><td>General Physician</td></tr>
    <tr><td>Dr. Imran</td><td>Mohammed</td><td>India</td><td>Telangana</td><td>Hyderabad</td><td>Dermatologist</td></tr>
    <tr><td>Dr. Deepak</td><td>Talwar</td><td>India</td><td>Uttar Pradesh</td><td>Noida</td><td>Respiratory Medicine</td></tr>
    <tr><td>Dr. Kante</td><td>Santosh</td><td>India</td><td>Telangana</td><td>Hyderabad</td><td>General Physician</td></tr>
    <tr><td>Dr. Bibhav</td><td>Bashyal</td><td>Nepal</td><td>Lumbini</td><td>Butwal</td><td>General Physician</td></tr>
    <tr><td>Dr. Ranga</td><td>Rao</td><td>India</td><td>Telangana</td><td>Medchal</td><td>Orthopedist</td></tr>
    <tr><td>Dr. Sabiya</td><td>Abdullah</td><td>India</td><td>Telangana</td><td>Secunderabad</td><td>General Physician</td></tr>
    <tr><td>Dr. Vikas</td><td>Trivedi</td><td>India</td><td>Uttar Pradesh</td><td>Allahabad</td><td>Orthopedist</td></tr>
    <tr><td>Dr. Vikram</td><td>Veggalam</td><td>India</td><td>Telangana</td><td>Hyderabad</td><td>Surgeon</td></tr>
    <tr><td>Dr. T</td><td>Shankar</td><td>India</td><td>Telangana</td><td>Hyderabad</td><td>Paediatrician and medical geneticist</td></tr>
    <tr><td>Dr. Melvin</td><td>C Anto</td><td>India</td><td>Kerala</td><td>Thrissur</td><td>General Physician</td></tr>
    <tr><td>Dr. Shiva</td><td>Aitha</td><td>India</td><td>Telangana</td><td>Siddipet</td><td>General Physician</td></tr>
    <tr><td>Dr. Guru Prasad</td><td>Sultanpurkar</td><td>India</td><td>Telangana</td><td>Hyderabad</td><td>Orthopedist</td></tr>
    <tr><td>Dr. Appu Jha</td><td>Avinash</td><td>Nepal</td><td>Janakpur</td><td>Janakpur</td><td>General Physician</td></tr>
    <tr><td>Dr. Anirudda</td><td>Deshpande</td><td>United Kingdom</td><td>Belfast</td><td>Dundonald</td><td>Neurologist</td></tr>
    <tr><td>Dr. Rajan</td><td>Kumar</td><td>India</td><td>Bihar</td><td>Patna</td><td>General Physician</td></tr>
    <tr><td>Dr. Kasuganti</td><td>Madan Mohan Rao</td><td>India</td><td>Telangana</td><td>Secunderabad</td><td>General Physician</td></tr>
    <tr><td>Dr. Deepak</td><td>Agrawal</td><td>India</td><td>Rajasthan</td><td>Jaipur</td><td>General Physician</td></tr>
    <tr><td>Dr. Hari Kishan</td><td>Boorugu</td><td>India</td><td>Telangana</td><td>Hyderabad</td><td>General Physician</td></tr>
    <tr><td>Dr. Gottipati</td><td>Rajendra</td><td>India</td><td>Telangana</td><td>Hyderabad</td><td>Anesthesiologist</td></tr>
    <tr><td>Dr. Mohd</td><td>Danish</td><td>India</td><td>Uttar Pradesh</td><td>Varanasi</td><td>General Physician</td></tr>
    <tr><td>Dr. Bhargavi</td><td>Mandarapu</td><td>India</td><td>Andhra Pradesh</td><td>Guntur</td><td>Neurologist</td></tr>
    <tr><td>Dr. Susheel Kumar</td><td>Manthena</td><td>India</td><td>Telangana</td><td>Hyderabad</td><td>General Physician</td></tr>
    <tr><td>Dr. Marra</td><td>Vijaya Durga</td><td>India</td><td>Andhra Pradesh</td><td>Narsipatnam</td><td>Orthopedist</td></tr>
    <tr><td>Dr. Rajiv</td><td>Pandarathil</td><td>India</td><td>Telangana</td><td>Secunderabad</td><td>General Physician</td></tr>
    <tr><td>Dr. Om Prakash</td><td>Agrawal</td><td>India</td><td>Telangana</td><td>Hyderabad</td><td>Orthopedist</td></tr>
    <tr><td>Dr. Ripudaman</td><td>Singh</td><td>India</td><td>Punjab</td><td>Rajpura</td><td>General Physician</td></tr>
    <tr><td>Dr. Bharadwaj</td><td>Ramakrishnan</td><td>India</td><td>Karnataka</td><td>Mangalore</td><td>General Physician</td></tr>
    <tr><td>Dr. Sai Shreya</td><td>Katikaneni</td><td>India</td><td>Telangana</td><td>Hyderabad</td><td>General Physician</td></tr>
    <tr><td>Dr. Nageswara Reddy</td><td>Pamidi</td><td>India</td><td>Telangana</td><td>Hyderabad</td><td>Nephrologist</td></tr>
</tbody>


        </table>

        <nav>

            <ul class="pagination justify-content-center" id="pagination"></ul>

        </nav>

        <div class="text-end mt-2">

            <span class="badge bg-info text-dark">Showing all expert doctors.</span>

        </div>

    </div>

</div>

<style>

    body {

        background: linear-gradient(120deg, #f8fafc 0%, #e3f0ff 100%);

    }

    .container {

        background: transparent;

    }

    .table-responsive {

        background: #fff;

        border-radius: 1rem;

        box-shadow: 0 4px 24px rgba(0, 123, 255, 0.08), 0 1.5px 4px rgba(0,0,0,0.04);

        padding: 2rem 1.5rem;

    }

    .container h2 {

        font-weight: 800;

        letter-spacing: 1px;

        font-size: 2.4rem;

        color: #0d6efd;

        text-shadow: 0 2px 8px #e3f0ff;

    }

    .input-group {

        box-shadow: 0 2px 8px rgba(13,110,253,0.08);

        border-radius: 0.5rem;

        background: #f8fafc;

        padding: 0.5rem 0.75rem;

    }

    .input-group input {

        border-radius: 0.5rem 0 0 0.5rem;

        border: 1px solid #b6d4fe;

        font-size: 1.1rem; 

    }

    .input-group button {

        border-radius: 0 0.5rem 0.5rem 0;

        font-size: 1.1rem;

    }

    .table thead th {

        vertical-align: middle;

        font-size: 1.2rem;

        letter-spacing: 0.5px;

        background: linear-gradient(90deg, #0d6efd 80%, #6ea8fe 100%);

        color: #fff;

        border: none;

    }

    .table tbody td {

        font-size: 1.1rem;

        border: none;

        background: #f8fafc;

        color: #222;

    }

    .table tbody tr {

        transition: box-shadow 0.2s, transform 0.2s;

    }

    .table tbody tr:hover {

        box-shadow: 0 2px 12px rgba(13,110,253,0.10);

        background: #e3f0ff;

        transform: scale(1.01);

    }

    .pagination .page-link {

        font-size: 1.1rem;

        color: #0d6efd;

        border: none;

        background: #f8fafc;

        margin: 0 2px;

        border-radius: 0.4rem;

        transition: background 0.2s, color 0.2s;

    }

    .pagination .page-item.active .page-link {

        background: #0d6efd;

        color: #fff;

        font-weight: 600;

        box-shadow: 0 2px 8px #b6d4fe;

    }

    .badge.bg-info {

        background: linear-gradient(90deg, #6ea8fe 0%, #b6d4fe 100%);

        color: #0d6efd !important;

        font-size: 1.1rem;

        font-weight: 500;

        border-radius: 0.5rem;

        box-shadow: 0 1px 4px #b6d4fe;

    }

    @media (max-width: 576px) {

        .container {

            padding: 0 0.5rem;

        }

        .table-responsive {

            padding: 0.5rem;

        }

        .table thead th, .table tbody td {

            font-size: 1rem;

        }

        .input-group {

            flex-direction: column;

            gap: 0.5rem;

            width: 100%;

            padding: 0.5rem 0.25rem;

        }

        .input-group input, .input-group button {

            width: 100%;

            min-width: 0;

        }

        .table {

            display: block;

            width: 100%;

            overflow-x: auto;

            -webkit-overflow-scrolling: touch;

        }

        .table thead {

            display: none;

        }

        .table tbody tr {

            display: block;

            margin-bottom: 1rem;

            border: 1px solid #b6d4fe;

            border-radius: 0.7rem;

            box-shadow: 0 1px 6px #b6d4fe;

            background: #fff;

            padding: 0.5rem 0.7rem;

        }

        .table tbody td {

            display: flex;

            justify-content: space-between;

            align-items: center;

            padding: 0.5rem 0;

            border: none;

            font-size: 1rem;

        }

        .table tbody td:before {

            content: attr(data-label);

            font-weight: 600;

            color: #0d6efd;

            flex-basis: 50%;

            text-align: left;

        }

    }

</style>

<script>

    // Simple JS Pagination for static HTML table

    document.addEventListener('DOMContentLoaded', function() {

        const rowsPerPage = 25;

        const table = document.getElementById('doctorTable');

        const tbody = table.querySelector('tbody');

        const rows = Array.from(tbody.querySelectorAll('tr'));

        const pageCount = Math.ceil(rows.length / rowsPerPage);

        const pagination = document.getElementById('pagination');

        let currentPage = 1;

        let filteredRows = rows;



        function showPage(page) {

            currentPage = page;

            filteredRows.forEach((row, idx) => {

                row.style.display = (idx >= (page-1)*rowsPerPage && idx < page*rowsPerPage) ? '' : 'none';

            });

            renderPagination();

        }



        function renderPagination() {

            const totalPages = Math.ceil(filteredRows.length / rowsPerPage);

            pagination.innerHTML = '';

            for (let i = 1; i <= totalPages; i++) {

                const li = document.createElement('li');

                li.className = 'page-item' + (i === currentPage ? ' active' : '');

                const a = document.createElement('a');

                a.className = 'page-link';

                a.href = '#';

                a.textContent = i;

                a.onclick = function(e) {

                    e.preventDefault();

                    showPage(i);

                };

                li.appendChild(a);

                pagination.appendChild(li);

            }

        }



        function filterRows() {

            const query = document.getElementById('searchInput').value.trim().toLowerCase();

            filteredRows = rows.filter(row => {

                return Array.from(row.children).some(td => td.textContent.toLowerCase().includes(query));

            });

            rows.forEach(row => row.style.display = 'none');

            showPage(1);

        }



        document.getElementById('searchBtn').addEventListener('click', filterRows);

        document.getElementById('searchInput').addEventListener('keypress', function(e) {

            if (e.key === 'Enter') filterRows();

        });

        document.getElementById('clearBtn').addEventListener('click', function() {

            document.getElementById('searchInput').value = '';

            filteredRows = rows;

            rows.forEach(row => row.style.display = '');

            showPage(1);

        });



        if (rows.length > 0) {

            filteredRows = rows;

            showPage(1);

        }

    });

    // Add data-labels for mobile responsive table

    document.addEventListener('DOMContentLoaded', function() {

        const table = document.getElementById('doctorTable');

        const headers = Array.from(table.querySelectorAll('thead th'));

        const rows = table.querySelectorAll('tbody tr');

        rows.forEach(row => {

            Array.from(row.children).forEach((td, idx) => {

                if (headers[idx]) {

                    td.setAttribute('data-label', headers[idx].innerText.trim());

                }

            });

        });

    });

</script>

@endsection