@extends('layouts.master')
@section('title', 'Expert Rheumatologists | Myositis India – Get in Touch for Support & Information')
@section('description', 'Get in touch with Myositis India for questions, collaborations, or support.')
@section('content')

<div class="container py-5">
    <h2 class="mb-4 text-center text-primary">Expert Rheumatologists</h2>
    <div class="mb-3 d-flex flex-wrap align-items-center justify-content-between">
        <div class="input-group" style="max-width: 400px;">
            <input type="text" id="searchInput" class="form-control" placeholder="Search by any field...">
            <button class="btn btn-primary" id="searchBtn" type="button">Search</button>
            <button class="btn btn-secondary" id="clearBtn" type="button">Clear</button>
        </div>
    </div>
    <div class="table-responsive shadow rounded bg-white p-4">
        <table id="rheumTable" class="table table-hover align-middle">
            <thead class="table-dark">
                <tr>
                    <th scope="col">First Name</th>
                    <th scope="col">Last Name</th>
                    <th scope="col">Country</th>
                    <th scope="col">State</th>
                    <th scope="col">City</th>
                </tr>
            </thead>
            <tbody>
                <tr><td>Dr. Zakariya</td><td>Alismaeili</td><td>Oman</td><td>ad-Dakhiliyah</td><td>Nizwa</td></tr>
                <tr><td>Dr. Debasish</td><td>Mishra</td><td>United Arab Emirates</td><td>Ajman</td><td>Ajman</td></tr>
                <tr><td>Dr. Narendra</td><td>Vadlamudi</td><td>India</td><td>Andhra Pradesh</td><td>Vijayawada</td></tr>
                <tr><td>Dr. Phanidhar</td><td>Dhanekula</td><td>India</td><td>Andhra Pradesh</td><td>Vijayawada</td></tr>
                <tr><td>Dr. Sai Kumar</td><td>Dunga</td><td>India</td><td>Andhra Pradesh</td><td>Vishakapatnam</td></tr>
                <tr><td>Dr. Vijay karthik</td><td>Bhogaraju</td><td>India</td><td>Andhra Pradesh</td><td>Guntur</td></tr>
                <tr><td>Dr. Pratyusha</td><td>Rajavarapu</td><td>India</td><td>Andhra Pradesh</td><td>Guntur</td></tr>
                <tr><td>Dr.suresh</td><td>Adimulam</td><td>India</td><td>Andhra Pradesh</td><td>Vishakapatnam</td></tr>
                <tr><td>Dr. Damodaram</td><td>Potikuri</td><td>India</td><td>Andhra Pradesh</td><td>Tirupati</td></tr>
                <tr><td>Dr. Sree Hari Reddy</td><td>Gadekallu</td><td>India</td><td>Andhra Pradesh</td><td>Kurnool</td></tr>
                <tr><td>Dr. Narasimha</td><td>Reddy</td><td>India</td><td>Andhra Pradesh</td><td>Anantpur</td></tr>
                <tr><td>Dr. Aparna</td><td>Reddy</td><td>India</td><td>Andhra Pradesh</td><td>Tirupati</td></tr>
                <tr><td>Dr. Bhargavi</td><td>Mandarapu</td><td>India</td><td>Andhra Pradesh</td><td>Guntur</td></tr>
                <tr><td>Dr. Alanood</td><td>Alsolaihim</td><td>Saudi Arabia</td><td>ar-Riyad</td><td>ar-Riyad</td></tr>
                <tr><td>Dr. John Kumar</td><td>Das</td><td>India</td><td>Assam</td><td>Guwahati</td></tr>
                <tr><td>Dr. Pradip Kumar</td><td>Sarma</td><td>India</td><td>Assam</td><td>Guwahati</td></tr>
                <tr><td>Dr.J R</td><td>Choudhury</td><td>India</td><td>Assam</td><td>Silchar</td></tr>
                <tr><td>Dr. Prabal</td><td>Barman</td><td>India</td><td>Assam</td><td>Guwahati</td></tr>
                <tr><td>Dr. Rajiv</td><td>Gupta</td><td>New Zealand</td><td>Auckland</td><td>Auckland</td></tr>
                <tr><td>Dr. Prayush</td><td>Sharma</td><td>Nepal</td><td>Bagmati</td><td>Kathmandu</td></tr>
                <tr><td>Dr. Abhilasha</td><td>Shah</td><td>Nepal</td><td>Bagmati</td><td>Lalitput</td></tr>
                <tr><td>Dr. Saket</td><td>Jha</td><td>Nepal</td><td>Bagmati</td><td>Kathmandu</td></tr>
                <tr><td>Dr. Buddhi</td><td>Paudyal</td><td>Nepal</td><td>Bagmati</td><td>Lalitpur</td></tr>
                <tr><td>Dr. Binit</td><td>Vaidya</td><td>Nepal</td><td>Bagmati</td><td>Kathmandu</td></tr>
                <tr><td>Dr. Muhammad</td><td>Nisar</td><td>United Kingdom</td><td>Bedfordshire</td><td>Bedford</td></tr>
                <tr><td>Dr. Anirudda</td><td>Deshpande</td><td>United Kingdom</td><td>Belfast</td><td>Dundonald</td></tr>
                <tr><td>Dr. Israrul</td><td>Haque</td><td>India</td><td>Bihar</td><td>Patna</td></tr>
                <tr><td>Dr. Raj</td><td>Kumar</td><td>India</td><td>Bihar</td><td>Bihar</td></tr>
                <tr><td>Dr. Sanjay</td><td>Pandey</td><td>India</td><td>Bihar</td><td>Patna</td></tr>
                <tr><td>Dr. Shiv kumar</td><td>Suman</td><td>India</td><td>Bihar</td><td>Darbhanga</td></tr>
                <tr><td>Dr. Shounak</td><td>Ghosh</td><td>United Kingdom</td><td>Birmingham</td><td>Small Heath</td></tr>
                <tr><td>Dr. A</td><td>Ramanan</td><td>United Kingdom</td><td>Bristol</td><td>Avon</td></tr>
                <tr><td>Dr. Sandini</td><td>Wijeweera</td><td>United Kingdom</td><td>Bristol</td><td>Henleaze</td></tr>
                <tr><td>Dr. Aakash</td><td>Singh</td><td>India</td><td>Chandigarh</td><td>Chandigarh</td></tr>
                <tr><td>Dr. Bodhibrata</td><td>Banerjee</td><td>India</td><td>Chandigarh</td><td>Chandigarh</td></tr>
                <tr><td>Dr. Rakesh Kumar</td><td>Pilania</td><td>India</td><td>Chandigarh</td><td>Chandigarh</td></tr>
                <tr><td>Dr. Deepti</td><td>Suri</td><td>India</td><td>Chandigarh</td><td>Chandigarh</td></tr>
                <tr><td>Dr. Naman</td><td>Jain</td><td>India</td><td>Chhattisgarh</td><td>Raipur</td></tr>
                <tr><td>Dr.Bijoy. B</td><td>Kumar</td><td>India</td><td>Chhattisgarh</td><td>Raipur</td></tr>
                <tr><td>Dr. Joydeep</td><td>Samanta</td><td>India</td><td>Chhattisgarh</td><td>Raipur</td></tr>
                <tr><td>Dr. Pranita</td><td>Pranita</td><td>India</td><td>Chhattisgarh</td><td>Raipur</td></tr>
                <tr><td>Dr. Amit</td><td>Dua</td><td>India</td><td>Chhattisgarh</td><td>Bilaspur</td></tr>
                <tr><td>Dr. Juhi</td><td>Dixit</td><td>India</td><td>Chhattisgarh</td><td>Raipur</td></tr>
                <tr><td>Dr. Melina</td><td>Dissanayake</td><td>Sri Lanka</td><td>Colombo</td><td>Colombo</td></tr>
                <tr><td>Dr. Inoshi</td><td>Atukorala</td><td>Sri Lanka</td><td>Colombo</td><td>Colombo</td></tr>
                <tr><td>Dr. NEERAJ</td><td>JAIN</td><td>India</td><td>Delhi</td><td>New Delhi</td></tr>
                <tr><td>Dr. Nakul</td><td>Jain</td><td>India</td><td>Delhi</td><td>New Delhi</td></tr>
                <tr><td>Dr. Sundeep Kumar</td><td>Upadhyaya</td><td>India</td><td>Delhi</td><td>New Delhi</td></tr>
                <tr><td>Dr. Vishnu</td><td>VY</td><td>India</td><td>Delhi</td><td>New Delhi</td></tr>
                <tr><td>Dr. Ashish</td><td>Chandwani</td><td>India</td><td>Delhi</td><td>New Delhi</td></tr>
                <tr><td>Dr. Siddharth</td><td>Jain</td><td>India</td><td>Delhi</td><td>New Delhi</td></tr>
                <tr><td>Dr. Sunil</td><td>Solar</td><td>India</td><td>Delhi</td><td>New Delhi</td></tr>
                <tr><td>Dr.Anju</td><td>Singh</td><td>India</td><td>Delhi</td><td>New Delhi</td></tr>
                <tr><td>Dr. Tanvi</td><td>batra</td><td>India</td><td>Delhi</td><td>New Delhi</td></tr>
                <tr><td>Dr.Priyanka</td><td>Kharbanda</td><td>India</td><td>Delhi</td><td>New Delhi</td></tr>
                <tr><td>Dr. Vikram babu</td><td>Pyata</td><td>India</td><td>Delhi</td><td>New Delhi</td></tr>
                <tr><td>Dr. Divya</td><td>Agarwal</td><td>India</td><td>Delhi</td><td>New Delhi</td></tr>
                <tr><td>Dr. Lalit</td><td>Duggal</td><td>India</td><td>Delhi</td><td>New Delhi</td></tr>
                <tr><td>Dr. Ranjan</td><td>Gupta</td><td>India</td><td>Delhi</td><td>New Delhi</td></tr>
                <tr><td>Dr.Anu Maheshwari</td><td>Gulati</td><td>India</td><td>Delhi</td><td>New Delhi</td></tr>
                <tr><td>Dr. Nikhil</td><td>Gupta</td><td>India</td><td>Delhi</td><td>New Delhi</td></tr>
                <tr><td>Dr. Ashish</td><td>Sharma</td><td>India</td><td>Delhi</td><td>New Delhi</td></tr>
                <tr><td>Dr. Danveer</td><td>Bhadu</td><td>India</td><td>Delhi</td><td>New Delhi</td></tr>
                <tr><td>Dr. Manjari</td><td>Agarwal</td><td>India</td><td>Delhi</td><td>New Delhi</td></tr>
                <tr><td>Dr. Vishal kaura</td><td>Aggarwal</td><td>India</td><td>Delhi</td><td>New Delhi</td></tr>
                <tr><td>Dr. Sajal</td><td>Ajmani</td><td>India</td><td>Delhi</td><td>New Delhi</td></tr>
                <tr><td>Dr. Gargi</td><td>Sasmal</td><td>India</td><td>Delhi</td><td>New Delhi</td></tr>
                <tr><td>Dr. Princi</td><td>Jain</td><td>India</td><td>Delhi</td><td>New Delhi</td></tr>
                <tr><td>Dr. Alok</td><td>Kalyani</td><td>India</td><td>Delhi</td><td>New Delhi</td></tr>
                <tr><td>Dr. Sushata Elizabeth</td><td>Mathews</td><td>India</td><td>Delhi</td><td>New Delhi</td></tr>
                <tr><td>Dr. Mayank</td><td>Goyal</td><td>India</td><td>Delhi</td><td>New Delhi</td></tr>
                <tr><td>Dr.Shruti</td><td>Bajad</td><td>India</td><td>Delhi</td><td>New Delhi</td></tr>
                <tr><td>Dr. Sakshi</td><td>Mittal</td><td>India</td><td>Delhi</td><td>New Delhi</td></tr>
                <tr><td>Dr. Akanksha</td><td>Kapoor</td><td>India</td><td>Delhi</td><td>New Delhi</td></tr>
                <tr><td>Dr. Shaloo Bhasin</td><td>Gagneja</td><td>India</td><td>Delhi</td><td>New Delhi</td></tr>
                <tr><td>Dr. Sameer</td><td>Gulati</td><td>India</td><td>Delhi</td><td>New Delhi</td></tr>
                <tr><td>Dr. Shallu</td><td>Verma</td><td>India</td><td>Delhi</td><td>New Delhi</td></tr>
                <tr><td>Dr. Vivek</td><td>Vasdev</td><td>India</td><td>Delhi</td><td>New Delhi</td></tr>
                <tr><td>Dr. Nibha</td><td>Jain</td><td>United Arab Emirates</td><td>Dubai</td><td>Dubai</td></tr>
                <tr><td>Dr. Sowndhariya</td><td>Velu Annamalai</td><td>United Arab Emirates</td><td>Dubai</td><td>Dubai</td></tr>
                <tr><td>Dr. Kapil Kumar</td><td>Garg</td><td>United Kingdom</td><td>Essex</td><td>Basildon</td></tr>
                <tr><td>Dr. Ram Krishna</td><td>Giri</td><td>Nepal</td><td>Gandaki</td><td>Pokhara</td></tr>
                <tr><td>Dr. Angela</td><td>Matsepe</td><td>South Africa</td><td>Gauteng</td><td>Randburg</td></tr>
                <tr><td>Dr. Himanshu</td><td>Pathak</td><td>India</td><td>Gujarat</td><td>Vadodara</td></tr>
                <tr><td>Dr.Rakesh</td><td>Tank</td><td>India</td><td>Gujarat</td><td>Rajkot</td></tr>
                <tr><td>Dr. Ripal</td><td>Shah</td><td>India</td><td>Gujarat</td><td>Vadodara</td></tr>
                <tr><td>Dr. Alpana</td><td>Parmar</td><td>India</td><td>Gujarat</td><td>Surat</td></tr>
                <tr><td>Dr. Vishnu</td><td>Sharma</td><td>India</td><td>Gujarat</td><td>Ahmedabad</td></tr>
                <tr><td>Dr. Kunal</td><td>Chandwar</td><td>India</td><td>Gujarat</td><td>Ahmedabad</td></tr>
                <tr><td>Dr. Solanki</td><td>Disha</td><td>India</td><td>Gujarat</td><td>Ahmedabad</td></tr>
                <tr><td>Dr. Nishant</td><td>Desai</td><td>India</td><td>Gujarat</td><td>Surat</td></tr>
                <tr><td>Dr. Devang Bharatkumar</td><td>Pandya</td><td>India</td><td>Gujarat</td><td>Ahmedabad</td></tr>
                <tr><td>Dr. Hardik</td><td>Rathod</td><td>India</td><td>Gujarat</td><td>Ahmedabad</td></tr>
                <tr><td>Dr. Manish K.</td><td>Bavaliya</td><td>India</td><td>Gujarat</td><td>Rajkot</td></tr>
                <tr><td>Dr. Alpana</td><td>Parmar</td><td>India</td><td>Gujarat</td><td>Surat</td></tr>
                <tr><td>Dr. Puja</td><td>Srivastava</td><td>India</td><td>Gujarat</td><td>Ahmedabad</td></tr>
                <tr><td>Dr. Prashant</td><td>Chotalia</td><td>India</td><td>Gujarat</td><td>Surat</td></tr>
                <tr><td>Dr. Jeet</td><td>Patel</td><td>India</td><td>Gujarat</td><td>Vadodara</td></tr>
                <tr><td>Dr. Neel</td><td>Patel</td><td>India</td><td>Gujarat</td><td>Surat</td></tr>
                <tr><td>Dr.Hardik</td><td>Rathod</td><td>India</td><td>Gujarat</td><td>Ahmedabad</td></tr>
                <tr><td>Dr. Fermin</td><td>Gonzalez</td><td>Bermuda</td><td>Hamilton</td><td>Hamilton</td></tr>
                <tr><td>Dr. Naval</td><td>Mendiratta</td><td>India</td><td>Haryana</td><td>Gurgaon</td></tr>
                <tr><td>Dr. Shubha</td><td>Bhalla</td><td>India</td><td>Haryana</td><td>Gurgaon</td></tr>
                <tr><td>Dr. Anu</td><td>Daber</td><td>India</td><td>Haryana</td><td>Gurgaon</td></tr>
                <tr><td>Dr.Isha</td><td>Jindal</td><td>India</td><td>Haryana</td><td>Panchkula</td></tr>
                <tr><td>Dr. Kushagra</td><td>Gupta</td><td>India</td><td>Haryana</td><td>Hisar</td></tr>
                <tr><td>Dr. Gaurav</td><td>Dembla</td><td>India</td><td>Haryana</td><td>Sonipat</td></tr>
                <tr><td>Dr. Rajiv Ranjan</td><td>Kumar</td><td>India</td><td>Haryana</td><td>Gurgaon</td></tr>
                <tr><td>Dr. ANSHUL</td><td>GOEL</td><td>India</td><td>Himachal Pradesh</td><td>Kangra</td></tr>
                <tr><td>Dr. Avinash</td><td>Sharma</td><td>India</td><td>Himachal Pradesh</td><td>Kangra</td></tr>
                <tr><td>Dr. Muzaffar</td><td>Bindroo</td><td>India</td><td>Jammu and Kashmir</td><td>Srinagar</td></tr>
                <tr><td>Dr. Lubna</td><td>Khurshid</td><td>India</td><td>Jammu and Kashmir</td><td>Srinagar</td></tr>
                <tr><td>Dr. Ashaq</td><td>Parrey</td><td>India</td><td>Jammu and Kashmir</td><td>Srinagar</td></tr>
                <tr><td>Dr. Mukhtar</td><td>Masoodi</td><td>India</td><td>Jammu and Kashmir</td><td>Srinagar</td></tr>
                <tr><td>Dr. Ajaz Kariem</td><td>Khan</td><td>India</td><td>Jammu and Kashmir</td><td>Srinagar</td></tr>
                <tr><td>Dr. Rajesh</td><td>Kumar</td><td>India</td><td>Jharkhand</td><td>Devghar</td></tr>
                <tr><td>Dr. Mahabaleshwar</td><td>MAMADAPUR</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr. Mahendranath</td><td>Kurugodu</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr. Vineeta</td><td>Shobha</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr. Uma</td><td>Karjigi</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr. SILAS VINAY VIDYADHAR</td><td>RAO</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr. Sangeetha</td><td>K.N</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr. Dhanshree</td><td>Gavali</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr. Ashwini</td><td>Kamath</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr. Srinivasa</td><td>Reddy</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr. Abhishek</td><td>Patil</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr. Silas Vinay Vidyadhar</td><td>Rao</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr. Rahul</td><td>Ladda</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr. Ramya</td><td>Janardana</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr. Balebail</td><td>Dharmanand</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr. GAURANG</td><td>DESHPANDE</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr. Pradeep Kumar</td><td>R</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr. Veena</td><td>Ramachandran</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr. Rashwith</td><td>Umesh</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr. Spoorthy</td><td>Raj DR</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr. Ankur</td><td>Jindal</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr. Manisha Ashwin</td><td>Daware</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr. Chengappa</td><td>Kavadichanda</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr. Benzeeta</td><td>Pinto</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr. Anna</td><td>C Das</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr. Pramod</td><td>Chebbi</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr. Rahul</td><td>Bisaralli</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr. Chethana</td><td>Dharmapalaiah</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr. Sachin</td><td>Jeevanagi</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr. RAMESH</td><td>JOIS</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr. Prakruthi</td><td>Jaladhar</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr. Pradeep</td><td>Sosigowda</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr.Sahana G</td><td>Baliga</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr. Aswin</td><td>Nair</td><td>India</td><td>Kerala</td><td>Kochi</td></tr>
                <tr><td>Dr. Jijith</td><td>Krishnan</td><td>India</td><td>Kerala</td><td>Kochi</td></tr>
                <tr><td>Dr. nayantara shenoy</td><td>shenoy</td><td>India</td><td>Kerala</td><td>Kochi</td></tr>
                <tr><td>Dr. Madan mohan</td><td>padmajan</td><td>India</td><td>Kerala</td><td>Kochi</td></tr>
                <tr><td>Dr. Rajesh</td><td>S</td><td>India</td><td>Kerala</td><td>Kochi</td></tr>
                <tr><td>Dr. Anu</td><td>sreekanth</td><td>India</td><td>Kerala</td><td>Kochi</td></tr>
                <tr><td>Dr. Paul</td><td>Antony</td><td>India</td><td>Kerala</td><td>Kochi</td></tr>
                <tr><td>Dr.Padmanabha</td><td>Shenoy D</td><td>India</td><td>Kerala</td><td>Kochi</td></tr>
                <tr><td>Dr. Rachel</td><td>Oommen</td><td>India</td><td>Kerala</td><td>Kochi</td></tr>
                <tr><td>Dr. Aditya</td><td>sudan</td><td>India</td><td>Kerala</td><td>Kochi</td></tr>
                <tr><td>Dr. Suma</td><td>Balan</td><td>India</td><td>Kerala</td><td>Kochi</td></tr>
                <tr><td>Dr. Sreenath</td><td>S</td><td>India</td><td>Kerala</td><td>Kochi</td></tr>
                <tr><td>Dr. Vishnu</td><td>S Chandran</td><td>India</td><td>Kerala</td><td>Kochi</td></tr>
                <tr><td>Dr. Deepti</td><td>Joy</td><td>India</td><td>Kerala</td><td>Kochi</td></tr>
                <tr><td>Dr. Anu</td><td>Balakrishnan</td><td>India</td><td>Kerala</td><td>Kochi</td></tr>
                <tr><td>Dr. Dantis</td><td>Emmanuel</td><td>India</td><td>Kerala</td><td>Kochi</td></tr>
                <tr><td>Dr. Sandeep</td><td>Surendran</td><td>India</td><td>Kerala</td><td>Kochi</td></tr>
                <tr><td>Dr. Sanjana</td><td>Joseph</td><td>India</td><td>Kerala</td><td>Kochi</td></tr>
                <tr><td>Dr. Narayanan</td><td>Krishnan</td><td>India</td><td>Kerala</td><td>Kochi</td></tr>
                <tr><td>Dr. Abraham</td><td>Mohan</td><td>India</td><td>Kerala</td><td>Kochi</td></tr>
                <tr><td>Dr. Manesh</td><td>Manoj</td><td>India</td><td>Kerala</td><td>Kochi</td></tr>
                <tr><td>Dr. CHANDHU</td><td>A S</td><td>India</td><td>Kerala</td><td>Kochi</td></tr>
                <tr><td>Dr. Ujjwol</td><td>Risal</td><td>Nepal</td><td>Koshi</td><td>Kathmandu</td></tr>
                <tr><td>Dr. Gagandeep</td><td>Sukhija</td><td>United Kingdom</td><td>London</td><td>London</td></tr>
                <tr><td>Dr. Apurva</td><td>Khare</td><td>India</td><td>Madhya Pradesh</td><td>Indore</td></tr>
                <tr><td>Dr. Nupoor</td><td>Acharya</td><td>India</td><td>Madhya Pradesh</td><td>Indore</td></tr>
                <tr><td>Dr. Mayank</td><td>Gupta</td><td>India</td><td>Madhya Pradesh</td><td>Indore</td></tr>
                <tr><td>Dr. Sourabh</td><td>MALVIYA</td><td>India</td><td>Madhya Pradesh</td><td>Indore</td></tr>
                <tr><td>Dr. Rupal</td><td>Choudhary</td><td>India</td><td>Madhya Pradesh</td><td>Indore</td></tr>
                <tr><td>Dr. Prateek</td><td>Deo</td><td>India</td><td>Madhya Pradesh</td><td>Indore</td></tr>
                <tr><td>Dr. Upendra</td><td>Rathore</td><td>India</td><td>Madhya Pradesh</td><td>Indore</td></tr>
                <tr><td>Dr. Akshat</td><td>Pandey</td><td>India</td><td>Madhya Pradesh</td><td>Indore</td></tr>
                <tr><td>Dr.Vaibhav</td><td>Ingle</td><td>India</td><td>Madhya Pradesh</td><td>Indore</td></tr>
                <tr><td>Dr. Gayatri</td><td>Ekbote</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Nilesh</td><td>Patil</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Ridhima</td><td>Jakhotia</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Sachin</td><td>Dhote</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Avinash</td><td>Buche</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Rishabh</td><td>Nanavati</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr.Varsha</td><td>Bhatt</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr.shailaja</td><td>Sabnis</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Sunilkumar</td><td>Singh</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Deepak</td><td>Malgutte</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Sushant</td><td>Shinde</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Astha</td><td>Ganeriwal</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. NAISAR</td><td>NAHAR</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Kavita</td><td>Krishna</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Divya</td><td>Lala</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Sushama</td><td>Jotkar</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Aniruddha</td><td>Tembe</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Soham</td><td>Kadam</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Ajit</td><td>Nalawade</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Neha</td><td>Arora</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Rachna</td><td>Shanbhag Mohite</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Sachin</td><td>Katarkar</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Shalini</td><td>Suralkar</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr.Preeti</td><td>Nagnur Mehta</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Pramod</td><td>Shaharao</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Reena</td><td>Karkhele</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Sanat</td><td>Phatak</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Rohini</td><td>samant</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr.Babita</td><td>Bondge</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Asmita</td><td>More</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Gauri</td><td>Pathak Oak</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Praveen</td><td>Jadhav</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Vaibhavi</td><td>Velangi</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Pratibha</td><td>Sagdeo</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Jyotsna</td><td>Oak</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Natasha</td><td>More</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Aditi</td><td>Patankar</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Shweta</td><td>Khopde- Vidhate</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Jitendra</td><td>Oswal</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Naziya</td><td>Maldar</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr. Abdelgaffar</td><td>Mohammed</td><td>Saudi Arabia</td><td>Makkah</td><td>Makkah</td></tr>
                <tr><td>Dr. SONAL</td><td>MEHRA</td><td>Canada</td><td>Manitoba</td><td>Winnipeg</td></tr>
                <tr><td>Dr. Lavanya</td><td>Rajagopala</td><td>Australia</td><td>Melbourne</td><td>Melbourne</td></tr>
                <tr><td>Dr. Alekhya</td><td>Amudalapalli</td><td>India</td><td>Odisha</td><td>Bhubaneswar</td></tr>
                <tr><td>Dr. Prasanta</td><td>Padhan</td><td>India</td><td>Odisha</td><td>Bhubaneswar</td></tr>
                <tr><td>Dr.pradeepta sekhar</td><td>Patro</td><td>India</td><td>Odisha</td><td>Bhubaneswar</td></tr>
                <tr><td>Dr. Sarit Sekhar</td><td>Pattanaik</td><td>India</td><td>Odisha</td><td>Bhubaneswar</td></tr>
                <tr><td>Dr. Sakir</td><td>Ahmed</td><td>India</td><td>Odisha</td><td>Bhubaneswar</td></tr>
                <tr><td>Dr. Aditi</td><td>Patel</td><td>United States</td><td>Ohio</td><td>Columbus</td></tr>
                <tr><td>Dr. Sehris</td><td>Khawaja</td><td>United States</td><td>Pennsylvania</td><td>Pittsburgh</td></tr>
                <tr><td>Dr. Anjana</td><td>Pillai</td><td>United States</td><td>Pennsylvania</td><td>Pittsburgh</td></tr>
                <tr><td>Dr. Jagan Babu</td><td>K L</td><td>India</td><td>Pondicherry</td><td>Pondicherry</td></tr>
                <tr><td>Dr. Vikas</td><td>Gupta</td><td>India</td><td>Punjab</td><td>Chandigarh</td></tr>
                <tr><td>Dr. Amit</td><td>kansal</td><td>India</td><td>Punjab</td><td>Chandigarh</td></tr>
                <tr><td>Dr. Hargurdas</td><td>Singh</td><td>India</td><td>Punjab</td><td>Chandigarh</td></tr>
                <tr><td>Dr. Renu</td><td>Saigal</td><td>India</td><td>Rajasthan</td><td>Jaipur</td></tr>
                <tr><td>Dr. Aadhaar</td><td>Dhooria</td><td>India</td><td>Rajasthan</td><td>Jaipur</td></tr>
                <tr><td>Dr. Bharat</td><td>Singh</td><td>India</td><td>Rajasthan</td><td>Jaipur</td></tr>
                <tr><td>Dr. Dheeraj Kumar</td><td>Mittal</td><td>India</td><td>Rajasthan</td><td>Jaipur</td></tr>
                <tr><td>Dr. Abhay</td><td>Shivpuri</td><td>India</td><td>Rajasthan</td><td>Jaipur</td></tr>
                <tr><td>Dr. Azizul Haque</td><td>Azad</td><td>Bangladesh</td><td>Rajshahi</td><td>Rajshahi</td></tr>
                <tr><td>Dr. Syang Pyng</td><td>Gan</td><td>Malaysia</td><td>Selangor</td><td>Shah Alam</td></tr>
                <tr><td>Dr. Choon Guan</td><td>Chua</td><td>Singapore</td><td>Singapore</td><td>Singapore</td></tr>
                <tr><td>Dr. Naveen</td><td>Ravichandran</td><td>United Kingdom</td><td>Staffordshire</td><td>Burton-upon-Trent</td></tr>
                <tr><td>Dr. Mousa</td><td>Albalwi</td><td>Saudi Arabia</td><td>Tabuk</td><td>Tabuk</td></tr>
                <tr><td>Dr. NAGA</td><td>PRABU</td><td>India</td><td>Tamil Nadu</td><td>Chennai</td></tr>
                <tr><td>Dr. KShanmuganandan</td><td>krishnan</td><td>India</td><td>Tamil Nadu</td><td>Chennai</td></tr>
                <tr><td>Dr. Vishnu priya s</td><td>S</td><td>India</td><td>Tamil Nadu</td><td>Chennai</td></tr>
                <tr><td>Dr. SEERALA</td><td>BOOPATHY</td><td>India</td><td>Tamil Nadu</td><td>Chennai</td></tr>
                <tr><td>Dr. Ponniah Subramanian</td><td>Arul Rajamurugan</td><td>India</td><td>Tamil Nadu</td><td>Chennai</td></tr>
                <tr><td>Dr. Bala</td><td>Krishnan</td><td>India</td><td>Tamil Nadu</td><td>Chennai</td></tr>
                <tr><td>Dr. Sasikala</td><td>B</td><td>India</td><td>Tamil Nadu</td><td>Chennai</td></tr>
                <tr><td>Dr. Balameena</td><td>Selvakumar</td><td>India</td><td>Tamil Nadu</td><td>Chennai</td></tr>
                <tr><td>Dr. Subramanian</td><td>NALLASIVAN</td><td>India</td><td>Tamil Nadu</td><td>Chennai</td></tr>
                <tr><td>Dr. Murugan</td><td>Sudhakar</td><td>India</td><td>Tamil Nadu</td><td>Chennai</td></tr>
                <tr><td>Dr. Sham</td><td>Santhanam</td><td>India</td><td>Tamil Nadu</td><td>Chennai</td></tr>
                <tr><td>Dr. Illiasul</td><td>Ibad</td><td>India</td><td>Tamil Nadu</td><td>Chennai</td></tr>
                <tr><td>Dr. Prabhu</td><td>Vasantha Kumar</td><td>India</td><td>Tamil Nadu</td><td>Chennai</td></tr>
                <tr><td>Dr. Shaaron</td><td>S</td><td>India</td><td>Tamil Nadu</td><td>Chennai</td></tr>
                <tr><td>Dr. Sindhuja</td><td>Rajendran</td><td>India</td><td>Tamil Nadu</td><td>Chennai</td></tr>
                <tr><td>Dr. Sathish</td><td>Kumar</td><td>India</td><td>Tamil Nadu</td><td>Chennai</td></tr>
                <tr><td>Dr. Sunitha</td><td>K</td><td>India</td><td>Telangana</td><td>Hyderabad</td></tr>
                <tr><td>Dr. Madhuri</td><td>Radhakrishna</td><td>India</td><td>Telangana</td><td>Hyderabad</td></tr>
                <tr><td>Dr. revanth</td><td>chakravarthy</td><td>India</td><td>Telangana</td><td>Hyderabad</td></tr>
                <tr><td>Dr. D Phani kumar</td><td>kumar</td><td>India</td><td>Telangana</td><td>Hyderabad</td></tr>
                <tr><td>Dr.Suvarna</td><td>Shilpa</td><td>India</td><td>Telangana</td><td>Hyderabad</td></tr>
                <tr><td>Dr. Keerthi</td><td>Talari</td><td>India</td><td>Telangana</td><td>Hyderabad</td></tr>
                <tr><td>Dr. Sravan Kumar</td><td>Appani</td><td>India</td><td>Telangana</td><td>Hyderabad</td></tr>
                <tr><td>Dr. Sowmya</td><td>Kotha</td><td>India</td><td>Telangana</td><td>Hyderabad</td></tr>
                <tr><td>Dr. ARINDAM</td><td>ROY</td><td>India</td><td>Telangana</td><td>Hyderabad</td></tr>
                <tr><td>Dr. Jithin</td><td>Mathew</td><td>India</td><td>Telangana</td><td>Hyderabad</td></tr>
                <tr><td>Dr. Jugal Kishore</td><td>KADEL</td><td>India</td><td>Telangana</td><td>Hyderabad</td></tr>
                <tr><td>Dr. Pratibha</td><td>Lakshmi</td><td>India</td><td>Telangana</td><td>Hyderabad</td></tr>
                <tr><td>Dr. Ramya</td><td>Reddy Puligari</td><td>India</td><td>Telangana</td><td>Hyderabad</td></tr>
                <tr><td>Dr. Abarna</td><td>Thangaraj</td><td>India</td><td>Telangana</td><td>Hyderabad</td></tr>
                <tr><td>Dr. Mohammad</td><td>Irfan</td><td>India</td><td>Telangana</td><td>Hyderabad</td></tr>
                <tr><td>Dr. Pei-Hsinq</td><td>Lai</td><td>Japan</td><td>Toyama</td><td>Toyama</td></tr>
                <tr><td>Dr.P D</td><td>RATH</td><td>India</td><td>Uttar Pradesh</td><td>Lucknow</td></tr>
                <tr><td>Dr. Ishan</td><td>Mishra</td><td>India</td><td>Uttar Pradesh</td><td>Lucknow</td></tr>
                <tr><td>Dr. Arun</td><td>Hegde</td><td>India</td><td>Uttar Pradesh</td><td>Lucknow</td></tr>
                <tr><td>Dr. DIGVIJAY</td><td>EKBOTE</td><td>India</td><td>Uttar Pradesh</td><td>Lucknow</td></tr>
                <tr><td>Dr. ANJUM</td><td>SIDDIQUI</td><td>India</td><td>Uttar Pradesh</td><td>Lucknow</td></tr>
                <tr><td>Dr. Darpan</td><td>Thakare</td><td>India</td><td>Uttar Pradesh</td><td>Lucknow</td></tr>
                <tr><td>Dr. Somya</td><td>Jain</td><td>India</td><td>Uttar Pradesh</td><td>Lucknow</td></tr>
                <tr><td>Dr. Mukesh</td><td>Maurya</td><td>India</td><td>Uttar Pradesh</td><td>Lucknow</td></tr>
                <tr><td>Dr. sandeep kumar</td><td>tiwari</td><td>India</td><td>Uttar Pradesh</td><td>Lucknow</td></tr>
                <tr><td>Dr. Abhishek</td><td>G P</td><td>India</td><td>Uttar Pradesh</td><td>Lucknow</td></tr>
                <tr><td>Dr. Deepak</td><td>Gautam</td><td>India</td><td>Uttar Pradesh</td><td>Lucknow</td></tr>
                <tr><td>Dr. BIMLESH</td><td>PANDEY</td><td>India</td><td>Uttar Pradesh</td><td>Lucknow</td></tr>
                <tr><td>Dr. Urmila</td><td>Dhakad</td><td>India</td><td>Uttar Pradesh</td><td>Lucknow</td></tr>
                <tr><td>Dr. Sayan</td><td>Mukherjee</td><td>India</td><td>Uttar Pradesh</td><td>Lucknow</td></tr>
                <tr><td>Dr.Kriti</td><td>Kishor</td><td>India</td><td>Uttar Pradesh</td><td>Lucknow</td></tr>
                <tr><td>Dr. Darshan Singh</td><td>Bhakuni</td><td>India</td><td>Uttar Pradesh</td><td>Lucknow</td></tr>
                <tr><td>Dr. Ankit</td><td>Jain</td><td>India</td><td>Uttar Pradesh</td><td>Lucknow</td></tr>
                <tr><td>Dr. Kiran</td><td>Seth</td><td>India</td><td>Uttar Pradesh</td><td>Lucknow</td></tr>
                <tr><td>Dr. Kishan</td><td>Majithiya</td><td>India</td><td>Uttar Pradesh</td><td>Lucknow</td></tr>
                <tr><td>Dr. Anushka</td><td>Prabhudesai</td><td>India</td><td>Uttar Pradesh</td><td>Lucknow</td></tr>
                <tr><td>Dr. Monis</td><td>Jaleel</td><td>India</td><td>Uttar Pradesh</td><td>Lucknow</td></tr>
                <tr><td>Dr. Yogesh</td><td>Singh</td><td>India</td><td>Uttarakhand</td><td>Dehradun</td></tr>
                <tr><td>Dr. Paramjeet</td><td>Singh</td><td>India</td><td>Uttarakhand</td><td>Dehradun</td></tr>
                <tr><td>Dr. Sree Deepika</td><td>Padala</td><td>New Zealand</td><td>Waikato</td><td>Hamilton</td></tr>
                <tr><td>Dr. Arghya</td><td>Chattopadhyay</td><td>India</td><td>West Bengal</td><td>Kolkata</td></tr>
                <tr><td>Dr. Ritasman</td><td>Baisya</td><td>India</td><td>West Bengal</td><td>Kolkata</td></tr>
                <tr><td>Dr. Abhra</td><td>Chowdhury</td><td>India</td><td>West Bengal</td><td>Kolkata</td></tr>
                <tr><td>Dr. Geetabali</td><td>Sircar</td><td>India</td><td>West Bengal</td><td>Kolkata</td></tr>
                <tr><td>Dr. Angan</td><td>Karmakar</td><td>India</td><td>West Bengal</td><td>Kolkata</td></tr>
                <tr><td>Dr. GAUTAM</td><td>DHAR CHOUDHURY</td><td>India</td><td>West Bengal</td><td>Kolkata</td></tr>
                <tr><td>Dr.Bodhisatwa</td><td>Choudhuri</td><td>India</td><td>West Bengal</td><td>Kolkata</td></tr>
                <tr><td>Dr. Sukdev</td><td>Manna</td><td>India</td><td>West Bengal</td><td>Kolkata</td></tr>
                <tr><td>Dr. Biswadip</td><td>Ghosh</td><td>India</td><td>West Bengal</td><td>Kolkata</td></tr>
                <tr><td>Dr. Alakendu</td><td>Ghosh</td><td>India</td><td>West Bengal</td><td>Kolkata</td></tr>
                <tr><td>Dr. Archan</td><td>Sil</td><td>India</td><td>West Bengal</td><td>Kolkata</td></tr>
                <tr><td>Dr. UDAS CHANDRA</td><td>GHOSH</td><td>India</td><td>West Bengal</td><td>Kolkata</td></tr>
                <tr><td>Dr. Partha Pratim</td><td>Pan</td><td>India</td><td>West Bengal</td><td>Kolkata</td></tr>
                <tr><td>Dr. DEBADITYA</td><td>ROY</td><td>India</td><td>West Bengal</td><td>Kolkata</td></tr>
                <tr><td>Dr.Nilesh</td><td>Patil</td><td>India</td><td>Maharashtra</td><td>Pune</td></tr>
                <tr><td>Dr.Ritasman</td><td>Baisya</td><td>India</td><td>West Bengal</td><td>Kolkata</td></tr>
                <tr><td>Dr.Aishwarya</td><td>Gopal</td><td>India</td><td>Pondicherry</td><td>Pondicherry</td></tr>
                <tr><td>Dr.Ripal</td><td>Shah</td><td>India</td><td>Gujrat</td><td>Vadodara</td></tr>
                <tr><td>Dr.Sahil</td><td>Jain</td><td>United Kingdom</td><td>London</td><td>London</td></tr>
                <tr><td>Dr.Ramya Sri</td><td>Kodali</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr.Nayantara</td><td>Shenoy</td><td>India</td><td>Kerala</td><td>Ernakulam</td></tr>
                <tr><td>Dr.Vineeta</td><td>Shobha</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr.Uma</td><td>Karjigi</td><td>India</td><td>Karnataka</td><td>Bengaluru</td></tr>
                <tr><td>Dr.Syang Pyng</td><td>Gan</td><td>Malaysia</td><td>Selangor</td><td>Shah Alam</td></tr>
                <tr><td>Dr.Manasa</td><td>Tammana</td><td>India</td><td>Odisha</td><td>Cuttack</td></tr>
                <tr><td>Dr.Madan Mohan</td><td>Padmajan</td><td>India</td><td>Kerala</td><td>Thrissur</td></tr>
                <tr><td>Dr.Able</td><td>Lawrence</td><td>India</td><td>Uttar Pradesh</td><td>Lucknow</td></tr>
            </tbody>
        </table>
        <nav>
            <ul class="pagination justify-content-center" id="pagination"></ul>
        </nav>
        <div class="text-end mt-2">
            <span class="badge bg-info text-dark">Showing all expert rheumatologists.</span>
        </div>
    </div>
</div>
<style>
  
  /* Capitalize only the first letter of the 2nd <td> (Last Name) */
  table tbody tr td:nth-child(2)::first-letter {
    text-transform: uppercase;
  }

    body {
        background: linear-gradient(120deg, #f8fafc 0%, #e3f0ff 100%);
    }
    .container {
        background: transparent;
    }
    .table-responsive {
        background: #fff;
        border-radius: 1rem;
        box-shadow: 0 4px 24px rgba(0, 123, 255, 0.08), 0 1.5px 4px rgba(0,0,0,0.04);
        padding: 2rem 1.5rem;
    }
    .container h2 {
        font-weight: 800;
        letter-spacing: 1px;
        font-size: 2.4rem;
        color: #0d6efd;
        text-shadow: 0 2px 8px #e3f0ff;
    }
    .input-group {
        box-shadow: 0 2px 8px rgba(13,110,253,0.08);
        border-radius: 0.5rem;
        background: #f8fafc;
        padding: 0.5rem 0.75rem;
    }
    .input-group input {
        border-radius: 0.5rem 0 0 0.5rem;
        border: 1px solid #b6d4fe;
        font-size: 1.1rem; 
    }
    .input-group button {
        border-radius: 0 0.5rem 0.5rem 0;
        font-size: 1.1rem;
    }
    .table thead th {
        vertical-align: middle;
        font-size: 1.2rem;
        letter-spacing: 0.5px;
        background: linear-gradient(90deg, #0d6efd 80%, #6ea8fe 100%);
        color: #fff;
        border: none;
    }
    .table tbody td {
        font-size: 1.1rem;
        border: none;
        background: #f8fafc;
        color: #222;
    }
    .table tbody tr {
        transition: box-shadow 0.2s, transform 0.2s;
    }
    .table tbody tr:hover {
        box-shadow: 0 2px 12px rgba(13,110,253,0.10);
        background: #e3f0ff;
        transform: scale(1.01);
    }
    .pagination .page-link {
        font-size: 1.1rem;
        color: #0d6efd;
        border: none;
        background: #f8fafc;
        margin: 0 2px;
        border-radius: 0.4rem;
        transition: background 0.2s, color 0.2s;
    }
    .pagination .page-item.active .page-link {
        background: #0d6efd;
        color: #fff;
        font-weight: 600;
        box-shadow: 0 2px 8px #b6d4fe;
    }
    .badge.bg-info {
        background: linear-gradient(90deg, #6ea8fe 0%, #b6d4fe 100%);
        color: #0d6efd !important;
        font-size: 1.1rem;
        font-weight: 500;
        border-radius: 0.5rem;
        box-shadow: 0 1px 4px #b6d4fe;
    }
    @media (max-width: 576px) {
        .container {
            padding: 0 0.5rem;
        }
        .table-responsive {
            padding: 0.5rem;
        }
        .table thead th, .table tbody td {
            font-size: 1rem;
        }
        .input-group {
            flex-direction: column;
            gap: 0.5rem;
            width: 100%;
            padding: 0.5rem 0.25rem;
        }
        .input-group input, .input-group button {
            width: 100%;
            min-width: 0;
        }
        .table {
            display: block;
            width: 100%;
            overflow-x: auto;
            -webkit-overflow-scrolling: touch;
        }
        .table thead {
            display: none;
        }
        .table tbody tr {
            display: block;
            margin-bottom: 1rem;
            border: 1px solid #b6d4fe;
            border-radius: 0.7rem;
            box-shadow: 0 1px 6px #b6d4fe;
            background: #fff;
            padding: 0.5rem 0.7rem;
        }
        .table tbody td {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0.5rem 0;
            border: none;
            font-size: 1rem;
        }
        .table tbody td:before {
            content: attr(data-label);
            font-weight: 600;
            color: #0d6efd;
            flex-basis: 50%;
            text-align: left;
        }
    }
</style>
<script>
    // Simple JS Pagination for static HTML table
    document.addEventListener('DOMContentLoaded', function() {
        const rowsPerPage = 25;
        const table = document.getElementById('rheumTable');
        const tbody = table.querySelector('tbody');
        const rows = Array.from(tbody.querySelectorAll('tr'));
        const pageCount = Math.ceil(rows.length / rowsPerPage);
        const pagination = document.getElementById('pagination');
        let currentPage = 1;
        let filteredRows = rows;

        function showPage(page) {
            currentPage = page;
            filteredRows.forEach((row, idx) => {
                row.style.display = (idx >= (page-1)*rowsPerPage && idx < page*rowsPerPage) ? '' : 'none';
            });
            renderPagination();
        }

        function renderPagination() {
            const totalPages = Math.ceil(filteredRows.length / rowsPerPage);
            pagination.innerHTML = '';
            for (let i = 1; i <= totalPages; i++) {
                const li = document.createElement('li');
                li.className = 'page-item' + (i === currentPage ? ' active' : '');
                const a = document.createElement('a');
                a.className = 'page-link';
                a.href = '#';
                a.textContent = i;
                a.onclick = function(e) {
                    e.preventDefault();
                    showPage(i);
                };
                li.appendChild(a);
                pagination.appendChild(li);
            }
        }

        function filterRows() {
            const query = document.getElementById('searchInput').value.trim().toLowerCase();
            filteredRows = rows.filter(row => {
                return Array.from(row.children).some(td => td.textContent.toLowerCase().includes(query));
            });
            rows.forEach(row => row.style.display = 'none');
            showPage(1);
        }

        document.getElementById('searchBtn').addEventListener('click', filterRows);
        document.getElementById('searchInput').addEventListener('keypress', function(e) {
            if (e.key === 'Enter') filterRows();
        });
        document.getElementById('clearBtn').addEventListener('click', function() {
            document.getElementById('searchInput').value = '';
            filteredRows = rows;
            rows.forEach(row => row.style.display = '');
            showPage(1);
        });

        if (rows.length > 0) {
            filteredRows = rows;
            showPage(1);
        }
    });
    // Add data-labels for mobile responsive table
    document.addEventListener('DOMContentLoaded', function() {
        const table = document.getElementById('rheumTable');
        const headers = Array.from(table.querySelectorAll('thead th'));
        const rows = table.querySelectorAll('tbody tr');
        rows.forEach(row => {
            Array.from(row.children).forEach((td, idx) => {
                if (headers[idx]) {
                    td.setAttribute('data-label', headers[idx].innerText.trim());
                }
            });
        });
    });
</script>
@endsection