@extends('layouts.master')
@section('title', 'Myositis India - Awareness & Support for Patients')
@section('description', 'Providing resources and community support for Myositis patients in India.')
@section('canonical', 'https://www.myositisindia.org/')
@section('content')



<body class="sticky-header-on tablet-sticky-header">

    <div id="fb-root"></div>

    <!-- Container -->

    

    <div class="container">

        <section id="content">

            <!-- Section -->

            <section class="section full-width-bg full-width-slider-section">

                <div class="row">

                    <div class="col-lg-12 col-md-12 col-sm-12">

                        <!-- Revolution Slider -->

                        <div class="tp-banner-container main-revolution">

                            <span class="Apple-tab-span"></span>

                            <div class="tp-banner full-width-revolution">

                                <ul>

                                

                                    <li data-transition="papercut" data-slotamount="7">

                                        <img src="{{ asset('asset/img/ss2.webp') }}" alt="Banner">

                                        <div class="tp-caption" data-x="100" data-y="115" data-speed="700" data-start="1000" data-easing="easeOutBack">{{-- <h2>Unity<br>Liberty<br>Solidarity</h2> --}}</div>

                                    </li>

                                    <li data-transition="papercut" data-slotamount="7">

                                        <img src="{{ asset('asset/img/patientslide.webp') }}" alt="Banner2">

                                        <div class="tp-caption" data-x="100" data-y="115" data-speed="700" data-start="1000" data-easing="easeOutBack">{{-- <h2>Unity<br>Liberty<br>Solidarity</h2> --}}</div>

                                    </li>



                                    <li data-transition="papercut" data-slotamount="7">

                                        <img src="{{ asset('asset/img/ss2.webp') }}" alt="Banner3">

                                        <div class="tp-caption align-right" data-x="right" data-y="150" data-speed="700" data-start="1000" data-easing="easeOutBack">

                                            {{-- <h2>10 YEARS OF EXPERIENCE</h2> --}}

                                        </div>

                                        <div class="tp-caption align-right" data-x="right" data-y="225" data-speed="500" data-start="1200" data-easing="easeOutBack">

                                            {{-- <p>Mauris fermentum dictum magna. Sed laoreet aliquam leo. Ut tellus dolor,<br> dapibus eget, elementum vel, cursus eleifend, elit. </p> --}}

                                        </div>

                                        <div class="tp-caption align-right" data-x="right" data-y="305" data-speed="300" data-start="1400"><a href="{{ route('about') }}" class="button big button-arrow">About Us</a></div>

                                    </li>

                                </ul>

                            </div>

                        </div>

                        <!-- /Revolution Slider -->

                    </div>

                    <div class="col-lg-12 col-md-12 col-sm-12">

                        <div class="banners-inline">

                            <div class="banner-wrapper" id="regisbtn">

                                <a class="banner animate-onscroll" href="#">

                                    <i class="icons icon-calendar"></i>

                                    <h4>Join Event</h4>

                                    <p>join us at our upcoming event!</p>

                                </a>

                            </div>

                            <div class="banner-wrapper" class="btn btn-primary" data-toggle="modal" data-target="#registrationModal">

                                <a class="banner animate-onscroll" href="{{ route('user.register') }}">

                                    <i class="icons icon-check"></i>

                                    <h4>Register!</h4>

                                    <p>Physicians | Patients</p>

                                </a>

                            </div>

                            <div class="banner-wrapper">

                                <a class="banner animate-onscroll" href="{{ route('volunteer') }}">

                                    <i class="icons icon-user"></i>

                                    <h4>Volunteer</h4>

                                    <p>Join us and help </p>

                                </a>

                            </div>

                            <div class="banner-wrapper" style="background-color:#e2eaf2;">

                                <!-- Hidden on mobile, visible on desktop/laptop -->

                                <div class="banner donate-banner animate-onscroll hidden-xs" style="background-color:#e2eaf2;">

                                    <a href="{{ route('enquiry.show') }}" class="btn btn-primary" style="width: 250px; height: 59px; padding: inherit; font-size: medium;">REQUEST

                                        AN APPOINTMENT</a>

                                </div>

                                <!-- Hidden on desktop/laptop, visible on mobile -->

                                <div class="banner donate-banner animate-onscroll visible-xs" style="text-align: center;background-color:#e2eaf2;">

                                    <a href="{{ route('enquiry.show') }}" class="btn btn-primary" style="width: 300px; height: 59px; padding: inherit; font-size: medium;">

                                        REQUEST AN APPOINTMENT</a>

                                </div>



                            </div>

                        </div>

            </section>

            <!-- Section -->

            <section class="section full-width-bg gray-bg">

                <div class="row">

                    <div class="col-lg-9 col-md-9 col-sm-8 col-lg-push-3 col-md-push-3 col-sm-push-4">

                        <div class="row">

                            <div class="col-md-4">

                                <div class="sidebar-box white animate-onscroll">

                                    <h3>Patient Ambassador</h3>

                                    <div class="infinite-rotate-wrapper" onmouseenter="stopRotation()" onmouseleave="startRotation()">

                                        <ul class="popular-news infinite-rotmate" id="vertical-carousel">

                                            @foreach ($pam as $patientambassdor)

                                            <!-- Blog Item -->

                                            <li class="carousel-item">

                                                <div class="thumbnail">

                                                    <img src="{{ asset(Storage::url($patientambassdor->image)) }}" alt="">

                                                </div>



                                                <div class="post-content">

                                                    <h6><a href="">{{ $patientambassdor->name }}</a></h6>

                                                    <div class="post-meta">

                                                        <span>{{ substr($patientambassdor->message, 0, 40) }}</span>

                                                        <br>

                                                        <a href="{{ route('ambassador.show', ['id' => $patientambassdor->id]) }}">Know

                                                            More</a>

                                                    </div>

                                                </div>

                                            </li>

                                            <!-- /Blog Item -->

                                            @endforeach

                                        </ul>



                                    </div>

                                </div>

                                <div class="col-12" style="text-align: center;background-color:#e2eaf2;border-radius:12px">

                                    <a href="{{ route('patientambassdorshow') }}">View All</a>

                                </div>

                            </div>

                            <div class="col-md-4">

                                <div class="sidebar-box white animate-onscroll">

                                    <h3>MAB MEMBERS</h3>

                                    <div class="infinite-rotate-wrapper" onmouseenter="stopRotation()" onmouseleave="startRotation()">

                                        <ul class="popular-news infinite-rotate" id="vertical-carousel">

                                            @foreach ($mab as $mabmembers)

                                            <!-- Blog Item -->

                                            <li class="carousel-item">

                                                <div class="thumbnail">

                                                    <img src="{{ asset(Storage::url($mabmembers->image)) }}" alt="">

                                                </div>



                                                <div class="post-content">

                                                    <h6><a href="{{ route('mab_member.show', ['id' => $mabmembers->id]) }}">{{ $mabmembers->name }}</a>

                                                    </h6>

                                                    <div class="post-meta">

                                                        <span>{{ substr($mabmembers->message, 0, 40) }}</span>

                                                        <br>

                                                        <a href="{{ route('mab_member.show', ['id' => $mabmembers->id]) }}">Know

                                                            More</a>

                                                    </div>

                                                </div>

                                            </li>

                                            <!-- /Blog Item -->

                                            @endforeach

                                        </ul>



                                    </div>

                                </div>

                                <div class="col-12" style="text-align: center;background-color:#e2eaf2;border-radius:12px">

                                    <a href="{{ route('mab.show') }}">View All</a>

                                </div>

                            </div>

                            <div class="col-md-4">

                                <div class="sidebar-box white animate-onscroll">

                                    <h3 style="">Latest Updates</h3>

                                    
                                    <div class="infinite-rotate-wrapper" onmouseenter="stopRotation()" onmouseleave="startRotation()">

                                        <ul class="popular-news infinite-rotate" id="vertical-carousel">



                                            <!-- Blog Item -->

                                            <li class="carousel-item">
            <i class="glyphicon glyphicon-file"></i>
            <div class="post-content">
                <h6><a href="https://www.instagram.com/p/DIggPHXNUwV/?igsh=MXgya3h6NHYzNGZ0OA==" target="_blank">
                    Our Quarterly Newsletter is out! Click here to check it out!</a>
                </h6>
            </div>
        </li>

                                            <!-- /Blog Item -->

                                            <!-- Blog Item -->

                                            <li class="carousel-item">
            <i class="glyphicon glyphicon-facetime-video"></i>
            <div class="post-content">
                <h6><a href="https://youtu.be/6iuXL6TWbPs?si=ULELDdPTlEVeCnPz" target="_blank">
                    Watch our "NAVIGATING MYOSITIS ANTIBODIES: ACCURACY, CHALLENGES AND ADVANCES" Webinar held on 13th March 2025
                </a></h6>
            </div>
        </li>

                                            <!-- /Blog Item -->

                                            <!-- Blog Item -->

                                      
        <li class="carousel-item">
            <i class="glyphicon glyphicon-camera"></i>
            <div class="post-content">
                <h6><a href="https://www.instagram.com/myositis_india?igsh=c2JucjllMzh4YTVl" target="_blank">
                    Our Instagram page now has 2.3K Followers!
                </a></h6>
            </div>
        </li>

                                            <!-- /Blog Item -->

                                                           <!-- Blog Item -->

                                                           <li class="carousel-item">
            <i class="glyphicon glyphicon-file"></i>
            <div class="post-content">
                <h6><a href="https://www.instagram.com/p/DIggPHXNUwV/?igsh=MXgya3h6NHYzNGZ0OA==" target="_blank">
                    Our Quarterly Newsletter is out! Click here to check it out!</a>
                </h6>
            </div>
        </li>

                                            <!-- /Blog Item -->

                                            <!-- Blog Item -->

                                            <li class="carousel-item">
            <i class="glyphicon glyphicon-facetime-video"></i>
            <div class="post-content">
                <h6><a href="https://youtu.be/6iuXL6TWbPs?si=ULELDdPTlEVeCnPz" target="_blank">
                    Watch our "NAVIGATING MYOSITIS ANTIBODIES: ACCURACY, CHALLENGES AND ADVANCES" Webinar held on 13th March 2025
                </a></h6>
            </div>
        </li>

                                            <!-- /Blog Item -->

                                            <!-- Blog Item -->

                                      
        <li class="carousel-item">
            <i class="glyphicon glyphicon-camera"></i>
            <div class="post-content">
                <h6><a href="https://www.instagram.com/myositis_india?igsh=c2JucjllMzh4YTVl" target="_blank">
                    Our Instagram page now has 2.3K Followers!
                </a></h6>
            </div>
        </li>                   <!-- Blog Item -->

<li class="carousel-item">
<i class="glyphicon glyphicon-file"></i>
<div class="post-content">
<h6><a href="https://www.instagram.com/p/DIggPHXNUwV/?igsh=MXgya3h6NHYzNGZ0OA==" target="_blank">
Our Quarterly Newsletter is out! Click here to check it out!</a>
</h6>
</div>
</li>

<!-- /Blog Item -->

<!-- Blog Item -->

<li class="carousel-item">
<i class="glyphicon glyphicon-facetime-video"></i>
<div class="post-content">
<h6><a href="https://youtu.be/6iuXL6TWbPs?si=ULELDdPTlEVeCnPz" target="_blank">
Watch our "NAVIGATING MYOSITIS ANTIBODIES: ACCURACY, CHALLENGES AND ADVANCES" Webinar held on 13th March 2025
</a></h6>
</div>
</li>

<!-- /Blog Item -->

<!-- Blog Item -->


<li class="carousel-item">
<i class="glyphicon glyphicon-camera"></i>
<div class="post-content">
<h6><a href="https://www.instagram.com/myositis_india?igsh=c2JucjllMzh4YTVl" target="_blank">
Our Instagram page now has 2.3K Followers!
</a></h6>
</div>
</li>

                                          

                                      



                                            





                                        </ul>



                                    </div>

                                </div>

                                <div class="col-12" style="text-align: center;background-color:#e2eaf2;border-radius:12px">

                                    <a href="">View All</a>

                                </div>

                            </div>



                        </div>

                        <h3 class="animate-onscroll no-margin-top"></h3>

                        <br>

                        <!-- Blog Post -->

                        <div class="blog-post big animate-onscroll">


<h1 class="headin">Welcome to Myositis India</h1>
                            <h4 style="color: black"><a href=" ">About Myositis India</a></h4>

                            <p class="animate-onscroll" style="text-align: justify">Welcome to Myositis India, a unit of Madalasa Foundation, a non-profit organization dedicated to improving the lives of people affected by myositis in India. Our mission is to raise myositis awareness, provide support, and promote research for myositis—a rare and complex autoimmune disease that causes inflammation and weakness in the muscles.



                            </p>



                            <blockquote class="align-right animate-onscroll" style="width:45%">At Myositis India, A

                                unit of Madalasa Foundation, we strive to be a reliable source of information and

                                support for individuals and families affected by myositis.</blockquote>





                            <p style="text-align: justify">

                                We provide a platform for patients, caregivers, and healthcare professionals to connect,

                                share their experiences, and learn from each other. Our website offers a wealth of

                                resources, including educational materials, support groups, and information on clinical

                                trials and treatment options.

                                One of our primary goals is to raise awareness about myositis in India. Despite being a

                                relatively rare disease, myositis can have a significant impact on the lives of those

                                affected... <a href="{{ route('about') }}">Learn More</a>

                            </p>



                        </div>

                        <!-- /Blog Post -->



                    </div>



                    <!-- Sidebar -->



                    <div class="col-lg-3 col-md-3 col-sm-4 col-lg-pull-9 col-md-pull-9 col-sm-pull-8 sidebar">

                        <div class="sidebar-box white animate-onscroll">



                            <ul class="popular-news">

                                <div class="issue-image" style="text-align: center">

                                    <img src="{{ asset('asset/img/sam.webp') }}" class="img-fluid" alt="Samantha Ruth Prabhu">

                                    <h4 class="post-title"><a href="blog-single-sidebar.html">Brand Ambassador </a>

                                    </h4>

                                    <p style="text-align: center"> Samantha Ruth Prabhu <br> <span style="color:#337ab7"> "Indian actress" </span> <br>

                                        <a href="{{ route('samantha') }}" style="color: black">Know More</a>

                                    </p>

                                </div>





                            </ul>

                        </div>

                        <!-- Featured Video -->

                        <div class="sidebar-box white featured-video animate-onscroll">

                            <h3>Watch Our Video</h3>

                            <iframe width="560" height="315" src="https://www.youtube.com/embed/fpSt_ncY3Eg?si=UX6_59JwkMPfyQnb" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>

                            <a href="https://www.youtube.com/@myositis_india/videos" class="button transparent button-arrow" target="_blank">More videos</a>

                        </div>



                    </div>

                    <!-- /Sidebar -->

                </div>



                <!-- Section -->

                <section class="section2 full-width-bg gray-bg">



                    <div class="row">

                        <div class="col-sm-12">



                            <!-- Owl Carousel -->

                            <div>



                                <div class="owl-header">



                                    <h3 class="animate-onscroll">Patient Success Stories</h3>
<!-- 
                                    <span class="left-arrow"><i class="icons icon-left-dir"></i></span>

                                    <span class="right-arrow"><i class="icons icon-right-dir"></i></span> -->





                                </div>



                                <div class="owl-carousel" data-max-items="4">

                                    @foreach ($pam as $patientambassdor)

                                    <!-- Owl Item -->

                                    <div>



                                        <!-- Blog Post -->

                                        <div class="blog-post animate-onscroll">



                                            <div class="post-image">

                                                <img src="{{ asset(Storage::url($patientambassdor->image)) }}" alt="">

                                            </div>



                                            <h4 class="post-title"><a href="blog-single-sidebar.html">{{$patientambassdor->name}}</a></h4>





                                            <span>{{ substr($patientambassdor->message, 0, 40) }}</span>

                                            <a href="{{ route('ambassador.show', ['id' => $patientambassdor->id]) }}">Know

                                                More</a>

                                        </div>

                                        <!-- /Blog Post -->



                                    </div>

                                    <!-- /Owl Item -->

                                    @endforeach

                                    <div>

                                        <!-- Blog Post -->

                                        <div class="blog-post animate-onscroll">



                                            <div class="post-image">

                                                <img src="{{ asset('asset/img/DamchenPatient.png') }}" alt="patient" height="250px">

                                            </div>



                                            <h4 class="post-title"><a href="https://myositisindia.org/myositis-india-patient-Damchen">Mrs.DAMCHEN</a></h4>







                                            <span>After visiting several physicians and undergoing many tests. </span>

                                            <a href=" https://myositisindia.org/myositis-india-patient-Damchen">Know

                                                More</a>

                                        </div>

                                        <!-- /Blog Post -->

                                    </div>

                                    <!-- Blog Post -->

                                    <div class="blog-post animate-onscroll">



                                        <div class="post-image">

                                            <img src="{{ asset('asset/img/blog/11.jpg') }}" alt="" height="250px">

                                        </div>



                                        <h4 class="post-title"><a href="https://myositisindia.org/myositis-india-patient-bharat"> BHARAT SHARMA

                                            </a></h4>







                                        <span> My journey with myositis started with a feeling of constant </span>

                                        <a href="https://myositisindia.org/myositis-india-patient-bharat">Know

                                            More</a>

                                    </div>

                                    <!-- /Blog Post -->



                                </div>



                            </div>



                        </div>

                    </div>

                    <div class="col-md-12" style="text-align: center">

                        <a href="{{route('patientstory')}}"><button>View All </button></a>

                    </div>

                </section>



                <!-- /Section -->





                <!-- Section -->

                <section class="section2 full-width-bg gray-bg">



                    <div class="row">

                        <div class="col-sm-12">



                            <!-- Owl Carousel -->

                            <div>



                                <div class="owl-header">



                                    <h3 class="animate-onscroll">meet our Team</h3>

<!-- 

                                    <span class="left-arrow"><i class="icons icon-left-dir"></i></span>

                                    <span class="right-arrow"><i class="icons icon-right-dir"></i></span> -->



                                </div>



                                <div class="owl-carousel" data-max-items="4">

                                    @foreach ($teams as $team)

                                    <!-- Owl Item -->

                                    <div>





                                        <!-- Team Member -->

                                        <div class="team-member animate-onscroll ">



                                            <img class="team-member-image" src="{{ asset(Storage::url($team->image)) }}" alt="" width="250" height="250px">



                                            <div class="team-member-info">



                                                <h4>{{ $team->name }}</h4>

                                                <span class="job">{{ $team->designation }}</span>



                                                <div class="team-member-more">

                                                    <p>{{ Illuminate\Support\Str::limit($team->bio, 250) }} </p>

                                                    <a href="{{ route('team_member.show', ['id' => $team->id]) }}"><button>Know

                                                            More</button></a>

                                                </div>



                                            </div>



                                        </div>

                                        <!-- /Team Member -->





                                    </div>

                                    <!-- /Owl Item -->

                                    @endforeach





                                </div>



                            </div>



                        </div>

                    </div>

                    <div style="text-align: center">

                        <a href="{{route('team')}}"><button>View All</button></a>



                    </div>



                      <!-- /Section -->

                <style>
.headin{
    color:#1e77c3;
}
                    .card {

                        box-shadow: 0 4px 8px rgba(0,0,0,0.1);

                        padding: 20px;

                        border-radius: 10px;

                        text-align: center;

                    }

                    .center-container {

                        display: flex;

                        justify-content: center;

                        align-items: center;

                        height: 100vh;

                    }

                </style>

                <!-- Section -->

                <div class="container center-container">

                    <div class="card">
                        <h2>SPONSORSHIP AND COLLABORATION</h2><hr>
                        <div style="display: flex; justify-content: center; align-items: center; gap: 50px;">
                            <img src="{{asset('asset/img/logo-color.svg')}}" alt="Logo" class="img-responsive" style="margin: 0 auto; width: 200px; height: auto;">
                            <img src="{{asset('asset/img/brinton-logo.svg')}}" alt="Brinton Logo" class="img-responsive" style="margin: 0 auto; width: 200px; height: auto;">
                        </div>
                    </div>

                </div>

                </section>

              

			<!-- Section -->

 



            </section>

            <!-- /Section -->





 

        </section>

    </div>

    <!-- /Container -->



    @endsection