<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>@yield('title', 'Myositis India')</title>
    <meta name="description" content="@yield('description', 'Myositis India - Supporting and raising awareness for myositis patients in India. Join us in making a difference.')">
    <link rel="canonical" href="@yield('canonical', url()->current())" />
    <meta name="robots" content="index, follow">


    @include('partials.css')
     
        <style>
    .modal {
        z-index: 1050;
        position: fixed;
        top: 0;
        right: 0;
        bottom: 0;
        left: 0;
        overflow: hidden;
        display: block;
        -webkit-overflow-scrolling: touch;
        display: flex;
        justify-content: center;
        align-items: center;
        background-color: rgba(0, 0, 0, 0.5);
    }

    .modal-dialog {
        margin: 0;
        width: 60%;
        max-width: 500px;
        box-sizing: border-box;
        padding: 30px;
        position: relative;
    }

    .modal-content {
        position: relative;
        background-color: #fff;
        border-radius: 8px;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    }

    .modal .close {
        position: absolute;
        right: -15px;
        top: -15px;
        font-size: 24px;
        color: #fff;
        opacity: 1;
        background-color: #dc3545;
        border: none;
        border-radius: 50%;
        width: 35px;
        height: 35px;
        display: flex;
        justify-content: center;
        align-items: center;
        cursor: pointer;
        z-index: 1060;
        transition: all 0.3s ease;
    }

    .modal .close:hover {
        background-color: #c82333;
        transform: scale(1.1);
    }

    .modal .close:focus {
        outline: none;
    }

    .modal-body {
        position: relative;
        padding: 20px;
    }

    .modal-body img {
        max-width: 100%;
        height: auto;
        border-radius: 4px;
    }

    .navbar {
        z-index: 1000;
    }


.modal-open .modal {
    overflow-x: hidden;
    overflow-y: auto;
    z-index: 9999!important;
}
    @media (max-width: 768px) {
        .modal-dialog {
            width: 90%;
            padding: 15px;
        }
    }
</style>



    <script src="https://cdn.jsdelivr.net/npm/canvas-confetti@1.4.0/dist/confetti.browser.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/owl-carousel/1.3.3/owl.carousel.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/owl-carousel/1.3.3/owl.theme.default.min.css">
    <!-- Google tag (gtag.js) -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-71MJEPWCQ7"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-71MJEPWCQ7');
</script>

</head>

<body>
    @include('includes.header')
    @yield('content')
    @include('includes.footer')
    <nav class="mobile-nav">
        <ul class="row">
            <li class="col-sm-8"><a href="{{ route('home') }}"> <img src="{{ asset('asset/img/icons/home.png') }}" alt=""> Home</a></li>
            <li class="col-sm-8">
                <a href="{{route('donate')}}"> <img src="{{ asset('asset/img/icons/donate.png') }}" alt=""> Donate</a>
            </li>
            <li class="col-sm-8"><a href="https://api.whatsapp.com/send?phone=919350646454"><img src="{{ asset('asset/img/icons/whatsapp.png') }}" alt=""> Whatsapp</a></li>
            <div id="google_translate_element" class="fixed-button col-sm-4"></div>
        </ul>
    </nav>

    @include('button')

     
     <div id="imagePopupModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-body text-center">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                    <img src="{{ asset('asset/img/pop2 (1).jpg') }}" alt="Popup Image" class="img-responsive" style="margin: 0 auto;">
                </div>
            </div>
        </div>
    </div> -->

    <script type="text/javascript">
        // Automatically show the modal after 3 seconds but only on the home page
        @if (request()->routeIs('home'))
        setTimeout(function() {
            $('#imagePopupModal').modal('show');
        }, 2000); // 3000 milliseconds = 3 seconds
        @endif
    </script>

    @include('partials.js')

  <!-- Google Translate Element (Hidden, but Required) -->
<script type="text/javascript">
    function googleTranslateElementInit() {
        new google.translate.TranslateElement({
            pageLanguage: 'en',
            autoDisplay: false
        }, 'google_translate_element');
    }
</script>
<script src="https://translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>

<script>
document.addEventListener("DOMContentLoaded", function() {
    let button = document.getElementById("customTranslateButton");
    let dropdown = document.getElementById("custom_translate_dropdown");
    let searchInput = document.getElementById("languageSearch");

    // Toggle dropdown on button click
    button.addEventListener("click", function(event) {
        event.stopPropagation();
        dropdown.style.display = dropdown.style.display === "block" ? "none" : "block";
    });

    // Close dropdown when clicking outside
    document.addEventListener("click", function(event) {
        if (!button.contains(event.target) && !dropdown.contains(event.target)) {
            dropdown.style.display = "none";
        }
    });

    // Filter languages
    searchInput.addEventListener("input", function() {
        const query = this.value.toLowerCase();
        document.querySelectorAll(".translate-btn").forEach(item => {
            const text = item.textContent.toLowerCase();
            item.style.display = text.includes(query) ? "block" : "none";
        });
    });

    // Translate
    document.querySelectorAll(".translate-btn").forEach(item => {
        item.addEventListener("click", function(event) {
            event.preventDefault();
            let langCode = this.getAttribute("data-lang");
            localStorage.setItem("selectedLanguage", langCode);
            applyTranslation(langCode);
            dropdown.style.display = "none";
        });
    });

    function applyTranslation(lang) {
        // Add a class to the dropdown to prevent translation
        const dropdown = document.getElementById("custom_translate_dropdown");
        dropdown.classList.add("notranslate");
        
        // Add notranslate class to all language options
        document.querySelectorAll(".translate-btn").forEach(btn => {
            btn.classList.add("notranslate");
        });

        let selectElement = document.querySelector(".goog-te-combo");
        if (selectElement) {
            selectElement.value = lang;
            selectElement.dispatchEvent(new Event("change"));
        } else {
            console.error("Google Translate not loaded.");
        }
    }

    // Modify the Google Translate initialization
    function googleTranslateElementInit() {
        new google.translate.TranslateElement({
            pageLanguage: 'en',
            autoDisplay: false,
            includedLanguages: '', // Include all languages
            layout: google.translate.TranslateElement.InlineLayout.SIMPLE
        }, 'google_translate_element');
    }

    let savedLang = localStorage.getItem("selectedLanguage");
    if (savedLang) {
        applyTranslation(savedLang);
    }
});
</script>

</body>

</html>
