@extends('layouts.master')
@section('content')
<div class="container">
    <section id="content">	
			
        <!-- Page Heading -->
        <section class="section page-heading animate-onscroll">
            
            <h1>  Dermatomyositis</h1>
            <p class="breadcrumb"><a href="main-v1.html">Home</a> / Dermatomyositis</p>
            
        </section>
        <!-- Page Heading -->
        

        
        <!-- Section -->
        <section class="section full-width-bg gray-bg">
            
            <div class="row">
            
            
                <div class="col-lg-9 col-md-9 col-sm-8">
                    
                    <h3 class="animate-onscroll no-margin-top">About Dermatomyositis</h3>
                    
                    <img class="align-left animate-onscroll" src="{{asset('asset/img/myositis-types/dermto.png')}}" alt="" width="359" height="250">
                    
                    <p class="animate-onscroll"> <i>  Dermatomyositis (DM) is a form of myositis that can affect individuals of any age and gender, but is more commonly seen in women.</i>  </p>
                    
                    <p class="animate-onscroll" style="text-align: justify">It is characterized by muscle weakness, which develops gradually over time and is typically seen in the limbs closest to the core, such as the shoulders and hips. Elevated levels of creatine kinase (CK) in the blood are a common indication of muscle breakdown, but normal levels of CK can also be seen in some cases. </p>
                    
                    <p class="animate-onscroll" style="text-align: justify">One of the easiest forms of myositis to recognize, DM often presents with a visible skin rash caused by inflammation of blood vessels under the skin. The rash is usually patchy and red or purple in color, and can be seen on the eyelids, knuckles, elbows, and knees, as well as around the nail beds and on the cheeks, nose, back, or upper chest. Patients with DM may also experience itchy skin, tender areas under the skin, joint pain, an itchy scalp, and hair loss. In some cases, particularly among children, hard lumps or calcium deposits may form under the skin. There is also a variant of DM known as amyopathic dermatomyositis (ADM), which does not present with muscle weakness and does not show muscle damage in laboratory tests. In adults, DM can also be linked to an increased risk of malignancy, specifically when cancer and dermatomyositis are diagnosed within two to three years of each other.</p>
                    <h3 class="animate-onscroll no-margin-top">What are symptoms of Dermatomyositis?</h3>
                    
                    <p class="animate-onscroll" style="text-align: justify">Dermatomyositis is a rare autoimmune disorder that affects the muscles and skin. The symptoms of dermatomyositis can vary widely, but some common symptoms include:
                    <ul>
                        <li>Muscle weakness: This is the most common symptom of dermatomyositis and can affect any muscle group, but usually affects the proximal muscles (hips, shoulders, neck).</li>
                        <li>Skin rash: A characteristic rash on the face, chest, back, hands, and/or elbows is a common symptom of dermatomyositis. The rash often appears before the muscle weakness.</li>
                        <li>Difficulty swallowing: This can occur if the muscles responsible for swallowing are affected.</li>
                        <li>Fatigue: Many people with dermatomyositis experience extreme fatigue and weakness, even with minimal activity.</li>
                        <li>Joint pain: Joint pain and stiffness may be present, especially in the morning.</li>
                        <li>Shortness of breath: This can occur if the muscles responsible for breathing are affected.

                        </li>
                        <li>Raynaud's phenomenon: This is a condition in which the fingers or toes turn white or blue in response to cold or stress.</li>
                    </ul>
                    </p>
                    
                     

                    
                    
                     
                    
                </div>
                
                
                
                <!-- Sidebar -->
                @include('myositis.sidebarforpages')
                <!-- /Sidebar -->
                
                
            
            </div>
            
        </section>
        <!-- /Section -->
    
    </section>


</div>
@endsection