@extends('layouts.master')
@section('content')
<div class="container">
    <section id="content">	
			
        <!-- Page Heading -->
        <section class="section page-heading animate-onscroll">
            
            <h1>  Polymyositis</h1>
            <p class="breadcrumb"><a href="main-v1.html">Home</a> / Polymyositis</p>
            
        </section>
        <!-- Page Heading -->
        

        
        <!-- Section -->
        <section class="section full-width-bg gray-bg">
            
            <div class="row">
            
            
                <div class="col-lg-9 col-md-9 col-sm-8">
                    
                    <h3 class="animate-onscroll no-margin-top">About Polymyositis</h3>
                    
                    <img class="align-left animate-onscroll" src="{{asset('asset/img/myositis-types/polymyo.jpeg')}}" alt="" width="359" height="250">
                    
                    <p class="animate-onscroll"> <i> Polymyositis (PM) is more commonly found in adult women than men</i>  </p>
                    
                    <p class="animate-onscroll" style="text-align: justify">It typically causes muscle weakness which develops gradually over time, starting with the muscles near the trunk of the body such as the neck, hips, back, and shoulders. Some people with PM may experience muscle pain, difficulty breathing, and swallowing.  </p>
                    
                    <p class="animate-onscroll" style="text-align: justify">Elevated levels of creatine kinase (CK) in the blood, which indicate muscle damage, are commonly seen in PM patients and reflect the degree of muscle inflammation. Like dermatomyositis (DM), PM in adults can be associated with other autoimmune diseases. PM can be misdiagnosed as necrotizing myopathy (NM) or sporadic inclusion body myositis (sIBM) if muscle biopsy results are inconclusive or not performed.</p>
                    <h3 class="animate-onscroll no-margin-top">What are symptoms of Polymyositis?</h3>
                    
                    <p class="animate-onscroll" style="text-align: justify">Polymyositis is a rare autoimmune disease that affects the skeletal muscles, causing inflammation and progressive muscle weakness. The symptoms of polymyositis can vary widely, but some common ones include:
                    <ul>
                        <li>Muscle weakness: This is the most common symptom of dermatomyositis and can affect any muscle group, but usually affects the proximal muscles (hips, shoulders, neck).</li>
                        <li>Skin rash: A characteristic rash on the face, chest, back, hands, and/or elbows is a common symptom of dermatomyositis. The rash often appears before the muscle weakness.</li>
                        <li>Difficulty swallowing: This can occur if the muscles responsible for swallowing are affected.</li>
                        <li>Fatigue: Many people with dermatomyositis experience extreme fatigue and weakness, even with minimal activity.</li>
                        <li>Joint pain: Joint pain and stiffness may be present, especially in the morning.</li>
                        <li>Shortness of breath: This can occur if the muscles responsible for breathing are affected.

                        </li>
                        <li>Raynaud's phenomenon: This is a condition in which the fingers or toes turn white or blue in response to cold or stress.</li>
                    </ul>
                    </p>
         
                </div>
                
                
                
                <!-- Sidebar -->
                @include('myositis.sidebarforpages')
                <!-- /Sidebar -->
                
                
            
            </div>
            
        </section>
        <!-- /Section -->
    
    </section>


</div>
@endsection