@extends('layouts.master')
@section('title', 'About Myositis | Causes, Symptoms & Treatment | Myositis India')
@section('description', 'Understand what Myositis is, its autoimmune nature, and how it affects muscles and patient health')
@section('canonical', 'https://www.myositisindia.org/about-myositis')
@section('content')

<div class="container">

    <section id="content">	

			

        <!-- Page Heading -->

        <section class="section page-heading animate-onscroll">

            

            <h1>About Myositis</h1>

            <p class="breadcrumb"><a href="main-v1.html">Home</a> / About Myositis</p>

            

        </section>

        <!-- Page Heading -->

        

<style>
  ol ul {
    list-style-position: inside; /* Ensures bullets align properly */
    padding-left: 0; /* Removes unnecessary left padding */
    text-align: left; /* Aligns text to the left */
    margin-left: 0; /* Ensures full left alignment */
    padding: initial!important;
}

li {
    text-align: left; /* Aligns text inside the list to the left */
    display: block; /* Ensures proper alignment */
    padding-left: 0px; /* Adds some space inside the bullet */
}

    </style>

        

        <!-- Section -->

        <section class="section full-width-bg gray-bg">

            

            <div class="row">

            

            

                <div class="col-lg-9 col-md-9 col-sm-8">

                    

                    <h3 class="animate-onscroll no-margin-top">About Myositis</h3>

                    

                    <img class="align-left animate-onscroll" src="{{asset('asset/img/p1.jpeg')}}" alt="" width="359" height="250">

                    

                    <p class="animate-onscroll">Myositis simply means inflammation of muscle. ‘Myo’ refers to Muscle and ‘itis’ refers to inflammation.</p>

                    

                    <p class="animate-onscroll" style="text-align: justify">
The term "myositis" encompasses a broad range of conditions characterized by swelling and inflammation of the muscles. One common cause is autoimmune muscle disease, where the body's immune system mistakenly attacks its own muscle tissue. It can also result from infections, medication-related muscle injury, hereditary diseases, imbalanced electrolytes, or thyroid issues.
</p>


<h6>What is Myositis? More details about Myositis and its types:</h6>


                    <p class="animate-onscroll" style="text-align: justify">The term "myositis" most commonly refers to a chronic disease characterized by muscle inflammation, which often presents alongside other symptoms. This type of myositis is commonly referred to as idiopathic inflammatory myopathy (IIM). Myositis is highly diverse and has been classified into various forms, such as dermatomyositis (DM), polymyositis (PM), necrotizing myopathy (NM), sporadic inclusion body myositis (sIBM), and juvenile forms of myositis (JM).</p>

                    

                    <!-- <img class="animate-onscroll" src="img/about3.jpg" alt=""> -->

                    

                    <p class="animate-onscroll" style="text-align: justify">
Inflammatory myopathies are a type of rare muscle disease and are considered uncommon autoimmune conditions, in which the body's immune system mistakenly attacks healthy tissue instead of defending against foreign invaders like infections or viruses. The exact cause of myositis is still unknown, but some researchers believe that certain individuals may have a genetic vulnerability to developing autoimmune diseases when triggered by environmental factors, such as infection, viruses, toxins, or sunlight. However, the specific triggers remain elusive.
</p>


                    <h3 class="animate-onscroll no-margin-top">What are symptoms of Myositis?</h3>

                    

                    <p class="animate-onscroll" style="text-align: justify">Symptoms of weakness and, in some cases, muscle pain often develop gradually. Prior to a proper diagnosis, patients may struggle with everyday tasks such as rising from a low chair, climbing stairs, combing their hair, dressing, or holding objects. They may experience falls or difficulty in lifting their arms, among other symptoms. On the other hand, myositis may also present itself suddenly, especially in children. As the disease advances, some patients may experience difficulty swallowing (dysphagia) or breathing, which can indicate the presence of interstitial lung disease (ILD) caused by inflammation in the lung tissue. Muscle pain and weakness are common symptoms. Additionally, it is not uncommon for patients with myositis to have additional autoimmune diseases.</p>

                    <h3 class="animate-onscroll no-margin-top">How is Myositis diagnosed?</h3>

                    

                    <p class="animate-onscroll" style="text-align: justify">Myositis is challenging to diagnose due to limited knowledge of the disease among physicians and its rarity, making it difficult to gather enough patients for effective research on treatments. Despite these challenges, myositis is a severe illness that requires prompt and aggressive management, as it can lead to significant disability or death without proper treatment. Though symptoms can be managed and periods of remission can occur, there is no permanent cure for myositis and it is a long term or lifelong condition. </>

                    <div class="col-lg-12">

                        <h3 style="text-align: center">Types of Myositis discussed one by one below:</h3>

                        <div class="col-lg-4 md-col-4 sm-col-4">

                            <h3>Dermatomyositis</h3>

                            <p style="text-align: justify">Dermatomyositis (DM) is a form of myositis that can affect individuals of any age and gender, but is more commonly seen in women. It is characterized by muscle weakness, which develops gradually over time and is typically seen in the limbs closest to the core, such as the shoulders and hips</p>

                             <a href=""><button>Lear More</button></a>





                        </div>

                        <div class="col-lg-4 md-col-4 sm-col-4">

                            <h3>Polymyositis</h3>

                            <p style="text-align: justify">Polymyositis (PM) is more commonly found in adult women than men. It typically causes muscle weakness which develops gradually over time, starting with the muscles near the trunk of the body such as the neck, hips, back, and shoulders. Some people with PM may experience muscle pain,  </p>

                           <a href=""> <button >Lean More</button></a>

                        </div>

                        <div class="col-lg-4 md-col-4 sm-col-4">

                            <h3>Necrotizing Myopathy</h3>

                            <p style="text-align: justify">Necrotizing myopathy, also known as necrotizing autoimmune myopathy (NAM) or immune-mediated necrotizing myopathy (IMNM), was once believed to be a rare form of muscle disease, but has recently been recognized as a prevalent form of muscle inflammation.   </p>

                            <a href=""><button>Learn More</button></a>

                        </div>

                        

                    </div>

                    <div class="col-lg-12">

                        <div class="col-lg-4 md-col-4 sm-col-4">

                            <h3>Juvenile Myositis   </h3>

                            <p style="text-align: justify">Juvenile Myositis (JM), a condition that affects children under the age of 18, is characterized by muscle weakness and skin rashes. The most common form of JM is Juvenile Dermatomyositis (JDM), which is not linked to cancer like adult forms of the disease. Juvenile Polymyositis   </p>

                            <a href=""><button>Learn More</button></a>

                        </div>

                        <div class="col-lg-4 md-col-4 sm-col-4">

                            <h3>Inclusion Body Myositis: </h3>

                            <p style="text-align: justify">Sporadic inclusion body myositis (sIBM) is a type of acquired myopathy that mostly affects individuals over the age of 50 and is more common in men than women. It is distinct from other forms of myositis in terms of   </p>

                            <a href=""><button>Learn More</button></a>

                        </div><br><br> <br>

                         

                    </div> 

                    <br><br> <br>

                    <!-- <div class="col-lg-12"> -->

                    <h3 class="animate-onscroll  ">How to make a diagnosis of Myositis:</h3>

                    <p style="text-align: justify">Initial diagnosis is based on history and physical examination of the patient by an experienced doctor who have specific knowledge about myositis. These doctors belong to specialty of rheumatology, neurology and sometimes dermatology. </p>

                    <h3>History:</h3>

                    <p style="text-align: justify">To aid in the diagnostic process, it is important for you to provide as much information as possible to your physician. This information can come from your medical history, your personal and family health histories, and the details of your symptoms. Your responses to questions about your health can provide valuable clues for your physician's deductive reasoning process. It's important to include information about the timing and triggers of your symptoms, such as when you first noticed the skin rash or muscle weakness, any self-treatment attempts, any correlation to certain foods, activities, weather conditions, or infections, and any medication use, including statins. This information will help guide further investigation.</p>

                    <!-- </div> -->

                    <h3>Examination:</h3>

                    <p style="text-align: justify">Weakness is the primary symptom of muscle disease, and in the case of myositis, it is observed that not all muscles are affected equally. For instance, finger flexor muscles are more likely to be weak in sIBM. On the other hand, polymyositis (PM) and dermatomyositis (DM) mostly impact muscles near the core such as the shoulder, hip, back, and abdominal muscles. Additionally, patients with DM exhibit characteristic rashes that aid the physician in distinguishing it from PM. The physician takes these observations into consideration when making a preliminary diagnosis.</p>

                    

                    <h3 class="animate-onscroll no-margin-top">Blood test</h3>

                    

                    <img class="align-left animate-onscroll" src="{{asset('asset/img/bloodtest.png')}}" alt="myositisindiabloodtestimage" width="359" height="250">

                    

                    <p class="animate-onscroll" style="text-align: justify">After making a preliminary diagnosis, the next step is to find supporting evidence. This can be obtained from a range of tests, including blood tests. One of the most important indicators is the presence of elevated levels of muscle enzymes in the blood. Creatine kinase (CK) is the main enzyme found in muscle tissue, and when there is damage or degeneration of muscle, it leaks into the bloodstream. Elevated CK levels in the blood can indicate a problem with the muscle, and is an important piece of evidence in myositis diagnosis. Other blood tests may also be performed to rule out other diseases that may affect the muscles, and to identify specific myositis antibodies, which are becoming increasingly important in myositis diagnosis.</p> <br>

                    <h3 class="animate-onscroll no-margin-top">Electromyography:</h3>

                    <p class="animate-onscroll" style="text-align: justify">The Electromyogram (EMG) test is a crucial tool for diagnosis of myositis. The test has two components, starting with the nerve conduction study (NCS) which involves applying small electrical shocks to different points along a nerve and recording responses from the nerves and muscles. The second part of the test is the EMG study where a fine needle electrode is inserted into various muscles and the electrical signals in the nerves and muscles are recorded and evaluated for patterns of abnormalities that can indicate the presence of an inflammatory disease. However, it's important to note that the results of an EMG test can vary depending on the operator performing it, so it may be necessary to repeat the test if seeking a second opinion from a specialist. The results of the EMG test can also assist in determining the appropriate site for muscle biopsy.

                       

                    

                    <br><br>

                    <h3 class="animate-onscroll no-margin-top"> Muscle MRI:</h3>

                    

                    <img class="align-left animate-onscroll" src="{{asset('asset/img/musclesmri.png')}}" alt="" width="359" height="250">

                    

                    <p class="animate-onscroll">The use of magnetic resonance imaging (MRI) scans has become a common tool for diagnosing muscle disease, including myositis. These scans provide valuable information about the extent and location of muscle damage, and help physicians determine the best muscle to target for biopsy to confirm the diagnosis. 

                    </p>

                    <h3 class="animate-onscroll no-margintop">Muscle or Skin Biopsy</h3>

                    <p style="text-align: justify">A biopsy of muscle and/or skin tissue is often needed for a definitive diagnosis. The results from a patient's physical examination, blood tests, EMG, and MRI scans can suggest a muscle disease as the most likely diagnosis, but other diseases with similar symptoms must also be considered. A muscle biopsy provides the most reliable evidence for the physician to make a confident diagnosis and determine the proper treatment. <br>

                        The biopsy process involves removing a small piece of tissue. For a muscle biopsy, there are two options: a small incision in the skin over a muscle in the arm or leg that has been numbed with local anesthesia, or a needle to obtain muscle tissue through a small skin puncture. The incision method is more common and provides a larger tissue sample, but the needle method has the advantage of only requiring a small skin puncture.

                        The tissue sample will then be examined by a pathologist who specializes in biopsy interpretation. The tissue must be processed and stained before being viewed under a microscope, which may take up to a week. In some cases, additional biopsies may be required if the results are inconclusive. <br>

                        A skin biopsy is performed by the doctor, who numbs the affected area with a local anesthetic injection before removing a small piece of skin tissue. The tissue sample is then examined by a pathologist who is specially trained in interpreting biopsy results. Processing the tissue, which involves staining it with various chemicals, can take up to a week. In some cases, the information obtained from the biopsy may be inconclusive and a second biopsy may be necessary. Additional diagnostic tests may be performed to clarify the diagnosis or to rule out other diseases with similar symptoms. Newly diagnosed patients should also be screened for cancer or lung disease. The physician will make the most accurate diagnosis based on all available information, including physical examination, blood tests, EMG, MRI scans, and the biopsy results. This process is used to diagnose other muscle diseases, but it is especially important in the evaluation of patients with potential myositis.

                        </p>

                        <h3>Specific Blood Tests: </h3>

                        <p>During the diagnosis of a disease, the physician will need to eliminate potential causes through a history and physical examination. To aid in this process, the doctor may perform various blood tests that can provide information about muscle disease or inflammation. Here are some examples of blood tests that can be performed:

                            <ul style="
    padding: initial;
">

                                <li>Complete Blood Count (CBC)</li>

                                <li>Erythrocyte Sedimentation Rate (ESR)</li>

                                <li>C-Reactive Protein (CRP)</li>

                                <li>Creatine Kinase (CK)</li>

                                <li>Aldolase</li>

                                <li>Lactate Dehydrogenase (LDH)</li>

                                <li>Aspartate Aminotransferase (AST)</li>

                                <li>Alanine Aminotransferase (ALT)</li>

                            </ul>

                            It's important to note that these tests typically require a blood sample to be taken via needle. Some tests may require you to fast for several hours prior to the test and avoid exercise to ensure accurate results. Additionally, certain medications can affect the test results, so make sure to inform your doctor of any medication you may be taking.

                        </p>

                        <h3>Creatine Kinase (CK): </h3>

                        <p style="text-align: justify">Creatine Kinase (also referred to as CK or Creatine Phosphokinase [CPK]) is a significant blood test in the diagnosis of myopathies. It is an enzyme present in high levels in skeletal muscle, heart tissue, and the brain, and its levels in the blood increase when muscle tissue is damaged. Elevated CK levels in the blood can signal muscle damage from either a chronic condition or an acute injury. In myositis, CK levels are often greatly elevated beyond normal range. If the CK test shows muscle damage, further tests are required to determine the location and cause of the damage.

                            CK levels can also be used to monitor disease progression after treatment, however this is not always a reliable indicator. Patients with myositis may experience a discrepancy between their symptoms and CK levels, as levels may lag behind changes in the disease or be influenced by other factors like activity. <br>

                            Liver enzymes, such as alanine aminotransferase (ALT or SGPT) and aspartate aminotransferase (AST or SGOT), are found in multiple tissues, including muscle and liver. In case of muscle damage, the enzymes from damaged muscle cells enter the bloodstream, leading to elevated levels of muscle enzymes in a blood sample.

                            </p>



                            <h3>

                                Myositis Specific Antibodies:

                            </h3>

                            <p style="text-align: justify">To further aid in the diagnosis of myositis, patients can undergo testing for myositis-specific autoantibodies (MSAs) and myositis-associated autoantibodies (MAAs). These antibodies are found in about 50-70% of myositis patients and serve as an indicator of the disease. Their presence can also provide information on the potential course of the disease and its treatment. These antibodies are specific to myositis and almost never appear in individuals without the condition, making them a valuable tool in confirming the diagnosis. Additionally, they may also indicate the presence of potential complications.</p>

                           <div class="card">

                            <div class="card-header" style="text-align: center">

                                <h3>Table 1: Association of MSAs with Clinical Features</h3>

                            </div>

                            <div class="card-body">

                                <table>

                                    <thead>

                                            <th>Autoantibodies</th>

                                            <th>Clinical Features</th>

                                    </thead>

                                    <tbody> 

                                        <td>Anti-ARS</td>

                                        <td>Antisynthetase syndrome with moderate to severe muscle weakness, elevated muscle enzyme levels, Raynaud's phenomenon, mechanic's hands, fevers, arthritis, and interstitial lung disease (ILD)</td>

                                        <tr> <td>Anti-Jo-1</td> <td>Chronic and continuous disease course, symptoms lasting over 2 years after diagnosis; 65% mean five-year survival rate, usually due to ILD; antisynthetase syndrome features</td> 

                                        </tr>

                                        <tr>

                                            <td>Anti-PL-7</td>

                                            <td>Antisynthetase syndrome with higher frequency of ILD</td>

                                        </tr>

                                        <tr>

                                            <td>Anti-PL-12</td>

                                            <td>Antisynthetase syndrome with higher frequency of ILD</td>

                                        </tr>

                                        <tr>

                                            <td>Anti-EJ</td>

                                            <td>Dermatomyositis and ILD</td>

                                        </tr>

                                        <tr>

                                            <td>Anti-OJ</td>

                                            <td>Myositis and ILD</td>

                                        </tr>

                                        <tr>

                                            <td>Anti-KS</td>

                                            <td>ILD with less myositis</td>

                                        </tr>

                                        <tr>

                                            <td>Anti-Ha</td>

                                            <td>Not applicable/no data</td>

                                        </tr>

                                        <tr>

                                            <td>Anti-Zo</td>

                                            <td>Myositis and ILD</td>

                                        </tr>

                                        <tr>

                                            <td>Anti-SRP</td>

                                            <td>Acute onset necrotizing myopathy with severe weakness, elevated CK levels, and cardiac involvement; treatment-resistant</td>

                                        </tr>

                                        <tr>

                                            <td>Anti-Mi-2</td>

                                            <td>Adult dermatomyositis and juvenile dermatomyositis with hallmark cutaneous disease, milder myositis with good response to treatment</td>

                                        </tr>

                                        <tr>

                                            <td>TIF1-γ (Anti-p155/140)</td>

                                            <td>Cancer-associated myositis in adult dermatomyositis; severe cutaneous disease in adult dermatomyositis and juvenile dermatomyositis</td>

                                        </tr>

                                        <tr>

                                            <td>Anti-SAE</td>

                                            <td>Adult dermatomyositis, may present with clinically amyopathic dermatomyositis first</td>

                                        </tr>

                                        <tr>

                                            <td>Anti-MDA5 (Anti-CADM-140)</td>

                                            <td>Clinically amyopathic dermatomyositis; rapidly progressive ILD</td>

                                        </tr>

                                        <tr>

                                            <td>Anti-NXP-2</td>

                                            <td>Predominantly juvenile dermatomyositis with subcutaneous edema, calcinosis, and severe muscle phenotype with contractures; increased risk of cancer in some adult dermatomyositis studies</td>

                                        </tr>

                                        <tr>

                                            <td>Anti-HMGCR</td>

                                            <td>Necrotizing myopathy; associated with statin use in adults, severe proximal muscle weakness, partially responsive to immunosuppressive medications, better response to IVIg</td>

                                        </tr>

                                        <tr>

                                            <td>cN-1A (Mup44, NT5c1A)</td>

                                            <td>Inclusion body myositis and other forms of myositis; higher mortality risk in inclusion body myositis, more severe disease in juvenile dermatomyositis; occurs in 40-60% of inclusion body myositis patients</td>

                                        </tr>

                                         

                                       

                                    </tbody>

                                    

                                </table>

                                <p>Note:

                                    <ul style="
    padding: initial;
">

                                        <li>ARS: aminoacyl-tRNA synthetase</li>

                                        <li>AS syndrome: antisynthetase syndrome</li>

                                        <li>RP: Raynaud's phenomenon</li>

                                        <li>ILD: interstitial lung disease</li>

                                        <li>SRP: signal recognition particle</li>

                                        <li>TIF1-γ: transcriptional intermediary factor 1-gamma</li>

                                        <li>NXP-2: nuclear matrix protein NXP-2</li>

                                        <li>SAE: small-ubiquitin-like modifier activating enzyme</li>

                                        <li>MDA5: melanoma-differentiation associated gene 5</li>

                                        <li>CAM: cancer-associated myositis</li>

                                        <li>CADM: clinically amyopathic dermatomyositis</li>

                                    </ul>

                                </p>

                            </div>

                           </div>

                           <h3>Treatment of Myositis: Overview</h3>

                           <p style="text-align: justify">Myositis diseases differ greatly among patients, meaning a single treatment approach is not effective for everyone. Several medications can be used alone or in combination to treat various forms of myositis, but finding the right treatment plan may require some experimentation and consideration of potential serious side effects. Unfortunately, there are currently no fully successful treatments for certain types of myositis, including IBM. It is crucial to have open communication with your doctor regarding your treatment, its outcomes, and any adverse effects. Medications are only one aspect of treating myositis, and other therapies can also help patients manage the disease and live life to the fullest.





                            Treatment options for myositis vary widely, but most patients find that they are able to effectively manage their symptoms with medication. As research continues, new options are becoming available, allowing patients and their doctors to choose the best approach based on individual needs and considerations of risk and benefit. Many medications including steroids, immunosuppressive drugs, immunoglobulins and biological drugs are commonly used for this purpose, and are backed by research and clinical trials, as well as expert opinions and reports of success.

                            </p>

                            <h3>Specific Medications used for Myositis:</h3>

                            <p style="text-align: justify">

                        <b>1.Steroids:</b>    Corticosteroids, also known as adrenal corticosteroids, glucocorticoids, or simply steroids, are a commonly used first-line treatment for myositis diseases such as dermatomyositis (DM), polymyositis (PM), necrotizing myositis (NM), and juvenile myositis (JM) and show relatively rapid results. These medications, such as prednisone, suppress the body's immune system and help reduce inflammation in the muscles, skin, and other body systems, which eases pain and improves muscle strength. Dosage varies among patients and is determined by factors such as weight and disease severity. Doctors often prescribe relatively high doses of 40-80mg/day for an extended period of time, gradually decreasing the dose as symptoms improve. Corticosteroids may be administered orally or intravenously, with some patients, particularly children and those with severe symptoms, starting with high-dose intravenous corticosteroids followed by regular oral doses.

                        While corticosteroids are effective, they also come with frequent, severe side effects, including brittle bones, cataracts and glaucoma, stomach upset, weight gain, mood swings, diabetes, adrenal insufficiency, Cushing's syndrome, and more. Long-term use of corticosteroids in children may also impact growth and development. To minimize these side effects, doctors aim to taper the dose as quickly as possible while still effectively treating symptoms, which can take months and should not be rushed. Some patients may need to continue taking low doses of prednisone to manage their symptoms.

                        It's important to never stop or reduce your dose of corticosteroids without talking to your doctor first. Tapering the dose slowly allows your body to start producing cortisol again on its own. <br>

                        <b>2.Immunosuppressive medications:</b>

                        General information about immunosuppressants: <br>

                        Immunosuppressants are drugs that decrease the functionality of the immune system and are utilized to treat a range of conditions including autoimmune diseases, organ transplant rejection, cancer treatment, and others. In myositis diseases, these medications are often utilized as a second-line treatment or in conjunction with corticosteroids to provide better improvement, reduce steroid use, and minimize unwanted side effects. The choice of which immunosuppressant to use is determined by the patient's symptoms and the drugs' effectiveness in addressing them. This selection may change over time, depending on the effectiveness in controlling symptoms. However, it's important to note that immunosuppressants increase the risk of infections as they reduce the body's response to pathogens like bacteria and viruses. It's essential to avoid infections and report any signs of infection to the doctor promptly. The following immunosuppressants are currently used to treat myositis diseases. <br>

                        <b>Specific immunosuppressants are discussed below:</b> <br>


                        <ul style="
    padding: initial;
"><b>1.	Methotrexate: </b>: Methotrexate, initially developed as a cancer treatment in the 1940s, has become a popular medication for treating rheumatoid arthritis, a different autoimmune disease. It can be taken orally in pill or liquid form or through injection under the skin or into muscle. It may take up to three months to see results. According to a large randomized trial for JDM and DM and other studies, methotrexate is now considered a first-line treatment option for patients with moderate to severe DM and JDM. It should not be taken daily; most patients take it once a week at a dose of 15-25mg. Overdose can cause severe side effects and can be fatal. Some doctors may avoid using methotrexate for patients with myositis who also have ILD due to a small potential risk of pulmonary fibrosis.</ol>

                        <ul style="
    padding: initial;
"><b>2.	Azathioprine</b>which is used to treat rheumatoid arthritis and prevent organ transplant rejection, is also employed in the treatment of myositis. This drug is usually taken orally, along with food to prevent stomach discomfort. The starting dose is usually 50mg taken twice daily, which can be increased by 50mg every 2 to 4 weeks. It may take several months for symptoms to improve. As azathioprine affects the body's blood clotting mechanism, patients may experience easier bruising and longer bleeding from cuts. If you experience excessive bleeding, it is important to seek medical attention immediately. Azathioprine may be a better option for those with interstitial lung disease (ILD), and it is recommended that patients undergo a test for the enzyme thiopurine methyltransferase (TPMT) before starting treatment, as some individuals have a genetic deficiency that puts them at a high risk of developing severe and potentially fatal bone marrow toxicity.</ol>

                        <ul style="
    padding: initial;
"><b>3.	Mycophenolate mofetil (CellCept) :</b>3.	Mycophenolate mofetil (CellCept) is utilized to prevent organ transplant rejection and to treat other autoimmune disorders. It is usually ingested in the form of a pill and is taken twice daily, starting at a dose of 250-500 mg, then gradually increasing to a range of 2,000-3,000 mg. Those with kidney issues should take a lower dose. This medication has shown positive outcomes in patients with interstitial lung disease and difficult-to-treat dermatomyositis skin conditions, particularly when combined with prednisone or other immunosuppressant drugs.</ol>

                        <ul style="
    padding: initial;
"><b>4.	Cyclosporine and Tacrolimus (Prograf) </b>5.	Cyclosporine and Tacrolimus (Prograf) are medications commonly utilized to prevent organ transplant rejection and to treat other autoimmune diseases. In myositis, they are typically used as a secondary or tertiary option, particularly for patients with interstitial lung disease (ILD). Both medications are administered orally.</ol>

                        <ul style="
    padding: initial;
"><b>5.	Cyclophosphamide: </b>Cyclophosphamide, known as Cytoxan, was originally created as a cancer treatment. It is also used in organ transplant patients to prevent rejection. However, due to its potentially toxic nature, its use in myositis is limited to only severe cases where the patient has interstitial lung disease, gastrointestinal ulceration, skin ulceration, or is resistant to other treatments. It can be administered orally or through intravenous infusion.</ol>

                        <ul style="
    padding: initial;
"><b>6.	Hydroxychloroquine (Plaquenil) </b>7.	Hydroxychloroquine (Plaquenil) is a medication used to treat autoimmune diseases like rheumatoid arthritis and Sjögren's syndrome. It is an antimalarial drug with anti-inflammatory properties and can be used as a supplementary treatment for myositis, particularly for DM skin rash. It is taken orally.</ol>

                        

                        </p>

                        <h3>Immunoglobulins:</h3>

                        <p style="text-align: justify">Immunoglobulin is a blood product obtained from donated human plasma that contains antibodies. It is administered either intravenously (IVIg) or subcutaneously (SCIg) and the dose is calculated based on the patient's weight. Initially, 2g/kg of immunoglobulin is given over 2-5 days, then 1g/kg per month for several months and then tapered based on the response. Although it is expensive, it is usually reserved for cases that do not respond to other treatments, but it is highly effective for patients with DM skin symptoms that do not respond to other treatments. Additionally, some physicians use immunoglobulin as the first line of therapy for moderate to severe juvenile myositis, including patients with severe swallowing difficulties, especially in cases of NM with anti-HMGCR autoantibody. Although the effectiveness of IVIg in treating sIBM is debatable, some patients with swallowing problems seem to benefit from it.</p>

                        <h3>Biologics</h3>

                        <p style="text-align: justify">Biologics are different from traditional chemical drugs and are made using biological processes. Hormones, insulin, and blood-stimulating products are examples of biologics that have been used in medicine for a long time. Recent advancements in technology have allowed for the creation of complex molecules that target specific parts of the immune system. It's important to note that biologics used to treat myositis suppress the immune system, increasing the risk of serious infections and certain types of cancer in older adults. Several biologic agents are being studied for their potential to treat myositis, including Rituximab (Rituxan). Originally developed for certain types of cancer, Rituxan has been approved for the treatment of autoimmune diseases such as rheumatoid arthritis. It has shown promise in treating myositis, particularly in patients who don't respond well to other treatments. Patients with anti-SRP necrotizing myopathy, antisynthetase syndrome, or interstitial lung disease are more likely to respond to Rituxan. It is not used as a first-line or second-line treatment and is given intravenously in two doses, two weeks apart. It can take up to three months for symptoms to show improvement and its effects can last for a year or more. If Rituxan proves to be effective, doses can be repeated every 6 to 18 months.</p>

                        <h3>Role of Physical Therapy and Exercise in Myositis:</h3>

                        <p style="text-align: justify">Exercise and physical therapy play a crucial role in the treatment plan for myositis. Engaging in physical activity has been proven to decrease inflammation, decrease exhaustion, boost energy levels, and strengthen muscles, even for those with myositis. There is a significant correlation between overall health and aerobic capacity for both healthy people and individuals with myositis. Regular exercise and physical activity can enhance the quality of life and decrease the likelihood of developing serious chronic conditions such as type 2 diabetes, osteoporosis, high blood pressure, and heart disease, which are either complications of myositis or its treatment. Thus, the importance of exercise is further amplified.</p>

                    <h3 class="animate-onscroll no-margintop">Sun Protection:</h3>

                    

                    <p class="animate-onscroll">Everyone, particularly those with lighter skin, should take precautions to protect their skin from excessive sun exposure to reduce the risk of skin cancer. Myositis patients, however, need to be extra cautious in avoiding sun exposure to their skin, as even brief periods of sun exposure can cause symptoms to worsen in about 20% of myositis patients. To minimize the risk of sun damage, myositis members recommend the following strict sun safety measures:  

                        <ul style="
    padding: initial;
">

                            <li>Use sunblock with a minimum SPF of 50, even indoors and all year round, and make sure to apply it to all exposed skin. </li>

                            <li>Reapply sunblock 30 minutes prior to going outside and reapply often. </li>

                            <li>Don't forget to apply sunblock to your hands, and reapply after washing them. </li>

                            <li>Wear a hat, sunglasses, gloves, long-sleeved shirt and pants/skirt when outside, including while driving</li>

                            <li>Wear double layers of clothing or clothing specifically designed for sun protection. Be mindful of unexpected places where UV rays can reflect, such as moonlight, metallic rocks, water, cars, and windows and other glass surfaces. </li>

                            <li>Keep in mind that UV rays can penetrate through glass, so shades, heavy curtains or special window coatings are recommended for your home and office. </li>

                            <li>Use LED lightbulbs instead of regular lightbulbs, as they emit fewer UV rays. </li>

                            <li> Try to avoid going outside between 11am and 4pm. </li>

                            <li> Use laundry detergent that includes a UV protection chemical.</li>

                        </ul>

                    </p>





                    

                    

                     

                    

                </div>

                

                

                

                <!-- Sidebar -->

                @include('myositis.sidebarforpages')

                <!-- /Sidebar -->

                

                

            

            </div>

            

        </section>

        <!-- /Section -->

    

    </section>





</div>

@endsection