@extends('layouts.master')
@section('title', 'Types of Myositis | Understanding Variants & Symptoms | Myositis India')
@section('description', 'Explore different types of Myositis including polymyositis, dermatomyositis, and more.')
@section('canonical', 'https://www.myositisindia.org/types-of-myositis')
@section('content')

<div class="container">

    <section id="content">	

			

        <!-- Page Heading -->

        <section class="section page-heading animate-onscroll">

            

            <h1>About Myositis</h1>

            <p class="breadcrumb"><a href="main-v1.html">Home</a> / About Myositis</p>

            

        </section>

        <!-- Page Heading -->

        



        

        <!-- Section -->

        <section class="section full-width-bg gray-bg">

            

            <div class="row">

            

            

                <div class="col-lg-9 col-md-9 col-sm-8">

                    <h3>Types of Myositis</h3>

                    <p>There are a few different forms of myositis. Review each of the myositis

                        conditions below to learn the differences and similarities among the different types.</p>

    

                    <!-- Tabs -->

                    <div >

                        <div class="tabs">

    

                            <div class="tab-header">

                                <ul>

                                    <li>

                                        <a href="#tab11">

                                            <h6>Dermatomyositis</h6>

                                        </a>

                                    </li>

                                    <li>

                                        <a href="#tab22">

                                            <h6>Polymyositis</h6>

                                        </a>

                                    </li>

                                    <li>

                                        <a href="#tab33">

                                            <h6>Necrotizing Myopathy</h6>

                                        </a>

                                    </li>

                                    <li>

                                        <a href="#tab44">

                                            <h6>Inclusion Body Myositis</h6>

                                        </a>

                                    </li>

                                    <li>

                                        <a href="#tab55">

                                            <h6>Juvenile Myositis</h6>

                                        </a>

                                    </li>

                                </ul>

                            </div>

        

                            <div class="tab-content">

        

                                <div id="tab11" class="tab">

                                    <div class="col-lg-4 col-md-4 col-sm-12">

                                        <img src="{{asset( 'asset/img/myositis-types/dermto.png')}}" alt="" width="400px" height="250px;" >

                                    </div>

                                    <div class="col-lg-8 col-md-8 col-sm-12" style="text-align: justify">

                                        <h3>Dermatomyositis (DM)</h3>

                                        Dermatomyositis (DM) is a form of myositis that can affect individuals of any age and gender, but is more commonly seen in women. It is characterized by muscle weakness, which develops gradually over time and is typically seen in the limbs closest to the core, such as the shoulders and hips. Elevated levels of creatine kinase (CK) in the blood are a common indication of muscle breakdown, but normal levels of CK can also be seen in some cases. One of the easiest forms of myositis to recognize, DM often presents with a visible skin rash caused by inflammation of blood vessels under  ... <a href="{{route('dermatomyositis')}}">Learn More</a>

                                        

                                    </div>

                                     

                                </div>

                                <div id="tab22" class="tab">

                                    <div class="col-lg-4 col-md-4 col-sm-12">

                                        <img src="{{asset('asset/img/myositis-types/polymyo.jpeg')}}" alt="" width="400px" height="250px;" >

                                    </div>

                                     

                                    <p>Polymyositis (PM) is more commonly found in adult women than men. It typically causes muscle weakness which develops gradually over time, starting with the muscles near the trunk of the body such as the neck, hips, back, and shoulders. Some people with PM may experience muscle pain, difficulty breathing, and swallowing. Elevated levels of creatine kinase (CK) in the blood, which indicate muscle damage, are commonly seen in PM patients and reflect the degree of muscle inflammation. Like dermatomyositis (DM), PM in adults can be associated with other autoimmune diseases. PM can be... <a href="{{route('polymyositis')}}">Learn More</a> </p>

                                   

                               </div>

       

                               <div id="tab33" class="tab">

                                <div class="col-lg-4 col-md-4 col-sm-12">

                                    <img src="{{asset('asset/img/myositis-types/ncro.png')}}" alt="" width="400px" height="250px;" >

                                </div>

                                <h3>Necrotizing myopathy,</h3>

                                    <p>Necrotizing myopathy, also known as necrotizing autoimmune myopathy (NAM) or immune-mediated necrotizing myopathy (IMNM), was once believed to be a rare form of muscle disease, but has recently been recognized as a prevalent form of muscle inflammation. It typically causes muscle weakness in the limbs closest to the core, accompanied by elevated creatine kinase levels and weakness in other muscles, including breathing and swallowing muscles. In some cases, the ability to hold the head upright is also affected. Heart muscle involvement is uncommon, but there is a potential ... <a href="{{route('necrotizingmyopathy')}}">Learn More</a> </p>

                               </div>

       

        

                                <div id="tab44" class="tab">

                                    <div class="col-lg-4 col-md-4 col-sm-12">

                                        <img src="{{asset('asset/img/myositis-types/ibm.png')}}" alt="" width="400px" height="250px;" >

                                    </div>

                                    <h3>Sporadic inclusion body myositis (sIBM)</h3>

                                     <p>Sporadic inclusion body myositis (sIBM) is a type of acquired myopathy that mostly affects individuals over the age of 50 and is more common in men than women. It is distinct from other forms of myositis in terms of symptoms, treatment, and patient demographics.

                                        The symptoms of sIBM progress slowly, with weakness gradually increasing over time, sometimes over years. This slow progression and the age of typical patients often lead to the symptoms being mistaken for old age. sIBM frequently causes asymmetrical weakness, particularly in the upper legs, wrist flexors, fingers, forearms, and ... <a href="{{route('inclusionbodymyositis')}}">Learn More</a>

                                        </p>

                                    

                                </div>

        

                                <div id="tab55" class="tab">

                                    <div class="col-lg-4 col-md-4 col-sm-12">

                                        <img src="{{asset('asset/img/myositis-types/jvm.jpeg')}}" alt="" width="400px" height="250px;" >

                                    </div>

                                    <h3>Juvenile Myositis (JM)</h3>

                                     <p>Juvenile Myositis (JM), a condition that affects children under the age of 18, is characterized by muscle weakness and skin rashes. The most common form of JM is Juvenile Dermatomyositis (JDM), which is not linked to cancer like adult forms of the disease. Juvenile Polymyositis and Necrotizing Myopathy in children are rare, and IBM is not seen in juveniles. Children may have more than one autoimmune disease or overlapping conditions. JDM typically begins with a skin rash, which can be red and patchy, or appear like dry skin, red or purplish on the eyelids or cheeks, or both.... <a href="{{route('juvenilemyositis')}}">Learn More</a> </p>

                                </div>

        

                            </div>

        

                        </div>

                    </div>

                    

   

                    



                    

                    

                     

                    

                </div>

                

                

                

                <!-- Sidebar -->

                @include('myositis.sidebarforpages')

                <!-- /Sidebar -->

                

                

            

            </div>

            

        </section>

        <!-- /Section -->

    

    </section>





</div>

@endsection