@extends('layouts.master')

@section('content')
    <style>
        .issue-block {
            padding: 15px;
            margin-bottom: 20px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            
            border-radius: 4px;
        }
        .issue-content {
            text-align: justify;
        }
        .issue-content h4 {
            margin-top: 0;
            text-align: left; /* Align headings to the left */
        }
       
    </style>

    <div class="container">

        <section id="content">
            <section class="section page-heading animate-onscroll">

                <p class="breadcrumb"><a href="main-v1.html">Home</a> / Exercise Blueprint:</p>

            </section>

            <section class="section full-width-bg gray-bg">

                <div class="row">

                    <div class="col-lg-9 col-md-9 col-sm-8">

                        <div class="container">
                            <div class="issue-block">
                                <div class="issue-content">
                                    <h4>Warm-up (5-10 minutes):</h4>
                                    <ul class="list-group">
                                            <ul>
                                            <li class="list-group-item"> <b>Gentle stretching: </b>Hold each stretch for 10-30 seconds, focusing on major muscle groups (neck, shoulders, chest, back, hips, and legs). Perform 2-3 repetitions of each stretch.
                                                <li class="list-group-item"><b>Neck stretches:</b> Gently tilt your head forward, backward, and side to side.</li>
                                                <li class="list-group-item"><b>Shoulder rolls:</b> Roll your shoulders forward and backward 10 times in each direction.</li>
                                                <li class="list-group-item"><b>Chest and back stretches:</b> Clasp your hands behind your back and gently lift your arms, feeling the stretch in your chest and shoulders.</li>
                                                <li class="list-group-item"><b>Hip and leg stretches:</b> While seated, gently pull your knee toward your chest, then alternate legs.</li>
                                                <li class="list-group-item"><b>Light walking or marching in place: </b> Start with a slow pace for 1-2 minutes, then gradually increase speed as tolerated for another 3-5 minutes.</li>
                                            </ul>
                                        </li>
                                       
                                    </ul>
                                </div>
                            </div>

                            <div class="issue-block">
                                <div class="issue-content">
                                    <h4>Flexibility and Range of Motion Exercises (10-15 minutes):</h4>
                                    <ul class="list-group">
                                        <li class="list-group-item"><b>Neck rotations and side bends: </b>Gently turn your head side to side, holding each position for 5-10 seconds. Repeat 5-10 times. Then, tilt your ear toward your shoulder, holding for 5-10 seconds on each side.</li>
                                        <li class="list-group-item"><b>Shoulder rolls and arm circles: </b>Roll your shoulders forward and backward 10 times in each direction. Then, make small circles with your arms, gradually increasing the size of the circles. Perform 10 circles in each direction.</li>
                                        <li class="list-group-item"><b>Wrist and ankle rotations:</b> Rotate your wrists and ankles in both directions, holding each position for 5-10 seconds. Repeat 5-10 times.</li>
                                        <li class="list-group-item"><b>Seated or standing trunk rotations:</b> While seated or standing, gently twist your torso side to side, keeping your hips stable. Hold each position for 5-10 seconds and repeat 5-10 times on each side.</li>
                                        <li class="list-group-item"><b>Gentle hip and knee rotations:</b> While seated or lying down, make small circles with your hips and knees. Perform 10 circles in each direction for each joint.</li>
                                    </ul>
                                </div>
                            </div>

                            <div class="issue-block">
                                <div class="issue-content">
                                    <h4>Strength Training (15-20 minutes, 2-3 times per week):</h4>
                                    <ul class="list-group">
                                    <li class="list-group-item">1. Isometric exercises (muscle contraction without joint movement)

                                            <ul>

                                                <li class="list-group-item"><b>Wall push-ups: </b>Stand facing a wall at arm's length. Place your hands on the wall and lean in slightly, holding for 5-10 seconds. Repeat 5-10 times.</li>
                                                <li class="list-group-item"><b>Isometric bicep curls:</b> Place your hand on your opposite shoulder and gently press your hand into your shoulder, holding for 5-10 seconds. Repeat 5-10 times on each arm.</li>
                                                <li class="list-group-item"><b>Isometric leg extensions:</b> Sit in a chair with your feet flat on the floor. Slowly extend your leg, holding for 5-10 seconds. Repeat 5-10 times on each leg.</li>
                                            </ul>
                                        </li>
                                        <li class="list-group-item">2.Resistance band exercises
                                            <ul>
                                                <li class="list-group-item"><b>Seated rows:</b> Sit with your legs extended, wrap the band around your feet, and pull the band toward your chest, squeezing your shoulder blades together. Perform 2-3 sets of 10-15 repetitions.</li>
                                                <li class="list-group-item"><b>Lateral arm raises: </b>Stand on the band with your feet shoulder-width apart. Hold the ends of the band and slowly raise your arms out to the side until they reach shoulder level. Perform 2-3 sets of 10-15 repetitions.</li>
                                                <li class="list-group-item"><b>Leg press or squats:</b> Place the band under your feet and hold the ends. Slowly bend your knees and lower your hips, keeping your back straight. Perform 2-3 sets of 10-15 repetitions.</li>
                                            </ul>
                                        </li>
                                        <li class="list-group-item">3.Light weight exercises (only if recommended by a healthcare professional)
                                            <ul>
                                                <li class="list-group-item">Use light dumbbells (1-5 pounds) or resistance bands for exercises like bicep curls, tricep extensions, and shoulder presses. Perform 2-3 sets of 10-15 repetitions for each exercise.</li>
                                            </ul>
                                        </li>
                                    </ul>
                                </div>
                            </div>

                            <div class="issue-block">
                                <div class="issue-content">
                                    <h4>Aerobic Exercise (10-30 minutes, 3-5 times per week):</h4>
                                    <ul class="list-group">
                                        <li class="list-group-item"><b>Walking: </b>Start with 5-10 minutes at a comfortable pace. Gradually increase duration by 1-2 minutes per session, aiming for 20-30 minutes per walk. Use a supportive device if needed.</li>
                                        <li class="list-group-item"><b>Swimming or water aerobics:</b> Begin with 5-10 minutes of gentle swimming or water exercises. Gradually increase duration by 1-2 minutes per session, aiming for 20-30 minutes. Focus on low-impact movements and avoid overexertion.</li>
                                        <li class="list-group-item"><b>Stationary cycling:</b> Adjust the seat height and start with a low resistance for 5-10 minutes. Gradually increase duration and resistance as tolerated, aiming for 20-30 minutes per session.</li>
                                        <li class="list-group-item"><b>Elliptical machine:</b> Start with a low resistance and short duration (5-10 minutes). Gradually increase duration and resistance as tolerated, aiming for 20-30 minutes per session. Maintain good posture and avoid gripping the handles too tightly.</li>
                                    </ul>
                                </div>
                            </div>

                            <div class="issue-block">
                                <div class="issue-content">
                                    <h4>Cool-down (5-10 minutes):</h4>
                                    <ul class="list-group">
                                        <li class="list-group-item"><b>Gentle stretching: </b>Focus on the muscle groups you targeted during your workout. Hold each stretch for 10-30 seconds and perform 2-3 repetitions of each stretch.</li>
                                        <li class="list-group-item"><b>Deep breathing exercises:</b> Sit or stand comfortably. Inhale deeply through your nose for 4-5 seconds, then exhale slowly through your mouth for 4-5 seconds. Repeat 5-10 times.</li>
                                    </ul>
                                </div>
                            </div>

                            <div class="issue-block">
                                <div class="issue-content">
                                    <h4>Additional considerations:</h4>
                                    <ol>
                                        <li>Break up your exercise routine into smaller sessions (e.g., two 15-minute sessions instead of one 30-minute session) if needed to manage fatigue.</li>
                                        <li>Use assistive devices (e.g., canes, walkers) or support as needed to maintain balance and stability during exercises.</li>
                                        <li>Wear comfortable, supportive shoes and breathable clothing to prevent overheating and ensure proper alignment during exercises.</li>
                                        <li>Exercise in a temperature-controlled environment to avoid overheating or feeling too cold, which can exacerbate symptoms.</li>
                                        <li>Keep a log of your exercises, symptoms, and progress to share with your healthcare team. Note any pain, fatigue, or changes in your psoriasis symptoms.</li>
                                        <li>Incorporate rest days into your exercise routine to allow your body time to recover and prevent overexertion.</li>
                                        <li>Maintain open communication with your doctor, physical therapist, or other healthcare professionals about your exercise routine and any concerns or questions you may have.</li>
                                       
                                     
                                    </ol>
                                    Remember, this blueprint is a general guide, and individual needs may vary. Always consult with your doctor or physical therapist before starting a new exercise program, and seek guidance on modifications or progressions based on your specific condition and progress.
                                </div>
                            </div>

                             
                        </div>

                    </div>

                    <div class="col-lg-3 col-md-3 col-sm-4">
                        <!-- Sidebar -->
                    </div>

                </div>

            </section>
        </section>

    </div>

@endsection
