@extends('layouts.master')
@section('title', 'Patient Ambassador Program | Myositis India – Voices of Strength & Advocacy')
@section('description', 'Explore the Patient Ambassador Program and how patients are helping raise awareness.')
@section('canonical', 'https://www.myositisindia.org/myositis-india/patient/ambassdor')
@section('content') 

<div class="container">

    <section id="content">	

        <!-- Page Heading -->

        <section class="section page-heading animate-onscroll">

            <h1> Patient Ambassdor </h1>

            <p class="breadcrumb"><a href="main-v1.html">Home</a> /  Patient Ambassador</p>

        </section>

        <!-- Page Heading -->
   

        <section class="section full-width-bg gray-bg">



            <div class="row">

                <div class="col-lg-9 col-md-9 col-sm-8">

                    

                    <div class="row">

                        @foreach($data as $ambassador)

                            <div class="col-md-4">

                                <div class="card mb-3 ">

                                    <div class="card-body">

                                        <img src="{{ asset(Storage::url($ambassador->image)) }}" alt="" class="img-fluid" width="340px;" height="310px;">
                                       {{--  <div class="embed-responsive embed-responsive-16by9">

                                            <video controls>

                                                <source src="{{ asset(Storage::url($ambassador->video)) }}" type="video/mp4">

                                                Your browser does not support the video tag.

                                            </video>

                                        </div> --}}

                                        <h4 class="card-title">Name: <span style="color: #274472;"> <b> {{ $ambassador->name }} </b> </span> </h4>

                                        <p class="card-text"  style="text-align: justify;">{{Str::limit($ambassador->message,150)}}</p>

                                        <a href="{{route('ambassador.show',$ambassador->id)}}" class="btn btn-primary">Know More </a>

                                     </div>

                                </div>

                            </div>

                        @endforeach

                    </div>

                </div>

                <!-- Sidebar -->

                @include('myositis.sidebarforpages')

                <!-- /Sidebar -->

            </div>

        </section>

        <!-- /Section -->

    

    </section>



</div>

 


@endsection



