@extends('layouts.master')



@section('content')

<div class="container">

    <section id="content">

        <!-- Page Heading -->

        <section class="section page-heading animate-onscroll">

            <h3>Patient Stories</h3>

            <p class="breadcrumb"><a href="main-v1.html">Home</a> / Patient Stories</p>

        </section>

        <!-- Page Heading -->

        <!-- Section -->

        <section class="section full-width-bg gray-bg">

            <div class="row">

                <div class="col-lg-9 col-md-9 col-sm-12">

                    <div class="row">

                        @foreach ($pam as $ambassador)

                        <div class="col-sm-12 col-md-4 mb-4">

                            <div class="card" style="width:250px; height:450px;">

                                <img src="{{ asset(Storage::url($ambassador->image)) }}" alt="" class="card-img-top" width="250" height="250px">

                                <div class="card-body">

                                    <h4 class="card-title"><span style="color: #274472;"><b>{{ $ambassador->name }}</b> </h4>

                                    <p class="card-text" style="text-align: justify; width:200px; ">{{ Str::limit($ambassador->message, 100) }}</p>

                                    <a href="{{ route('ambassador.show', $ambassador->id) }}" class="btn btn-primary">Know More</a>

                                </div>

                            </div>

                        </div>

                        @endforeach

                        <div class="col-sm-12 col-md-4 mb-4">

<div class="card" style="width:250px; height:450px;">

    <img src="{{ asset('asset/img/demo.png') }}" alt="" class="card-img-top" width="250" height="250px">

    <div class="card-body">

        <h4 class="card-title"><span style="color: #274472;"><b><a href="{{asset(route('sunilBlog.show'))}}">Mr. Ajay</a></b> </span></h4>

        <p class="card-text" style="text-align: justify; width:200px; ">Hi, I’m Ajay, and I’ve been living with myositis for over five years now. When I was first diagnosed in 2019...</p>

        <a href="{{asset(route('ajay'))}}" class="btn btn-primary">Know More</a>

    </div>

</div>

</div>


                        <div class="col-sm-12 col-md-4 mb-4">

                            <div class="card" style="width:250px; height:450px;">

                                <img src="{{ asset('asset/img/pt1.jpg') }}" alt="" class="card-img-top" width="250" height="250px">

                                <div class="card-body">

                                    <h4 class="card-title"><span style="color: #274472;"><b><a href="{{asset(route('sunilBlog.show'))}}">Mr. Sunil</a></b> </span></h4>

                                    <p class="card-text" style="text-align: justify; width:200px; ">Hello everyone, I’m Sunil a 25-year-old who once had my sights set firmly on my dreams and career goals...</p>

                                    <a href="{{asset(route('sunilBlog.show'))}}" class="btn btn-primary">Know More</a>

                                </div>

                            </div>

                        </div>





                        <div class="col-sm-12 col-md-4 mb-4">

                            <div class="card" style="width:250px; height:450px;">

                                <img src="{{ asset('asset/img/DamchenPatient.png') }}" alt="" class="card-img-top" width="250" height="250px">

                                <div class="card-body">

                                    <h4 class="card-title"><span style="color: #274472;"><b><a href="{{asset(route('Damchen.show'))}}">Mrs.Damchen</a></b> </span></h4>

                                    <p class="card-text" style="text-align: justify; width:200px; ">After visiting several physicians and undergoing many tests, Damchen was diagnosed with the disease ‘Polymyositis’, ..</p>

                                    <a href="{{asset(route('Damchen.show'))}}" class="btn btn-primary">Know More</a>

                                </div>

                            </div>

                        </div>

                        <div class="col-sm-12 col-md-4 mb-4">

                            <div class="card" style="width:250px; height:450px;">

                                <img src="{{ asset('asset/img/shallyPuri.jpg') }}" alt="" class="card-img-top" width="250" height="250px">

                                <div class="card-body">

                                    <h4 class="card-title"><span style="color: #274472;"><b><a href="{{asset(route('shallyPuri'))}}">Mrs.Shally Puri</a></b> </span></h4>

                                    <p class="card-text" style="text-align: justify; width:200px; "> I am a 37 year old woman and I was diagnosed with myositis after 3 years of suffering mentally and physically due.....</p>

                                    <a href="{{asset(route('shallyPuri'))}}" class="btn btn-primary">Know More</a>

                                </div>

                            </div>

                        </div>

                        <div class="col-sm-12 col-md-4 mb-4">

                            <div class="card" style="width:250px; height:450px;">

                                <img src="{{ asset('asset/img/blog/11.jpg') }}" alt="" class="card-img-top" width="250" height="250px">

                                <div class="card-body">

                                    <h4 class="card-title"><span style="color: #274472;"><b>Mr.Bharat Sharma</b> </span></h4>

                                    <p class="card-text" style="text-align: justify; width:200px; ">My name is Bharat Sharma, and I was diagnosed with myositis a few years ago.
                                        It all started with some mild muscle weakness...</p>

                                    <a href="{{asset(route('bharat'))}}" class="btn btn-primary">Know More</a>

                                </div>

                            </div>

                        </div>



                        <div class="col-sm-12 col-md-4 mb-4">

                            <div class="card" style="width:250px; height:450px;">

                                <img src="{{ asset('asset/img/blog/3.jpg') }}" alt="" class="card-img-top" width="250" height="250px">

                                <div class="card-body">

                                    <h4 class="card-title"><span style="color: #274472;"><b>Mrs.Isha Gupta</b> </span></h4>

                                    <p class="card-text" style="text-align: justify; width:200px; ">When I first heard the words "myositis", I felt like my world had turned

                                        upside down. But with the support of my loved ones ..</p>

                                    <a href="{{route('ishika')}}" class="btn btn-primary">Know More</a>

                                </div>

                            </div>

                        </div>





                        <div class="col-sm-12 col-md-4 mb-4">

                            <div class="card" style="width:250px; height:450px;">

                                <img src="{{ asset('asset/img/blog/2.jpg') }}" alt="" class="card-img-top" width="250" height="250px">

                                <div class="card-body">

                                    <h4 class="card-title"><span style="color: #274472;"><b>Mr.Ankit Oberoi</b> </span></h4>

                                    <p class="card-text" style="text-align: justify; width:200px; ">After years of struggling with myositis, I was finally able to find a

                                        treatment plan that worked for me. As I regained my strength..</p>

                                    <a href="{{route('ankit')}}" class="btn btn-primary">Know More</a>

                                </div>

                            </div>

                        </div>



                    </div>

                </div>

                <!-- Sidebar -->



                @include('myositis.sidebarforpages')



                <!-- /Sidebar -->

            </div>

        </section>

        <!-- /Section -->

    </section>

</div>

@endsection