@extends('layouts.master')

@section('content')

<div class="container">

    <section id="content">
        <!-- Page Heading -->
        <section class="section page-heading animate-onscroll">
            <h1>Patient Story </h1>
            <p class="breadcrumb"><a href="main-v1.html">Home</a> / Patient story / Mr. Sunil</p>
        </section>
        <!-- Page Heading -->
      
        <section class="section full-width-bg gray-bg">
            <div class="row">
                <div class="col-lg-12 col-md-12 col-sm-12">
                    <h3 class="animate-onscroll no-margin-top"> Mr. Sunil </h3>
                    <img class="align-left animate-onscroll" src="{{asset('asset/img/pt1.jpg')}}" alt="" style="width:250px; height: 250px;">
                    <p class="animate-onscroll">Hello everyone, I’m Sunil a 25-year-old who once had my sights set firmly on my dreams and career goals. However, in 2023, my path took an unexpected turn when I was diagnosed with myositis, a condition I knew little about but soon had to confront head-on. </p>
                   
                    <blockquote class="align-right italic animate-onscroll"> We are chosen for this battle because we are warriors, capable of fighting and overcoming any disease
                    </blockquote>
                    <p class="animate-onscroll" style="text-align:justify" >  It began with muscle pain, 12 Kg weight loss, inflammation, skin rashes, fatigue, and weakness. At first, I shrugged it off as everyday tiredness and sought help from a general physician. Despite taking antibiotics and painkillers, my symptoms worsened. Eating and swallowing became challenging, and my skin turned red with sun exposure. Even as the pain in my shoulders and thighs grew unbearable, I pushed on, struggling through daily tasks like eating, which took me hours to complete. By March 2023, my physician referred me to a rheumatologist. This decision which marked the beginning of my journey towards a correct diagnosis. After a comprehensive examination, the rheumatologist ordered tests specific to myositis. These tests were financially draining for me. The test came out to be positive for ANA profile, high TIF1 gamma antigen levels, and thrombocytopenia (i.e. very low platelet count). I was advised hospitalisation, but due to financial constraints, I opted for medication instead. My treatment regimen included Prednisolone, Mycophenolate Mofetil (which is an immunosuppressant), with weekly doctor visits. These drugs worked slowly for me and my health continued to decline day by day. Despite the immense pain, I maintained my positivity, although my fiancée was fully aware of the gravity of my condition. My parents, unfamiliar with myositis, mistook it for a common fever, making it difficult for me to explain the severity. Basic activities like walking, standing, and eating were monumental tasks for me. Even typing a leave request for work was tough for me due to inflamed fingers, and I had to stop riding my bike. Nevertheless, I persisted, personally buying my medications even on my toughest days. On July 5th, 2023, I lost consciousness and was hospitalised for 15 days during which I underwent intensive treatments, including IVIG therapy. I had a feeding tube inserted and endured painful procedures like bone marrow and muscle biopsies, and PET scans. During these tough times my family and friends never left my side. Post-discharge, I was prescribed Rituximab which caused stomach irritation, depression, acne, severe hair loss, blurry vision, and insomnia. After a brief rest, I returned to work, adapting to my new reality. I realised that not everyone’s life is same, and not my every day is same. We must face our critical situations head-on. I learned to listen to my body, follow my medication and physiotherapy routine, and attend health checkups alone but cheerfully. I learned to live with myositis and now I'm all about helping out my fellow myositis warriors! I attended every seminar about myositis in Hyderabad and, at IRACON2023, met Dr. Rohit Agarwal, who introduced Myositis India community to me. From my story, the key takeaway is the importance of correct diagnosis for effective treatment in the early stages. I now contribute to creating awareness by editing posts for Myositis India. It's a small step, but it matters. Raising awareness and advocating for myositis is crucial. Here are a few lessons from my experience: Early Diagnosis is the key: Don’t ignore symptoms. Seek specialised medical advice early. Support Systems Matter: Lean on family, friends, and support communities for strength. Advocacy Helps: Sharing your story and raising awareness can help others in their journey. Stay Positive: A positive attitude can make a significant difference in coping with the disease. Adapt and Persevere: Embrace your new reality, adapt to changes, and never give up. If you or someone you know is battling myositis, remember you’re not alone. Support and resources are available, and together, we can raise awareness, support each other, and fight this battle with resilience and hope. Thank you for reading my story. Let’s continue to stand strong and support one another. I believe recovery is possible with a strong motive and a positive attitude.
</p>
                </div>
            </div>


            @endsection