@extends('layouts.master')
@section('title', 'Meet the Team | Myositis India – Leaders in Patient Advocacy')
@section('description', 'Meet the dedicated team behind Myositis India, working to support patients and promote awareness across the country.')
@section('canonical', 'https://www.myositisindia.org/team')
@section('content')

<div class="container">
    <section id="content">
        <div class="container">
            <!-- Page Heading -->
            <section class="section page-heading animate-onscroll">
                <h1>Team</h1>
                <p class="breadcrumb"><a href="main-v1.html">Home</a> / Team</p>
            </section>
            <!-- Page Heading -->
            <!-- Section -->
            <div class="col-md-12 mb-4" style=" text-align:center;">
                    <h4 class="btn btn-primary">Board of Directors</h4>
                </div>
            <section class="section full-width-bg gray-bg">
                <div class="row">
                    <div class="col-lg-12 col-md-12 col-sm-12">
                        @foreach ($teamData as $team)
                        @if($team->joinAs === 'Team')
                        <div class="col-lg-3 col-md-3 col-sm-6">
                            <!-- Team Member -->
                            <div class="team-member animate-onscroll ">
                                <img src="{{ asset(Storage::url($team->image)) }}" alt="" class="img-fluid" width="340px;" height="250px;">
                                <div class="team-member-info">
                                    <h2 style="font-size: 21px;">{{$team->name}}</h2>
                                    <span class="job">{{$team->designation}}</span>
                                    <div class="team-member-more">
                                        <p>{{ implode(' ', array_slice(str_word_count($team->bio, 1), 0, 35)) }}</p>
                                        <a href="{{route('team_member.show',$team->id)}}" class="btn btn-primary">Know More</a>
                                    </div>
                                </div>
                            </div>
                            <!-- /Team Member -->
                        </div>
                        @endif
                        @endforeach

                    </div>
                </div>
            </section>


<!-- Core Team Section -->
<!-- Core Team Section -->
<section class="core-team-section">
    <h2 class="core-team-title">Core Team</h2>
    <div class="core-team-grid">
        <div class="core-team-card">
            <div class="core-team-image-wrapper">
                <img src="public/asset/img/team/sartaj.png" alt="Sartaj" class="core-team-image">
                <div class="member-hover-info">
                    <h3>Sartaj Akhtar</h3>
                    <p>Web developer & digital marketing expert passionate about creating user-friendly experiences.</p>
                </div>
            </div>
            <h3 class="core-team-name">Sartaj</h3>
            <p class="core-team-role">IT</p>
        </div>

        <div class="core-team-card">
            <div class="core-team-image-wrapper">
                <img src="public/asset/img/team/rutvij.png" alt="Kshitij" class="core-team-image">
                <div class="member-hover-info">
                    <h3>Rutvij Tope</h3>
                    <p>Doctor at BJGMC and Sassoon Hospital Pune I've been volunteering for Myositis India since Avid reader writer tennis player and amateur pianist

</p>
                </div>
            </div>
            <h3 class="core-team-name">Rutvij Tope</h3>
            <p class="core-team-role">Content Creation</p>
        </div>


        <div class="core-team-card">
            <div class="core-team-image-wrapper">
                <img src="public/asset/img/team/Kshitij.jpg" alt="Kshitij" class="core-team-image">
                <div class="member-hover-info">
                    <h3>Kshitij Kanuga</h3>
                    <p>Hey I am Kshitij Kanuga from NHLMMC Ahmedabad</p>
                </div>
            </div>
            <h3 class="core-team-name">Kshitij</h3>
            <p class="core-team-role">Webinars</p>
        </div>
        <div class="core-team-card">
            <div class="core-team-image-wrapper">
                <img src="public/asset/img/team/gukul.jpeg" alt="Rishi" class="core-team-image">
                <div class="member-hover-info">
                    <h3>Gokul</h3>
                    <p>Hello everyone, I am Dr. Gokulkrishna Nambiar, an MBBS graduate from B.J. Medical College, Pune, with a passion for digital outreach and patient advocacy. As the Head of Social Media and Content Distribution at Myositis India, I have had the privilege of leveraging digital platforms to amplify awareness about myositis and connect individuals across the globe. Through my efforts, I strive to foster an inclusive online space where patients, caregivers, and medical professionals can come together to share knowledge and find support.</p>
                </div>
            </div>
            <h3 class="core-team-name">Gokul</h3>
            <p class="core-team-role">Content Distribution</p>
        </div>

        
        <div class="core-team-card">
            <div class="core-team-image-wrapper">
                <img src="public/asset/img/team/rishi.jpg" alt="Rishi" class="core-team-image">
                <div class="member-hover-info">
                    <h3>Rishi Nalkande</h3>
                    <p>Intern Doctor at BJGMC and Sassoon General Hospital Pune Volunteer at Myositis India since Golfer footballer film enthusiast

</p>
                </div>
            </div>
            <h3 class="core-team-name">Rishi</h3>
            <p class="core-team-role">Patient Services</p>
        </div>

        <div class="core-team-card">
            <div class="core-team-image-wrapper">
                <img src="public/asset/img/team/vansaj.jpeg" alt="Vanshaj" class="core-team-image">
                <div class="member-hover-info">
                    <h3>Vanshaj</h3>
                    <p>I’m Dr. Vanshaj Sharma, Director, Academics and Research at Myositis India and a practicing physician at Shri Mahant Indiresh Hospital, Dehradun. I’ve been actively involved with Myositis India for over a year, and this journey has given me invaluable insights into patient care and the crucial role of community support in managing a rare muscle diseases like myositis. At the organization, I coordinate all academic activities, such as case presentation competition.</p>
                </div>
            </div>
            <h3 class="core-team-name">Vanshaj</h3>
            <p class="core-team-role">Academics</p>
        </div>
    </div>
</section>


<style>
/* SECTION */
.core-team-section {
    background-color: #f9f9f9;
    padding: 60px 20px;
    text-align: center;
}

.core-team-title {
    font-size: 20px;
    font-weight: 600;
    text-transform: uppercase;
    padding: 12px 24px;
    display: inline-block;
    margin-bottom: 40px;
    color: #fff;
    background-color: #337ab7;
    border: 1px solid #2e6da4;
    border-radius: 4px;
}

.core-team-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
    gap: 30px;
    max-width: 1100px;
    margin: 0 auto;
}

.core-team-card {
    background: #fff;
    border-radius: 8px;
    box-shadow: 0 2px 6px rgba(0, 0, 0, 0.08);
    overflow: hidden;
    transition: all 0.3s ease;
}

.core-team-image-wrapper {
    position: relative;
    height: 250px;
    overflow: hidden;
}

.core-team-image {
    width: 100%;
    height: 100%;
    object-fit: cover;
    display: block;
}

.member-hover-info {
    position: absolute;
    bottom: 0;
    left: 0;
    right: 0;
    background: rgba(255, 255, 255, 0.95);
    padding: 15px;
    transform: translateY(100%);
    transition: transform 0.4s ease;
    font-size: 14px;
    color: #333;
    text-align: left;
}

.core-team-image-wrapper:hover .member-hover-info {
    transform: translateY(0);
}

.core-team-name {
    font-size: 18px;
    font-weight: bold;
    color: #000;
    margin: 15px 0 5px;
}

.core-team-role {
    font-size: 14px;
    color: #777;
    margin-bottom: 15px;
}

@media (max-width: 480px) {
    .core-team-name {
        font-size: 16px;
    }

    .core-team-role {
        font-size: 13px;
    }

    .core-team-grid {
        gap: 20px;
    }
}

</style>



            <div class="col-md-12" style="  text-align:center;">
                <h4 class="btn btn-primary">VOLUNTEERS</h4>
            </div>
            <section class="section full-width-bg gray-bg">
                <div class="row">

                    <div class="col-lg-12 col-md-12 col-sm-12">



                        @foreach ($teamData as $team)
                        @if($team->joinAs === 'Volunteer')
                        <div class="col-lg-3 col-md-3 col-sm-6">
                            <!-- Team Member -->
                            <div class="team-member animate-onscroll ">
                                <img src="{{ asset(Storage::url($team->image)) }}" alt="" class="img-fluid" width="340px;" height="250px;">
                                <div class="team-member-info">
                                    <h2 style="font-size: 23px;">{{$team->name}}</h2>
                                    <span class="job">{{$team->designation}}</span>
                                    <div class="team-member-more">
                                        <p>{{ implode(' ', array_slice(str_word_count($team->bio, 1), 0, 35)) }}</p>
                                        <a href="{{route('team_member.show',$team->id)}}" class="btn btn-primary">Know More</a>
                                    </div>
                                </div>
                            </div>
                            <!-- /Team Member -->
                        </div>
                        @endif
                        @endforeach

                    </div>
                </div>
            </section>
        </div>
    </section>
</div>
@endsection