@extends('layouts.master')
@section('title', 'World Myositis Day 2024 | Awareness, Events & Patient Voices | Myositis India')
@section('description', 'Learn about World Myositis Day 2024 events and how you can participate in raising awareness.')
@section('canonical', 'https://www.myositisindia.org/word-myositis-day-2024')

@section('content')
<div class="container">
    <section id="content">
    <h1 class="text-center" >World Myositis Day 2024</h1>
<hr style="border: 1px solid #337ab7; width: 50%; margin: 10px auto;">

        
        <p style="text-align: justify;">
        World Myositis Day: Empowering Warriors, Spreading Awareness

On World Myositis Day, Myositis India joined hands with our brand ambassador, the inspiring Samantha Ruth Prabhu, to shine a spotlight on myositis, a rare and often misunderstood condition. Samantha, a celebrated Indian actress and a myositis warrior herself, helped us amplify our mission to spread awareness and provide hope to countless patients.

As part of our efforts, we also shared a heartfelt interview with a courageous myositis warrior on our YouTube channel, highlighting the resilience and strength of those living with this condition. Through such initiatives, Myositis India continues its commitment to improving the lives of patients by educating the public, fostering a supportive community, and advocating for better access to diagnosis and treatment in India.

Together, let’s keep raising our voices for myositis warriors and building a world of understanding and support.
        </p>
        <!-- Posts Section -->
        <div class="row">
            <h2>Posts</h2>
            <div class="col-md-4">
                <img src="{{asset('asset/img/wordmyoday1.jpg')}}" 
                     class="img-responsive post-image shadowed" 
                     data-toggle="modal" 
                     data-target="#imageModal" 
                     data-image="{{asset('asset/img/wordmyoday1.jpg')}}" 
                     alt="Post 1">
            </div>
            <div class="col-md-4">
                <img src="{{asset('asset/img/wordmyoday2.jpg')}}" 
                     class="img-responsive post-image shadowed" 
                     data-toggle="modal" 
                     data-target="#imageModal" 
                     data-image="{{asset('asset/img/wordmyoday2.jpg')}}" 
                     alt="Post 2">
            </div>
        </div>

        <!-- Modal for Image Viewer -->
        <div class="modal fade" id="imageModal" tabindex="-1" role="dialog" aria-labelledby="imageModalLabel">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body text-center">
                        <img id="modalImage" src="" class="img-responsive" alt="Expanded Image">
                    </div>
                </div>
            </div>
        </div>

         
    </section>
</div>

<style>
    /* Add shadow and spacing to the images */
    .shadowed {
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        transition: box-shadow 0.3s ease, transform 0.3s ease;
        margin-bottom: 20px;
        border-radius: 8px;
    }

    /* Hover effect for images */
    .shadowed:hover {
        box-shadow: 0 8px 12px rgba(0, 0, 0, 0.2);
        transform: scale(1.05);
    }

    /* Modal image styling */
    #modalImage {
        border-radius: 10px;
        box-shadow: 0 8px 15px rgba(0, 0, 0, 0.3);
    }

    /* Section headings */
    h2 {
        margin-top: 30px;
        margin-bottom: 20px;
        color: #444;
        font-weight: bold;
        text-align: left;
    }

    /* Add padding to the container for better spacing */
    .container {
        padding-top: 30px;
        padding-bottom: 30px;
    }
</style>

<script>
    $(document).ready(function () {
        // Set image in the modal when a thumbnail is clicked
        $('.post-image').on('click', function () {
            const imageSrc = $(this).data('image');
            $('#modalImage').attr('src', imageSrc);
        });
    });
</script>
@endsection
