<?php

use App\Http\Controllers\AdminController;
use App\Http\Controllers\AdminEmailController;
use App\Http\Controllers\AppointmentController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Auth\RegisterController;
use App\Http\Controllers\CityController;
use App\Http\Controllers\CountryController;
use App\Http\Controllers\DiseaseController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\PatientController;
use App\Http\Controllers\PhysicianController;
use App\Http\Controllers\StateController;
use App\Http\Controllers\DoctorController;
use App\Http\Controllers\CommentController;
use App\Http\Controllers\DonateController;
use App\Http\Controllers\EnquiryController;
use App\Http\Controllers\ExportController;
use App\Http\Controllers\TeamMemberController;
use App\Http\Controllers\VideoController;
use App\Http\Controllers\VolunteerController;
use App\Http\Controllers\ResetPasswordController;
use App\Http\Controllers\ForgotPasswordController;
use App\Http\Controllers\GalleryController;
use App\Http\Controllers\InstagramController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\GoogleFormController;
use App\Http\Controllers\MabController;
use App\Http\Controllers\PatientAmbassadorController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\YouTubeController;
use App\Models\PatientAmbassador;
use Laravel\Socialite\Facades\Socialite;
use App\Http\Controllers\PatientResourcesController;
use App\Http\Controllers\ExpertRheumatologistsController;
use App\Http\Controllers\ArticleController;
use App\Http\Controllers\ExpertDoctorsAnotherfiledController;




/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
 

//Pages
 
Route::get('link',function(){
    Artisan::call('storage:link');
});
Route::get('shared_myositis_india_files', [HomeController::class, 'shared_myositis_india_files'])->name('shared_myositis_india_files');

Route::get('/', [HomeController::class, 'index'])->name('home');

Route::get('patient-registration', [RegisterController::class, 'index'])->name('register');
Route::post('patient-registration', [RegisterController::class, 'register'])->name('user.register');
Route::get('doctor-registration', [RegisterController::class, 'doctorregistration'])->name('doctorregistration');

Route::post('api/fetch-state',[RegisterController::class,'fatchState']);
Route::post('api/fetch-cities',[RegisterController::class,'fatchCity']);

Route::get('login', [LoginController::class, 'index'])->name('login');
Route::post('login', [LoginController::class, 'login'])->name('user.login');

 


Route::get('/forgot-password', [ForgotPasswordController::class ,'showLinkRequestForm'])->name('password.request');
Route::post('/forgot-password', [ForgotPasswordController::class , 'sendResetLinkEmail'])->name('password.email');
Route::get('/reset-password/{token}', [ResetPasswordController::class ,'showResetForm'])->name('password.reset');
Route::post('/reset-password', [ResetPasswordController::class, 'reset'])->name('password.update');




Route::get('admin/login', [AdminController::class, 'index'])->name('admin');
Route::post('admin/login', [AdminController::class, 'login'])->name('admin.login');

Route::group(['middleware' => ['auth']], function () {
    Route::group(['prefix' => 'patient', 'as' => 'patient.'], function () {
        Route::get('patient/dashboard', [PatientController::class, 'index'])->name('dashboard');
        //Backend Appointment Form
        Route::post('patient/appointment/store',[PatientController::class ,'store'])->name('backend.appointment.create');
      

    });
    Route::group(['prefix' => 'doctor', 'as' => 'doctor.'], function () {
        Route::get('doctor/dashboard', [PhysicianController::class, 'index'])->name('dashboard');
    });
    Route::group(['prefix' => 'volunteer', 'as' => 'volunteer.'], function () {
        Route::get('volunteer/dashboard', [VolunteerController::class, 'volunteer'])->name('dashboard');
      
    });
    Route::get('logout', [LoginController::class, 'logout'])->name('logout');

    Route::get('team/show/list',[TeamMemberController::class , 'listShow'])->name('team.show'); 
    Route::get('team/edit/{id}',[TeamMemberController::class , 'edit'])->name('team.edit'); 
    Route::post('team/update/{id}',[TeamMemberController::class , 'update'])->name('team.update'); 
    Route::delete('team/delete/{id}',[TeamMemberController::class , 'delete'])->name('team.delete');
    
    
    

});


Route::group(['middleware' => ['auth']], function () {
    Route::group(['prefix' => 'admin', 'as' => 'admin.'], function () {
        Route::get('dashboard', [AdminController::class, 'dashboard'])->name('dashboard');

        Route::get('city', [CityController::class, 'index'])->name('city');
        Route::get('city/craete', [CityController::class, 'create'])->name('city.create');
        Route::post('city/store', [CityController::class, 'store'])->name('city.store');
        Route::get('city/edit/{id}', [CityController::class, 'edit'])->name('city.edit');
        Route::post('city/update', [CityController::class, 'update'])->name('city.update');
        Route::get('city/status/{id}/{status}', [CityController::class, 'status'])->name('city.status');

        Route::get('state', [StateController::class, 'index'])->name('state');
        Route::get('state/craete', [StateController::class, 'create'])->name('state.create');
        Route::post('state/store', [StateController::class, 'store'])->name('state.store');
        Route::get('state/edit/{id}', [StateController::class, 'edit'])->name('state.edit');
        Route::post('state/update', [StateController::class, 'update'])->name('state.update');
        Route::get('state/status/{id}/{status}', [StateController::class, 'status'])->name('state.status');

        Route::get('country', [CountryController::class, 'index'])->name('country');
        Route::get('country/craete', [CountryController::class, 'create'])->name('country.create');
        Route::post('country/store', [CountryController::class, 'store'])->name('country.store');
        Route::get('country/edit/{id}', [CountryController::class, 'edit'])->name('country.edit');
        Route::post('country/update', [CountryController::class, 'update'])->name('country.update');
        Route::get('country/status/{id}/{status}', [CountryController::class, 'status'])->name('country.status');

        Route::get('disease', [DiseaseController::class, 'index'])->name('disease');
        Route::get('disease/craete', [DiseaseController::class, 'create'])->name('disease.create');
        Route::post('disease/store', [DiseaseController::class, 'store'])->name('disease.store');
        Route::get('disease/edit/{id}', [DiseaseController::class, 'edit'])->name('disease.edit');
        Route::post('disease/update', [DiseaseController::class, 'update'])->name('disease.update');
        Route::get('disease/status/{id}/{status}', [DiseaseController::class, 'status'])->name('disease.status');

        Route::get('appointment', [AppointmentController::class, 'show'])->name('appointment.show');
        Route::get('appointment/craete', [AppointmentController::class, 'create'])->name('appointment.create');
        Route::post('appointment/store', [AppointmentController::class, 'store'])->name('appointment.store');
        Route::get('appointment/edit/{id}', [AppointmentController::class, 'edit'])->name('appointment.edit');
        Route::post('appointment/update', [AppointmentController::class, 'update'])->name('appointment.update');
        Route::get('appointment/status/{id}/{status}', [AppointmentController::class, 'status'])->name('appointment.status');
 
         // Example route
        
        


        
    });
    Route::get('logout', [LoginController::class, 'logout'])->name('logout');
   
});

Route::get('appointment', [AppointmentController::class, 'index'])->name('appointment');
Route::post('appointment/store', [AppointmentController::class, 'store'])->name('appointment.store');






// Route::get('physician-registration', [HomeController::class, 'physician'])->name('physician.registration');
// Route::get('physician-login', [HomeController::class, 'physician_login'])->name('physician.login');


Route::get('about', [HomeController::class, 'about'])->name('about');
Route::get('contact', [HomeController::class, 'contact'])->name('contact');
Route::get('mission', [HomeController::class, 'mission'])->name('mission');

Route::get('blog', [HomeController::class, 'blog'])->name('blog');
Route::get('blog/understanding-myositis', [HomeController::class, 'blogone'])->name('blogone');
Route::get('the-importance-blog', [HomeController::class, 'blogtwo'])->name('blogtwo');
Route::get('myositis-and-exercise-blog', [HomeController::class, 'blogthree'])->name('blogthree');
Route::get('samantha', [HomeController::class, 'samantha'])->name('samantha');

//vounteer
Route::get('volunteer', [HomeController::class, 'volunteer'])->name('volunteer');

Route::get('termcondition', [HomeController::class, 'termcondition'])->name('termcondition');
//donate
Route::get('donate', [DonateController::class, 'donate'])->name('donate');
Route::get('donate/online', [DonateController::class, 'donateonline'])->name('donate.online');
Route::post('/validate-pan', [DonateController::class, 'store'])->name('donate-online');


Route::get('/show/qrcode', [DonateController::class, 'showQRcode'])->name('showQRcode.show');


//Myositis Pages
Route::get('about-myositis', [HomeController::class, 'aboutmyositis'])->name('aboutmyositis');
Route::get('types-of-myositis', [HomeController::class, 'typesofmyositis'])->name('typesofmyositis');
//types of myositis Route
Route::get('dermato-myositis', [HomeController::class, 'Dermatomyositis'])->name('dermatomyositis');
Route::get('poly-myositis', [HomeController::class, 'Polymyositis'])->name('polymyositis');
Route::get('necrotizing-myopathy', [HomeController::class, 'NecrotizingMyopathy'])->name('necrotizingmyopathy');
Route::get('inclusion-body-myositis', [HomeController::class, 'InclusionBodyMyositis'])->name('inclusionbodymyositis');
Route::get('juvenile-byositi', [HomeController::class, 'JuvenileMyositis'])->name('juvenilemyositis');
//diagnosis 
Route::get('diagnosis-of-myositis', [HomeController::class, 'diagnosis'])->name('diagnosis');
//complication
Route::get('complication-of-myositis', [HomeController::class, 'complication'])->name('complication');
 
//Patients
Route::get('myositis-india-patient-Damchen', [HomeController::class, 'damchen'])->name('Damchen.show');
Route::get('myositis-india-patient-bharat', [HomeController::class, 'bharatsharma'])->name('bharat');
Route::get('myositis-india-patient-ishika', [HomeController::class, 'ishika'])->name('ishika');
Route::get('myositis-india-patient-ankit', [HomeController::class, 'ankit'])->name('ankit');
Route::get('myositis-india-patient-ajay', [HomeController::class, 'ajay'])->name('ajay');

Route::get('myositis-india-patient-sarika', [HomeController::class, 'sarika'])->name('sarika');
Route::get('myositis-india-patient-rishi', [HomeController::class, 'rishi'])->name('rishi');
Route::get('myositis-india-patient-shallyPuri', [HomeController::class, 'shallyPuri'])->name('shallyPuri');
Route::get('patient-story', [HomeController::class, 'patientstory'])->name('patientstory');
Route::get('myositis-treatment',[HomeController::class ,'myotreatment'])->name('myotreatment');

Route::get('myositis-oppointment',[HomeController::class, 'showAppointmentPage'])->name('AppointmentPage.show');


Route::get('doctor-doctor-list/',[DoctorController::class , 'doctorlist'])->name('doctorlist');
Route::get('volunteer-list/',[VolunteerController::class , 'volunteerlist'])->name('volunteerlist');
Route::get('patient-patient-list/',[PatientController::class , 'patientlist'])->name('patientlist');
 
 
Route::post('commentstore',[CommentController::class , 'commentstore'])->name('commentstore');

Route::get('/videos', [VideoController::class,'index'])->name('videos.index');
Route::get('/youtube-videos', [VideoController::class, 'fetchYouTubeVideos']);

Route::get('/export-doctors', [ExportController::class,'exportDoctors'])->name('export.doctors');
Route::get('/export-volunteers', [ExportController::class,'exportVolunteers'])->name('export.volunteers');
Route::get('/export-patients', [ExportController::class,'exportPatients'])->name('export.patients');
Route::delete('/patients/delete-multiple', [PatientController::class, 'deleteMultiple'])->name('patients.deleteMultiple');
Route::delete('/patients/{id}', [PatientController::class, 'destroy'])->name('patients.destroy');




Route::get('/export-Mab', [ExportController::class,'exportMab'])->name('export.mab');

Route::post('/send-emails', [AdminController::class, 'sendEmails'])->name('send-emails');
Route::get('/email/index', [AdminController::class, 'emailIndex'])->name('email.index');


//patient Amabassdor routes//

Route::get('patient-ambassadors',[PatientAmbassadorController::class,'index'])->name('ambassadors.patient');
Route::get('create-patientambassadors',[PatientAmbassadorController::class,'create'])->name('patientambassadors.create');
Route::post('store-patientambassdors',[PatientAmbassadorController::class,'store'])->name('ambassador.store');
Route::delete('patientambassador-delete/{id}',[PatientAmbassadorController::class ,'destroy'])->name('patientambassadors.destroy');

Route::get('myositisindia-patientambassdor/{id}',[PatientAmbassadorController::class, 'show'])->name('ambassador.show');
Route::get('myositis-india/patient/ambassdor',[PatientAmbassadorController::class , 'patientambassdorshow'])->name('patientambassdorshow');


 
Route::get('create/mab',[MabController::class, 'create'])->name('mab.create');
Route::post('create/store',[MabController::class, 'store'])->name('mab.store');
Route::get('create/list',[MabController::class, 'mablist'])->name('mab.list');
Route::get('edit/mab/{id}',[MabController::class, 'edit'])->name('mab.edit');
Route::post('create/update/{id}',[MabController::class, 'update'])->name('mab.update');
Route::get('mab/show',[MabController::class , 'show'])->name('mab.show');
Route::get('mab-member/{id}',[MabController::class, 'mab_member_show'])->name('mab_member.show');



Route::get('team', [TeamMemberController::class, 'team'])->name('team');
Route::get('team-member/{id}',[TeamMemberController::class, 'show'])->name('team_member.show');
Route::get('team/create',[TeamMemberController::class , 'create'])->name('team.create');
Route::post('team/store',[TeamMemberController::class , 'store'])->name('team.store'); 

Route::post('enquiry/store',[EnquiryController::class , 'store'])->name('enquiry.store');
Route::get('myositisindia/appointment/form',[EnquiryController::class , 'show'])->name('enquiry.show');
Route::post('myositisindia/appointment/store',[EnquiryController::class , 'enquiryStore'])->name('enquiry.store');
//Enqury show for Admin

Route::get('myositisindia/admin/show/appointment',[EnquiryController::class , 'enquiryShow'])->name('enquiryShow.show');



Route::get('admin/webinar-form',[HomeController::class ,'googleFormshow'])->name('admin.googleForm.show');




Route::get('volunteer/webinar', [VolunteerController::class, 'upcomingWebinar'])->name('upcomingWebinar.show');
Route::get('patient/webinar', [PatientController::class, 'ptWebinar'])->name('ptWebinar.show');
Route::get('doctor/webinar', [DoctorController::class, 'doctorWebinar'])->name('doctorWebinar.show');





Route::get('/auth/instagram', function () {
    return Socialite::driver('facebook')
        ->scopes(['instagram_basic', 'instagram_content_publish'])
        ->redirect();
});

// Route to handle the callback from Instagram
Route::get('/callback', function () {
    $user = Socialite::driver('facebook')->user();

    // Save the user access token to use for Instagram API requests
    // $user->token contains the access token
    // Implement your saving logic here

    // Redirect or display a success message
});

// routes/web.php

Route::get('/callback', 'Auth\SocialiteController@handleCallback');


 

 





 
// routes/web.php
 

Route::get('/instagram', [InstagramController::class, 'displayMedia'])->name('instagram.video');
Route::get('/youtube', [YouTubeController::class, 'index'])->name('youtube.video');


Route::get('/payment', [PaymentController::class, 'showPaymentForm'])->name('payment.form');
Route::post('/payment/initiate', [PaymentController::class, 'initiatePayment'])->name('payment.initiate');
Route::post('/payment/response', [PaymentController::class, 'handlePaymentResponse'])->name('payment.response');

//blog routes
Route::get('samantha/myositisdiagnosis',[BlogController::class , 'samanthaBlog1'])->name('samantha.blog.show');


//Case Presentation Route

Route::get('case-presentation',[HomeController::class ,'casePresentation'])->name('casePresentation.show');
Route::get('case-presentation-winner',[HomeController::class ,'casePresentationWinner'])->name('casePresentationWinner.show');



Route::get('newsletter',[HomeController::class ,'newsLetter'])->name('newsLetter.show');

//Google form

Route::get('google-form',[HomeController::class,'googleForm'])->name('googleForm.show');
Route::post('google-form',[HomeController::class,'googleFormStore'])->name('googleForm.store');


Route::get('sunil-patient-story',[BlogController::class , 'sunilBlog'])->name('sunilBlog.show');

Route::get('myositis-india-webinars',[HomeController::class , 'webinars'])->name('webinar.show');
Route::get('patient-resources',[PatientResourcesController::class , 'index'])->name('patientResources.show');
Route::get('Basic-exercise-blueprint-for-Myositis-patients',[PatientResourcesController::class , 'excerciseBluePrint'])->name('excerciseBluePrint.show');


Route::get('word-myositis-day-2024',[HomeController::class, 'worldMyoday'])->name('worldMyoday.show');
Route::get('team1',[TeamMemberController::class , 'team1'])->name('team1.show'); 
Route::get('team2',[TeamMemberController::class , 'team2'])->name('team2.show'); 

Route::get('expert-rheumatologists', [ExpertRheumatologistsController::class, 'index'])->name('expert-rheumatologists');
Route::get('/article', [ArticleController::class, 'show'])->name('article');
Route::get('expert-doctors-anotherfiled', [ExpertDoctorsAnotherfiledController::class, 'index'])->name('expert-doctors-anotherfiled');

