<?php $__env->startSection('content'); ?>
    <div class="page-wrapper">
        <div class="content">
            <div class="page-header">
                <div class="row">
                    <div class="col-sm-12">
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="doctors.html">Volunteers </a>
                            </li>
                            <li class="breadcrumb-item">
                                <i class="feather-chevron-right"></i>
                            </li>
                            <li class="breadcrumb-item active">Volunteers List</li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-12">
                    <div class="card card-table show-entire">
                        <div class="card-body">
                            <div class="page-table-header mb-2">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <div class="doctor-table-blk">
                                            <h3>Volunteers List</h3>
                                            <div class="doctor-search-blk">
                                                <div class="top-nav-search table-search-blk">
                                                    <form >
                                                        <input type="text" class="form-control"
                                                            placeholder="Search here" />
                                                        <a class="btn"><img src="<?php echo e(asset('backend/assets/img/icons/search-normal.svg')); ?>"
                                                                alt="" /></a>
                                                    </form>
                                                </div>
                                               
                                                <div class="add-group">
                                                    <span style="background-color: rgb(78, 56, 172); color:white; border:2px solid rgb(78, 56, 172); border-radius:3px;">Total Doctors : <?php echo e($volunteerlist->count()); ?></span>
                                                </div>
                                            </div>
                                           
                                        </div>
                                    </div>
                                    <div class="col-auto text-end float-end ms-auto download-grp">
                                        <a href="<?php echo e(route('export.volunteers')); ?>" class="me-2"><img src="<?php echo e(asset('backend/assets/img/icons/pdf-icon-01.svg')); ?>"
                                                alt="" /></a>
                                        <a href="<?php echo e(route('export.volunteers')); ?>" class="me-2"><img src="<?php echo e(asset('backend/assets/img/icons/pdf-icon-02.svg')); ?>"
                                                alt="" /></a>
                                        <a href="<?php echo e(route('export.volunteers')); ?>" class="me-2"><img src="<?php echo e(asset('backend/assets/img/icons/pdf-icon-03.svg')); ?>"
                                                alt="" /></a>
                                        <a href="<?php echo e(route('export.volunteers')); ?>"><img src="<?php echo e(asset('backend/assets/img/icons/pdf-icon-04.svg')); ?>"
                                                alt="" /></a>
                                    </div>
                                </div>
                            </div>

                            <div class="table-responsive">
                                <table class="table border-0 custom-table comman-table datatable mb-0">
                                    <thead>
                                        <tr>

                                            <th>Name</th>
                                            <th>Mobile</th>
                                            <th>Email</th>
                                            <th>Country</th>
                                            <th>State</th>
                                            <th>Timestamp</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $volunteerlist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $volunteer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>


                                                <td class="profile-image">

                                                    <?php echo e($volunteer->fname); ?> <?php echo e($volunteer->lname); ?>

                                                </td>
                                                <td> <a href="https://api.whatsapp.com/send?phone=<?php echo e($volunteer->phone); ?>"
                                                        target="_blank" class="btn btn-success">
                                                        <i class="fab fa-whatsapp fa-sm"></i>


                                                    </a><?php echo e($volunteer->phone); ?>


                                                </td>

                                                <td>
                                                    <a href="mailto:<?php echo e($volunteer->email); ?>"><?php echo e($volunteer->email); ?>

                                                        <i class="far fa-envelope"></i>
                                                    </a>
                                                </td>



                                                <td> <?php echo e(isset($volunteer->country->name) ? $volunteer->country->name : 'not selected'); ?>

                                                </td>

                                                <td><?php echo e(isset($volunteer->state->name) ? $volunteer->state->name : 'not selected'); ?>


                                                </td>

                                                
<td><?php echo e($volunteer->created_at->format('d-m-Y')); ?></td>
                                                <td class="text-end">
                                                    <button class="btn btn-primary" data-bs-toggle="modal"
                                                        data-bs-target="#exampleModal<?php echo e($volunteer->id); ?>"> View</button>
                                                </td>
                                                <div class="modal fade" id="exampleModal<?php echo e($volunteer->id); ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                    <div class="modal-dialog modal-lg">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h1 class="modal-title fs-5" id="exampleModalLabel">Volunteer Details</h1>
                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <div class="row">
                                                                    <div class="col-md-4">
                                                                        <label for="name">Name</label>
                                                                        <input type="text" class="form-control" id="name"
                                                                            value="<?php echo e($volunteer->fname); ?> <?php echo e($volunteer->lname); ?>" readonly>
                                                                    </div>
                                                                    <div class="col-md-4">
                                                                        <label for="phone">Phone</label>
                                                                        <input type="text" class="form-control" id="phone" value="<?php echo e($volunteer->phone); ?>"
                                                                            readonly>
                                                                    </div> 
                                                                    <div class="col-md-4">
                                                                        <label for="email">Email</label>
                                                                        <input type="email" class="form-control" id="email" value="<?php echo e($volunteer->email); ?>"
                                                                            readonly>
                                                                    </div>
                                                                    
                                                                    <div class="col-md-4">
                                                                        <label for="country">Country</label>
                                                                        <input type="text" class="form-control" id="country"
                                                                            value="<?php echo e(isset($volunteer->country->name) ? $volunteer->country->name : 'not selected'); ?>" readonly>
                                                                    </div>
                                                                    <div class="col-md-4">
                                                                        <label for="state">State</label>
                                                                        <input type="text" class="form-control" id="state"
                                                                            value="<?php echo e(isset($volunteer->state->name) ? $volunteer->state->name : 'not selected'); ?>" readonly>
                                                                    </div>
                                                                    <div class="col-md-4">
                                                                        <label for="city">City</label>
                                                                        <input type="text" class="form-control" id="city"
                                                                            value="<?php echo e(isset($volunteer->city->name) ? $volunteer->city->name : 'not selected'); ?>" readonly>
                                                                    </div>
                                                                    
                                                                    <div class="col-md-4">
                                                                        <label for="gender">Gender</label>
                                                                        <input type="text" class="form-control" id="gender"
                                                                            value="<?php echo e($volunteer->gender); ?>" readonly>
                                                                    </div>
                                                                   
                                                                    <div class="col-md-4">
                                                                        <label for="gender"> Age  </label>
                                                                        <input type="text" class="form-control" id="gender"
                                                                            value="<?php echo e($volunteer->dob); ?>" readonly>
                                                                    </div>
                                                                   
                                                                  
                                                                    <div class="col-md-12">
                                                                        <label for="message">Message</label>
                                                                        <textarea class="form-control" id="message" rows="3" readonly><?php echo e($volunteer->message); ?></textarea>
                                                                    </div>
                                        
                                        
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                        
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
       
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/madalozy/myositisindia.org/resources/views/backend/admin/volunteer/volunteerlist.blade.php ENDPATH**/ ?>